/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.pig.Main;

public class PigMainWithOldAPI
extends LauncherMain {
    private static final Set<String> DISALLOWED_PIG_OPTIONS = new HashSet<String>();
    private static final String JOB_ID_LOG_PREFIX = "HadoopJobId: ";

    public static void main(String[] args) throws Exception {
        PigMainWithOldAPI.run(PigMainWithOldAPI.class, (String[])args);
    }

    protected void run(String[] args) throws Exception {
        String logFile;
        FileOutputStream os;
        block22: {
            String[] pigArgs;
            String[] params;
            System.out.println();
            System.out.println("Oozie Pig action configuration");
            System.out.println("=================================================================");
            Configuration actionConf = new Configuration(false);
            String actionXml = System.getProperty("oozie.action.conf.xml");
            if (actionXml == null) {
                throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
            }
            if (!new File(actionXml).exists()) {
                throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
            }
            actionConf.addResource(new Path("file:///", actionXml));
            Properties pigProperties = new Properties();
            for (Map.Entry entry : actionConf) {
                pigProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            if (System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
                pigProperties.setProperty("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
                System.out.println("------------------------");
                System.out.println("Setting env property for mapreduce.job.credentials.binary to:" + System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
                System.out.println("------------------------");
                System.setProperty("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
            } else {
                System.out.println("Non-kerberoes execution");
            }
            os = new FileOutputStream("pig.properties");
            pigProperties.store(os, "");
            ((OutputStream)os).close();
            System.out.println();
            System.out.println("pig.properties content:");
            System.out.println("------------------------");
            pigProperties.store(System.out, "");
            System.out.flush();
            System.out.println("------------------------");
            System.out.println();
            ArrayList<String> arguments = new ArrayList<String>();
            String script = actionConf.get("oozie.pig.script");
            if (script == null) {
                throw new RuntimeException("Action Configuration does not have [oozie.pig.script] property");
            }
            if (!new File(script).exists()) {
                throw new RuntimeException("Error: Pig script file [" + script + "] does not exist");
            }
            System.out.println("Pig script [" + script + "] content: ");
            System.out.println("------------------------");
            BufferedReader br = new BufferedReader(new FileReader(script));
            String line = br.readLine();
            while (line != null) {
                System.out.println(line);
                line = br.readLine();
            }
            br.close();
            System.out.println("------------------------");
            System.out.println();
            arguments.add("-file");
            arguments.add(script);
            for (String param : params = MapReduceMain.getStrings((Configuration)actionConf, (String)"oozie.pig.params")) {
                arguments.add("-param");
                arguments.add(param);
            }
            String hadoopJobId = System.getProperty("oozie.launcher.job.id");
            if (hadoopJobId == null) {
                throw new RuntimeException("Launcher Hadoop Job ID system property not set");
            }
            logFile = new File("pig-oozie-" + hadoopJobId + ".log").getAbsolutePath();
            URL log4jFile = Thread.currentThread().getContextClassLoader().getResource("log4j.properties");
            if (log4jFile != null) {
                String pigLogLevel = actionConf.get("oozie.pig.log.level", "INFO");
                Properties hadoopProps = new Properties();
                hadoopProps.load(log4jFile.openStream());
                hadoopProps.setProperty("log4j.logger.org.apache.pig", pigLogLevel + ", A, B");
                hadoopProps.setProperty("log4j.appender.A", "org.apache.log4j.ConsoleAppender");
                hadoopProps.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout");
                hadoopProps.setProperty("log4j.appender.A.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
                hadoopProps.setProperty("log4j.appender.B", "org.apache.log4j.FileAppender");
                hadoopProps.setProperty("log4j.appender.B.file", logFile);
                hadoopProps.setProperty("log4j.appender.B.layout", "org.apache.log4j.PatternLayout");
                hadoopProps.setProperty("log4j.appender.B.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
                String localProps = new File("piglog4j.properties").getAbsolutePath();
                FileOutputStream os1 = new FileOutputStream(localProps);
                hadoopProps.store(os1, "");
                ((OutputStream)os1).close();
                arguments.add("-log4jconf");
                arguments.add(localProps);
                File localDir = new File(localProps).getParentFile();
                System.out.println("Current (local) dir = " + localDir.getAbsolutePath());
            } else {
                System.out.println("log4jfile is null");
            }
            String pigLog = "pig-" + hadoopJobId + ".log";
            arguments.add("-logfile");
            arguments.add(pigLog);
            for (String pigArg : pigArgs = MapReduceMain.getStrings((Configuration)actionConf, (String)"oozie.pig.args")) {
                if (DISALLOWED_PIG_OPTIONS.contains(pigArg)) {
                    throw new RuntimeException("Error: Pig argument " + pigArg + " is not supported");
                }
                arguments.add(pigArg);
            }
            System.out.println("Pig command arguments :");
            for (String arg : arguments) {
                System.out.println("             " + arg);
            }
            System.out.println("=================================================================");
            System.out.println();
            System.out.println(">>> Invoking Pig command line now >>>");
            System.out.println();
            System.out.flush();
            try {
                System.out.println();
                this.runPigJob(new String[]{"-version"});
            }
            catch (SecurityException ex) {
                LauncherSecurityManager.reset();
            }
            System.out.println();
            System.out.flush();
            try {
                this.runPigJob(arguments.toArray(new String[arguments.size()]));
            }
            catch (SecurityException ex) {
                if (!LauncherSecurityManager.getExitInvoked() || LauncherSecurityManager.getExitCode() == 0) break block22;
                System.err.println();
                System.err.println("Pig logfile dump:");
                System.err.println();
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(pigLog));
                    line = reader.readLine();
                    while (line != null) {
                        System.err.println(line);
                        line = reader.readLine();
                    }
                    reader.close();
                }
                catch (FileNotFoundException e) {
                    System.err.println("pig log file: " + pigLog + "  not found.");
                }
                throw ex;
            }
        }
        System.out.println();
        System.out.println("<<< Invocation of Pig command completed <<<");
        System.out.println();
        Properties jobIds = this.getHadoopJobIds(logFile);
        File file = new File(System.getProperty("oozie.action.output.properties"));
        os = new FileOutputStream(file);
        jobIds.store(os, "");
        ((OutputStream)os).close();
        System.out.println(" Hadoop Job IDs executed by Pig: " + jobIds.getProperty("hadoopJobs"));
        System.out.println();
    }

    protected void runPigJob(String[] args) throws Exception {
        Main.main((String[])args);
    }

    protected Properties getHadoopJobIds(String logFile) throws IOException {
        boolean jobCount = false;
        Properties props = new Properties();
        StringBuffer sb = new StringBuffer(100);
        if (!new File(logFile).exists()) {
            System.err.println("pig log file: " + logFile + "  not present. Therefore no Hadoop jobids found");
            props.setProperty("hadoopJobs", "");
        } else {
            BufferedReader br = new BufferedReader(new FileReader(logFile));
            String line = br.readLine();
            String separator = "";
            while (line != null) {
                if (line.contains(JOB_ID_LOG_PREFIX)) {
                    int jobIdStarts = line.indexOf(JOB_ID_LOG_PREFIX) + JOB_ID_LOG_PREFIX.length();
                    String jobId = line.substring(jobIdStarts);
                    int jobIdEnds = jobId.indexOf(" ");
                    if (jobIdEnds > -1) {
                        jobId = jobId.substring(0, jobId.indexOf(" "));
                    }
                    sb.append(separator).append(jobId);
                    separator = ",";
                }
                line = br.readLine();
            }
            br.close();
            props.setProperty("hadoopJobs", sb.toString());
        }
        return props;
    }

    static {
        DISALLOWED_PIG_OPTIONS.add("-4");
        DISALLOWED_PIG_OPTIONS.add("-log4jconf");
        DISALLOWED_PIG_OPTIONS.add("-e");
        DISALLOWED_PIG_OPTIONS.add("-execute");
        DISALLOWED_PIG_OPTIONS.add("-f");
        DISALLOWED_PIG_OPTIONS.add("-file");
        DISALLOWED_PIG_OPTIONS.add("-l");
        DISALLOWED_PIG_OPTIONS.add("-logfile");
        DISALLOWED_PIG_OPTIONS.add("-r");
        DISALLOWED_PIG_OPTIONS.add("-dryrun");
        DISALLOWED_PIG_OPTIONS.add("-x");
        DISALLOWED_PIG_OPTIONS.add("-exectype");
        DISALLOWED_PIG_OPTIONS.add("-P");
        DISALLOWED_PIG_OPTIONS.add("-propertyFile");
    }
}

