/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.LauncherMainHadoopUtils;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.action.hadoop.OoziePigStats;
import org.apache.pig.Main;
import org.apache.pig.PigRunner;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.PigStats;

public class PigMain
extends LauncherMain {
    private static final Set<String> DISALLOWED_PIG_OPTIONS = new HashSet<String>();
    public static final String ACTION_PREFIX = "oozie.action.";
    public static final String EXTERNAL_CHILD_IDS = "oozie.action.externalChildIDs";
    public static final String EXTERNAL_ACTION_STATS = "oozie.action.stats.properties";
    public static final String EXTERNAL_STATS_WRITE = "oozie.action.external.stats.write";
    public static final int STRING_BUFFER_SIZE = 100;
    private static final Pattern[] PIG_JOB_IDS_PATTERNS = new Pattern[]{Pattern.compile("HadoopJobId: (job_\\S*)")};

    public static void main(String[] args) throws Exception {
        PigMain.run(PigMain.class, (String[])args);
    }

    protected void run(String[] args) throws Exception {
        String[] pigArgs;
        String[] params;
        System.out.println();
        System.out.println("Oozie Pig action configuration");
        System.out.println("=================================================================");
        Configuration actionConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        actionConf.addResource(new Path("file:///", actionXml));
        PigMain.setYarnTag((Configuration)actionConf);
        Properties pigProperties = new Properties();
        for (Map.Entry entry : actionConf) {
            pigProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        String jobTokenFile = PigMain.getFilePathFromEnv((String)"HADOOP_TOKEN_FILE_LOCATION");
        if (jobTokenFile != null) {
            pigProperties.setProperty("mapreduce.job.credentials.binary", jobTokenFile);
            pigProperties.setProperty("tez.credentials.path", jobTokenFile);
            System.out.println("------------------------");
            System.out.println("Setting env property for mapreduce.job.credentials.binary to:" + jobTokenFile);
            System.out.println("------------------------");
            System.setProperty("mapreduce.job.credentials.binary", jobTokenFile);
        } else {
            System.out.println("Non-kerberoes execution");
        }
        FileOutputStream os = new FileOutputStream("pig.properties");
        pigProperties.store(os, "");
        ((OutputStream)os).close();
        PigMain.logMasking((String)"pig.properties:", Arrays.asList("password"), pigProperties.entrySet());
        ArrayList<String> arguments = new ArrayList<String>();
        String script = actionConf.get("oozie.pig.script");
        if (script == null) {
            throw new RuntimeException("Action Configuration does not have [oozie.pig.script] property");
        }
        if (!new File(script).exists()) {
            throw new RuntimeException("Error: Pig script file [" + script + "] does not exist");
        }
        System.out.println("Pig script [" + script + "] content: ");
        System.out.println("------------------------");
        BufferedReader br = new BufferedReader(new FileReader(script));
        String line = br.readLine();
        while (line != null) {
            System.out.println(line);
            line = br.readLine();
        }
        br.close();
        System.out.println("------------------------");
        System.out.println();
        arguments.add("-file");
        arguments.add(script);
        for (String param : params = MapReduceMain.getStrings((Configuration)actionConf, (String)"oozie.pig.params")) {
            arguments.add("-param");
            arguments.add(param);
        }
        String hadoopJobId = System.getProperty("oozie.launcher.job.id");
        if (hadoopJobId == null) {
            throw new RuntimeException("Launcher Hadoop Job ID system property not set");
        }
        String logFile = new File("pig-oozie-" + hadoopJobId + ".log").getAbsolutePath();
        URL log4jFile = Thread.currentThread().getContextClassLoader().getResource("log4j.properties");
        if (log4jFile != null) {
            String pigLogLevel = actionConf.get("oozie.pig.log.level", "INFO");
            Properties hadoopProps = new Properties();
            hadoopProps.load(log4jFile.openStream());
            hadoopProps.setProperty("log4j.rootLogger", pigLogLevel + ", A, B");
            hadoopProps.setProperty("log4j.logger.org.apache.pig", pigLogLevel + ", A, B");
            hadoopProps.setProperty("log4j.additivity.org.apache.pig", "false");
            hadoopProps.setProperty("log4j.appender.A", "org.apache.log4j.ConsoleAppender");
            hadoopProps.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout");
            hadoopProps.setProperty("log4j.appender.A.layout.ConversionPattern", "%d [%t] %-5p %c %x - %m%n");
            hadoopProps.setProperty("log4j.appender.B", "org.apache.log4j.FileAppender");
            hadoopProps.setProperty("log4j.appender.B.file", logFile);
            hadoopProps.setProperty("log4j.appender.B.layout", "org.apache.log4j.PatternLayout");
            hadoopProps.setProperty("log4j.appender.B.layout.ConversionPattern", "%d [%t] %-5p %c %x - %m%n");
            String localProps = new File("piglog4j.properties").getAbsolutePath();
            FileOutputStream os1 = new FileOutputStream(localProps);
            hadoopProps.store(os1, "");
            ((OutputStream)os1).close();
            arguments.add("-log4jconf");
            arguments.add(localProps);
            File localDir = new File(localProps).getParentFile();
            System.out.println("Current (local) dir = " + localDir.getAbsolutePath());
        } else {
            System.out.println("log4jfile is null");
        }
        String pigLog = "pig-" + hadoopJobId + ".log";
        arguments.add("-logfile");
        arguments.add(pigLog);
        for (String pigArg : pigArgs = MapReduceMain.getStrings((Configuration)actionConf, (String)"oozie.pig.args")) {
            if (DISALLOWED_PIG_OPTIONS.contains(pigArg)) {
                throw new RuntimeException("Error: Pig argument " + pigArg + " is not supported");
            }
            arguments.add(pigArg);
        }
        System.out.println("Pig command arguments :");
        for (String arg : arguments) {
            System.out.println("             " + arg);
        }
        LauncherMainHadoopUtils.killChildYarnJobs((Configuration)actionConf);
        System.out.println("=================================================================");
        System.out.println();
        System.out.println(">>> Invoking Pig command line now >>>");
        System.out.println();
        System.out.flush();
        System.out.println();
        this.runPigJob(new String[]{"-version"}, null, true, false);
        System.out.println();
        System.out.flush();
        boolean hasStats = Boolean.parseBoolean(actionConf.get(EXTERNAL_STATS_WRITE));
        this.runPigJob(arguments.toArray(new String[arguments.size()]), pigLog, false, hasStats);
        System.out.println();
        System.out.println("<<< Invocation of Pig command completed <<<");
        System.out.println();
        File file = new File(System.getProperty(EXTERNAL_CHILD_IDS));
        if (!file.exists()) {
            PigMain.writeExternalChildIDs((String)logFile, (Pattern[])PIG_JOB_IDS_PATTERNS, (String)"Pig");
        }
    }

    private void handleError(String pigLog) throws Exception {
        System.err.println();
        System.err.println("Pig logfile dump:");
        System.err.println();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(pigLog));
            String line = reader.readLine();
            while (line != null) {
                System.err.println(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("pig log file: " + pigLog + "  not found.");
        }
    }

    protected void runPigJob(String[] args, String pigLog, boolean resetSecurityManager, boolean retrieveStats) throws Exception {
        block15: {
            boolean pigRunnerExists = true;
            try {
                Class<?> klass = Class.forName("org.apache.pig.PigRunner");
            }
            catch (ClassNotFoundException ex) {
                pigRunnerExists = false;
            }
            if (pigRunnerExists) {
                System.out.println("Run pig script using PigRunner.run() for Pig version 0.8+");
                PigStats stats = PigRunner.run((String[])args, null);
                String jobIds = this.getHadoopJobIds(stats);
                if (jobIds != null && !jobIds.isEmpty()) {
                    System.out.println("Hadoop Job IDs executed by Pig: " + jobIds);
                    File f = new File(System.getProperty(EXTERNAL_CHILD_IDS));
                    PigMain.writeExternalData(jobIds, f);
                }
                if (!stats.isSuccessful()) {
                    if (pigLog != null) {
                        this.handleError(pigLog);
                    }
                    throw new LauncherMainException(2);
                }
                if (resetSecurityManager) {
                    return;
                }
                if (retrieveStats) {
                    String JSONString;
                    try {
                        OoziePigStats pigStats = new OoziePigStats(stats);
                        JSONString = pigStats.toJSON();
                    }
                    catch (UnsupportedOperationException uoe) {
                        throw new UnsupportedOperationException("Pig stats are not supported for this type of operation", uoe);
                    }
                    File f = new File(System.getProperty(EXTERNAL_ACTION_STATS));
                    PigMain.writeExternalData(JSONString, f);
                }
            } else {
                try {
                    System.out.println("Run pig script using Main.main() for Pig version before 0.8");
                    Main.main((String[])args);
                }
                catch (SecurityException ex) {
                    if (resetSecurityManager) {
                        LauncherSecurityManager.reset();
                    }
                    if (!LauncherSecurityManager.getExitInvoked() || LauncherSecurityManager.getExitCode() == 0) break block15;
                    if (pigLog != null) {
                        this.handleError(pigLog);
                    }
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeExternalData(String data, File f) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(f));
            out.write(data);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected String getHadoopJobIds(PigStats pigStats) {
        StringBuilder sb = new StringBuilder(100);
        String separator = ",";
        try {
            PigStats.JobGraph jobGraph = pigStats.getJobGraph();
            for (JobStats jobStats : jobGraph) {
                String hadoopJobId = jobStats.getJobId();
                if (StringUtils.isEmpty((String)hadoopJobId) || hadoopJobId.trim().equalsIgnoreCase("NULL")) continue;
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(hadoopJobId);
            }
        }
        catch (UnsupportedOperationException uoe) {
            return null;
        }
        return sb.toString();
    }

    static {
        DISALLOWED_PIG_OPTIONS.add("-4");
        DISALLOWED_PIG_OPTIONS.add("-log4jconf");
        DISALLOWED_PIG_OPTIONS.add("-e");
        DISALLOWED_PIG_OPTIONS.add("-execute");
        DISALLOWED_PIG_OPTIONS.add("-f");
        DISALLOWED_PIG_OPTIONS.add("-file");
        DISALLOWED_PIG_OPTIONS.add("-l");
        DISALLOWED_PIG_OPTIONS.add("-logfile");
        DISALLOWED_PIG_OPTIONS.add("-r");
        DISALLOWED_PIG_OPTIONS.add("-dryrun");
        DISALLOWED_PIG_OPTIONS.add("-P");
        DISALLOWED_PIG_OPTIONS.add("-propertyFile");
    }
}

