/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Shell;
import org.apache.oozie.action.hadoop.OozieActionConfigurator;
import org.apache.oozie.action.hadoop.OozieActionConfiguratorException;

public abstract class LauncherMain {
    public static final String HADOOP_JOBS = "hadoopJobs";
    public static final String MAPREDUCE_JOB_TAGS = "mapreduce.job.tags";

    protected static void run(Class<? extends LauncherMain> klass, String[] args) throws Exception {
        LauncherMain main = klass.newInstance();
        main.run(args);
    }

    protected static Properties getHadoopJobIds(String logFile, Pattern[] patterns) throws IOException {
        Properties props = new Properties();
        StringBuffer sb = new StringBuffer(100);
        if (!new File(logFile).exists()) {
            System.err.println("Log file: " + logFile + "  not present. Therefore no Hadoop jobids found");
            props.setProperty(HADOOP_JOBS, "");
        } else {
            BufferedReader br = new BufferedReader(new FileReader(logFile));
            String line = br.readLine();
            String separator = "";
            while (line != null) {
                for (Pattern pattern : patterns) {
                    String jobId;
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.find() || StringUtils.isEmpty((String)(jobId = matcher.group(1))) || jobId.equalsIgnoreCase("NULL")) continue;
                    jobId = jobId.replaceAll("application", "job");
                    sb.append(separator).append(jobId);
                    separator = ",";
                }
                line = br.readLine();
            }
            br.close();
            props.setProperty(HADOOP_JOBS, sb.toString());
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeExternalChildIDs(String logFile, Pattern[] patterns, String name) {
        try {
            Properties jobIds = LauncherMain.getHadoopJobIds(logFile, patterns);
            File file = new File(System.getProperty("oozie.action.output.properties"));
            FileOutputStream os = new FileOutputStream(file);
            try {
                jobIds.store(os, "");
            }
            finally {
                ((OutputStream)os).close();
            }
            System.out.println(" Hadoop Job IDs executed by " + name + ": " + jobIds.getProperty(HADOOP_JOBS));
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("WARN: Error getting Hadoop Job IDs executed by " + name);
            e.printStackTrace(System.out);
        }
    }

    protected abstract void run(String[] var1) throws Exception;

    protected static void logMasking(String header, Collection<String> maskSet, Iterable conf) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write(header + "\n");
        writer.write("--------------------\n");
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            for (String mask : maskSet) {
                if (!name.contains(mask)) continue;
                value = "*MASKED*";
            }
            writer.write(" " + name + " : " + value + "\n");
        }
        writer.write("--------------------\n");
        writer.close();
        System.out.println(writer.toString());
        System.out.flush();
    }

    protected static String getFilePathFromEnv(String env) {
        String path = System.getenv(env);
        if (path != null && Shell.WINDOWS) {
            if (path.charAt(0) == '\"') {
                path = path.substring(1);
            }
            if (path.charAt(path.length() - 1) == '\"') {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    protected static void runConfigClass(JobConf actionConf) throws OozieActionConfiguratorException {
        String configClass = System.getProperty("oozie.action.config.class");
        if (configClass != null) {
            try {
                Class<?> klass = Class.forName(configClass);
                Class<OozieActionConfigurator> actionConfiguratorKlass = klass.asSubclass(OozieActionConfigurator.class);
                OozieActionConfigurator actionConfigurator = actionConfiguratorKlass.newInstance();
                actionConfigurator.configure(actionConf);
            }
            catch (ClassNotFoundException e) {
                throw new OozieActionConfiguratorException("An Exception occured while instantiating the action config class", e);
            }
            catch (InstantiationException e) {
                throw new OozieActionConfiguratorException("An Exception occured while instantiating the action config class", e);
            }
            catch (IllegalAccessException e) {
                throw new OozieActionConfiguratorException("An Exception occured while instantiating the action config class", e);
            }
        }
    }

    public static Configuration loadActionConf() throws IOException {
        Configuration actionConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        actionConf.addResource(new Path("file:///", actionXml));
        return actionConf;
    }

    protected static void setYarnTag(Configuration actionConf) {
        if (actionConf.get("oozie.child.mapreduce.job.tags") != null) {
            if (actionConf.get(MAPREDUCE_JOB_TAGS) != null) {
                actionConf.set(MAPREDUCE_JOB_TAGS, actionConf.get(MAPREDUCE_JOB_TAGS) + "," + actionConf.get("oozie.child.mapreduce.job.tags"));
            } else {
                actionConf.set(MAPREDUCE_JOB_TAGS, actionConf.get("oozie.child.mapreduce.job.tags"));
            }
        }
    }
}

