/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.pipes.Submitter;
import org.apache.oozie.action.hadoop.MapReduceMain;

public class PipesMain
extends MapReduceMain {
    public static void main(String[] args) throws Exception {
        PipesMain.run(PipesMain.class, args);
    }

    @Override
    protected RunningJob submitJob(Configuration actionConf) throws Exception {
        JobConf jobConf = new JobConf();
        String value = actionConf.get("oozie.pipes.map");
        if (value != null) {
            jobConf.setBoolean("hadoop.pipes.java.mapper", true);
            jobConf.set("mapred.mapper.class", value);
        }
        if ((value = actionConf.get("oozie.pipes.reduce")) != null) {
            jobConf.setBoolean("hadoop.pipes.java.reducer", true);
            jobConf.set("mapred.reducer.class", value);
        }
        if ((value = actionConf.get("oozie.pipes.inputformat")) != null) {
            jobConf.setBoolean("hadoop.pipes.java.recordreader", true);
            jobConf.set("mapred.input.format.class", value);
        }
        if ((value = actionConf.get("oozie.pipes.partitioner")) != null) {
            jobConf.set("mapred.partitioner.class", value);
        }
        if ((value = actionConf.get("oozie.pipes.writer")) != null) {
            jobConf.setBoolean("hadoop.pipes.java.recordwriter", true);
            jobConf.set("mapred.output.format.class", value);
        }
        if ((value = actionConf.get("oozie.pipes.program")) != null) {
            jobConf.set("hadoop.pipes.executable", value);
            if (value.contains("#")) {
                DistributedCache.createSymlink((Configuration)jobConf);
            }
        }
        this.addActionConf(jobConf, actionConf);
        if (PipesMain.getFilePathFromEnv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            jobConf.set("mapreduce.job.credentials.binary", PipesMain.getFilePathFromEnv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        return Submitter.jobSubmit((JobConf)jobConf);
    }

    public static void setPipes(Configuration conf, String map, String reduce, String inputFormat, String partitioner, String writer, String program, Path appPath) {
        if (map != null) {
            conf.set("oozie.pipes.map", map);
        }
        if (reduce != null) {
            conf.set("oozie.pipes.reduce", reduce);
        }
        if (inputFormat != null) {
            conf.set("oozie.pipes.inputformat", inputFormat);
        }
        if (partitioner != null) {
            conf.set("oozie.pipes.partitioner", partitioner);
        }
        if (writer != null) {
            conf.set("oozie.pipes.writer", writer);
        }
        if (program != null) {
            Path path = null;
            if (!program.startsWith("/")) {
                path = new Path(appPath, program);
                program = path.toString();
            }
            conf.set("oozie.pipes.program", program);
        }
    }
}

