/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.MapReduceMain;

public class ShellMain
extends LauncherMain {
    public static final String CONF_OOZIE_SHELL_ARGS = "oozie.shell.args";
    public static final String CONF_OOZIE_SHELL_EXEC = "oozie.shell.exec";
    public static final String CONF_OOZIE_SHELL_ENVS = "oozie.shell.envs";
    public static final String CONF_OOZIE_SHELL_CAPTURE_OUTPUT = "oozie.shell.capture-output";
    public static final String OOZIE_ACTION_CONF_XML = "OOZIE_ACTION_CONF_XML";

    public static void main(String[] args) throws Exception {
        ShellMain.run(ShellMain.class, args);
    }

    @Override
    protected void run(String[] args) throws Exception {
        Configuration actionConf = this.loadActionConf();
        int exitCode = this.execute(actionConf);
        if (exitCode != 0) {
            throw new LauncherMainException(1);
        }
    }

    private int execute(Configuration actionConf) throws Exception {
        String exec = this.getExec(actionConf);
        List<String> args = this.getShellArguments(actionConf);
        ArrayList<String> cmdArray = this.getCmdList(exec, args.toArray(new String[args.size()]));
        ProcessBuilder builder = new ProcessBuilder(cmdArray);
        Map<String, String> envp = this.getEnvMap(builder.environment(), actionConf);
        File currDir = new File("dummy").getAbsoluteFile().getParentFile();
        System.out.println("Current working dir " + currDir);
        builder.directory(currDir);
        this.printCommand(cmdArray, envp);
        System.out.println("=================================================================");
        System.out.println();
        System.out.println(">>> Invoking Shell command line now >>");
        System.out.println();
        System.out.flush();
        boolean captureOutput = actionConf.getBoolean(CONF_OOZIE_SHELL_CAPTURE_OUTPUT, false);
        Process p = builder.start();
        Thread[] thrArray = this.handleShellOutput(p, captureOutput);
        int exitValue = p.waitFor();
        if (thrArray != null) {
            for (Thread thr : thrArray) {
                thr.join();
            }
        }
        System.out.println("Exit code of the Shell command " + exitValue);
        System.out.println("<<< Invocation of Shell command completed <<<");
        System.out.println();
        return exitValue;
    }

    private Map<String, String> getEnvMap(Map<String, String> envp, Configuration actionConf) {
        String[] envs;
        for (String env : envs = MapReduceMain.getStrings(actionConf, CONF_OOZIE_SHELL_ENVS)) {
            String[] varValue = env.split("=", 2);
            envp.put(varValue[0], varValue[1]);
        }
        envp.put(OOZIE_ACTION_CONF_XML, System.getProperty("oozie.action.conf.xml", ""));
        return envp;
    }

    private ArrayList<String> getCmdList(String exec, String[] args) {
        ArrayList<String> cmdArray = new ArrayList<String>();
        cmdArray.add(exec);
        for (String arg : args) {
            cmdArray.add(arg);
        }
        return cmdArray;
    }

    protected Thread[] handleShellOutput(Process p, boolean captureOutput) throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        OutputWriteThread thrStdout = new OutputWriteThread(input, true, captureOutput);
        thrStdout.setDaemon(true);
        thrStdout.start();
        OutputWriteThread thrStderr = new OutputWriteThread(error, false, false);
        thrStderr.setDaemon(true);
        thrStderr.start();
        return new Thread[]{thrStdout, thrStderr};
    }

    protected void printCommand(ArrayList<String> cmdArray, Map<String, String> envp) {
        int i = 0;
        System.out.println("Full Command .. ");
        System.out.println("-------------------------");
        for (String string : cmdArray) {
            System.out.println(i++ + ":" + string + ":");
        }
        if (envp != null) {
            System.out.println("List of passing environment");
            System.out.println("-------------------------");
            for (Map.Entry entry : envp.entrySet()) {
                System.out.println((String)entry.getKey() + "=" + (String)entry.getValue() + ":");
            }
        }
    }

    protected List<String> getShellArguments(Configuration actionConf) {
        String[] scrArgs;
        ArrayList<String> arguments = new ArrayList<String>();
        for (String scrArg : scrArgs = MapReduceMain.getStrings(actionConf, CONF_OOZIE_SHELL_ARGS)) {
            arguments.add(scrArg);
        }
        return arguments;
    }

    protected String getExec(Configuration actionConf) {
        String exec = actionConf.get(CONF_OOZIE_SHELL_EXEC);
        if (exec == null) {
            throw new RuntimeException("Action Configuration does not have oozie.shell.exec property");
        }
        return exec;
    }

    protected Configuration loadActionConf() throws IOException {
        System.out.println();
        System.out.println("Oozie Shell action configuration");
        System.out.println("=================================================================");
        Configuration actionConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        actionConf.addResource(new Path("file:///", actionXml));
        ShellMain.logMasking("Shell configuration:", new HashSet<String>(), (Iterable)actionConf);
        return actionConf;
    }

    class OutputWriteThread
    extends Thread {
        BufferedReader reader = null;
        boolean isStdout = false;
        boolean needCaptured = false;

        public OutputWriteThread(BufferedReader reader, boolean isStdout, boolean needCaptured) {
            this.reader = reader;
            this.isStdout = isStdout;
            this.needCaptured = needCaptured;
        }

        @Override
        public void run() {
            BufferedWriter os = null;
            try {
                String line;
                if (this.needCaptured) {
                    File file = new File(System.getProperty("oozie.action.output.properties"));
                    os = new BufferedWriter(new FileWriter(file));
                }
                while ((line = this.reader.readLine()) != null) {
                    if (this.isStdout) {
                        System.out.println("Stdoutput " + line);
                        if (os == null) continue;
                        if (Shell.WINDOWS) {
                            line = line.replace("\\u", "\\\\u");
                        }
                        os.write(line);
                        os.newLine();
                        continue;
                    }
                    System.err.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Stdout/Stderr read/write error :" + e);
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException ex) {}
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RuntimeException("Unable to close the file stream :" + e);
                    }
                }
            }
        }
    }
}

