/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.oozie.action.hadoop.JavaMainException;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.action.hadoop.PrepareActionsDriver;

public class LauncherMapper<K1, V1, K2, V2>
implements Mapper<K1, V1, K2, V2>,
Runnable {
    static final String CONF_OOZIE_ACTION_MAIN_CLASS = "oozie.launcher.action.main.class";
    static final String ACTION_PREFIX = "oozie.action.";
    static final String CONF_OOZIE_ACTION_MAX_OUTPUT_DATA = "oozie.action.max.output.data";
    static final String CONF_OOZIE_ACTION_MAIN_ARG_COUNT = "oozie.action.main.arg.count";
    static final String CONF_OOZIE_ACTION_MAIN_ARG_PREFIX = "oozie.action.main.arg.";
    static final String CONF_OOZIE_EXTERNAL_STATS_MAX_SIZE = "oozie.external.stats.max.size";
    static final String CONF_OOZIE_ACTION_FS_GLOB_MAX = "oozie.action.fs.glob.max";
    static final int GLOB_MAX_DEFAULT = 1000;
    static final String COUNTER_GROUP = "oozie.launcher";
    static final String COUNTER_LAUNCHER_ERROR = "oozie.launcher.error";
    static final String OOZIE_JOB_ID = "oozie.job.id";
    static final String OOZIE_ACTION_ID = "oozie.action.id";
    static final String OOZIE_ACTION_RECOVERY_ID = "oozie.action.recovery.id";
    static final String OOZIE_ACTION_DIR_PATH = "oozie.action.dir.path";
    static final String ACTION_CONF_XML = "action.xml";
    static final String ACTION_PREPARE_XML = "oozie.action.prepare.xml";
    static final String ACTION_DATA_SEQUENCE_FILE = "action-data.seq";
    static final String ACTION_DATA_EXTERNAL_CHILD_IDS = "externalChildIDs";
    static final String ACTION_DATA_OUTPUT_PROPS = "output.properties";
    static final String ACTION_DATA_STATS = "stats.properties";
    static final String ACTION_DATA_NEW_ID = "newId";
    static final String ACTION_DATA_ERROR_PROPS = "error.properties";
    static final String JOB_ID_REGEX = "^job_\\d+_\\d+$";
    private JobConf jobConf;
    private Path actionDir;
    private ScheduledThreadPoolExecutor timer;
    private boolean configFailure = false;
    private LauncherException configureFailureEx;
    private Map<String, String> actionData;
    private Reporter reporter;

    private void setRecoveryId(Configuration launcherConf, Path actionDir, String recoveryId) throws LauncherException {
        try {
            String jobId = launcherConf.get("mapred.job.id");
            Path path = new Path(actionDir, recoveryId);
            FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)launcherConf);
            if (!fs.exists(path)) {
                try {
                    System.out.printf("Attempt to create recovery file %s\n", path.toString());
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(path));
                    writer.write(jobId);
                    ((Writer)writer).close();
                    System.out.printf("%s successfully written with value '%s'\n", path.toString(), jobId);
                }
                catch (IOException ex) {
                    this.failLauncher(0, "IO error", ex);
                }
            } else {
                FSDataInputStream is = fs.open(path);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
                String id = reader.readLine();
                reader.close();
                System.out.printf("%s found with jobId '%s'\n", path, id);
                if (id == null || !Pattern.matches(JOB_ID_REGEX, id)) {
                    System.out.printf("Malformed jobId %s. Attempt to recover with jobId '%s'\n", id, jobId);
                    fs.delete(path, true);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(path));
                    writer.write(jobId);
                    ((Writer)writer).close();
                    System.out.printf("%s successfully written with value '%s'\n", path.toString(), jobId);
                } else if (!jobId.equals(id)) {
                    this.failLauncher(0, MessageFormat.format("Hadoop job Id mismatch, action file [{0}] declares Id [{1}] current Id [{2}]", path, id, jobId), null);
                }
            }
        }
        catch (IOException ex) {
            this.failLauncher(0, "IO error", ex);
        }
    }

    public LauncherMapper() {
        this.actionData = new HashMap<String, String>();
    }

    public void configure(JobConf jobConf) {
        System.out.println();
        System.out.println("Oozie Launcher starts");
        System.out.println();
        this.jobConf = jobConf;
        this.actionDir = new Path(this.getJobConf().get(OOZIE_ACTION_DIR_PATH));
        String recoveryId = jobConf.get(OOZIE_ACTION_RECOVERY_ID, null);
        try {
            this.setRecoveryId((Configuration)jobConf, this.actionDir, recoveryId);
        }
        catch (LauncherException ex) {
            System.out.println("Launcher config error " + ex.getMessage());
            this.configureFailureEx = ex;
            this.configFailure = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void map(K1 key, V1 value, OutputCollector<K2, V2> collector, Reporter reporter) throws IOException {
        block38: {
            try {
                if (this.configFailure) {
                    throw this.configureFailureEx;
                }
                mainClass = this.getJobConf().get("oozie.launcher.action.main.class");
                if (this.getJobConf().getBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", false)) {
                    System.err.println("WARNING, workaround for Hadoop 2.0.2-alpha distributed cached issue (MAPREDUCE-4820) enabled");
                }
                msgPrefix = "Main class [" + mainClass + "], ";
                errorCode = 0;
                errorCause /* !! */  = null;
                errorMessage = null;
                try {
                    new LauncherSecurityManager();
                }
                catch (SecurityException ex) {
                    errorMessage = "Could not set LauncherSecurityManager";
                    errorCause /* !! */  = ex;
                }
                try {
                    block37: {
                        this.setupHeartBeater(reporter);
                        this.setupMainConfiguration();
                        try {
                            System.out.println("Starting the execution of prepare actions");
                            this.executePrepare();
                            System.out.println("Completed the execution of prepare actions successfully");
                        }
                        catch (Exception ex) {
                            System.out.println("Prepare execution in the Launcher Mapper has failed");
                            throw new LauncherException(ex.getMessage(), ex);
                        }
                        args = LauncherMapper.getMainArguments((Configuration)this.getJobConf());
                        this.printContentsOfCurrentDir();
                        System.out.println();
                        System.out.println("Oozie Java/Map-Reduce/Pig action launcher-job configuration");
                        System.out.println("=================================================================");
                        System.out.println("Workflow job id   : " + System.getProperty("oozie.job.id"));
                        System.out.println("Workflow action id: " + System.getProperty("oozie.action.id"));
                        System.out.println();
                        System.out.println("Classpath         :");
                        System.out.println("------------------------");
                        st = new StringTokenizer(System.getProperty("java.class.path"), ":");
                        while (st.hasMoreTokens()) {
                            System.out.println("  " + st.nextToken());
                        }
                        System.out.println("------------------------");
                        System.out.println();
                        System.out.println("Main class        : " + mainClass);
                        System.out.println();
                        System.out.println("Maximum output    : " + this.getJobConf().getInt("oozie.action.max.output.data", 2048));
                        System.out.println();
                        System.out.println("Arguments         :");
                        for (String arg : args) {
                            System.out.println("                    " + arg);
                        }
                        System.out.println();
                        System.out.println("Java System Properties:");
                        System.out.println("------------------------");
                        System.getProperties().store(System.out, "");
                        System.out.flush();
                        System.out.println("------------------------");
                        System.out.println();
                        System.out.println("=================================================================");
                        System.out.println();
                        System.out.println(">>> Invoking Main class now >>>");
                        System.out.println();
                        System.out.flush();
                        try {
                            klass = this.getJobConf().getClass("oozie.launcher.action.main.class", Object.class);
                            mainMethod = klass.getMethod("main", new Class[]{String[].class});
                            mainMethod.invoke(null, new Object[]{args});
                        }
                        catch (InvocationTargetException ex) {
                            cause = ex.getCause();
                            if (JavaMainException.class.isInstance(cause)) {
                                cause = cause.getCause();
                            }
                            if (LauncherMainException.class.isInstance(cause)) {
                                errorMessage = msgPrefix + "exit code [" + ((LauncherMainException)ex.getCause()).getErrorCode() + "]";
                                errorCause /* !! */  = null;
                                break block37;
                            }
                            if (SecurityException.class.isInstance(cause)) {
                                if (LauncherSecurityManager.getExitInvoked()) {
                                    System.out.println("Intercepting System.exit(" + LauncherSecurityManager.getExitCode() + ")");
                                    System.err.println("Intercepting System.exit(" + LauncherSecurityManager.getExitCode() + ")");
                                    errorCode = LauncherSecurityManager.getExitCode();
                                    if (errorCode != 0) {
                                        errorMessage = msgPrefix + "exit code [" + errorCode + "]";
                                        errorCause /* !! */  = null;
                                    }
                                }
                                break block37;
                            }
                            throw ex;
                        }
                        finally {
                            System.out.println();
                            System.out.println("<<< Invocation of Main class completed <<<");
                            System.out.println();
                        }
                    }
                    if (errorMessage == null) {
                        this.handleActionData();
                        if (this.actionData.get("output.properties") != null) {
                            System.out.println();
                            System.out.println("Oozie Launcher, capturing output data:");
                            System.out.println("=======================");
                            System.out.println(this.actionData.get("output.properties"));
                            System.out.println();
                            System.out.println("=======================");
                            System.out.println();
                        }
                        if (this.actionData.get("newId") != null) {
                            System.out.println();
                            System.out.println("Oozie Launcher, propagating new Hadoop job id to Oozie");
                            System.out.println("=======================");
                            System.out.println(this.actionData.get("newId"));
                            System.out.println("=======================");
                            System.out.println();
                        }
                    }
                }
                catch (NoSuchMethodException ex) {
                    errorMessage = msgPrefix + "main() method not found";
                    errorCause /* !! */  = ex;
                }
                catch (InvocationTargetException ex) {
                    errorMessage = msgPrefix + "main() threw exception";
                    errorCause /* !! */  = ex.getTargetException();
                }
                catch (Throwable ex) {
                    errorMessage = msgPrefix + "exception invoking main()";
                    errorCause /* !! */  = ex;
                    this.destroyHeartBeater();
                    ** if (errorMessage == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        this.failLauncher(errorCode, errorMessage, errorCause /* !! */ );
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block38;
                    }
                    {
                        catch (Throwable var17_26) {
                            throw var17_26;
                        }
                    }
                }
                finally {
                    this.destroyHeartBeater();
                    if (errorMessage != null) {
                        this.failLauncher(errorCode, errorMessage, errorCause /* !! */ );
                    }
                }
            }
            catch (LauncherException ex) {
                reporter.incrCounter("oozie.launcher", "oozie.launcher.error", 1L);
                System.out.println();
                System.out.println("Oozie Launcher failed, finishing Hadoop job gracefully");
                System.out.println();
            }
            finally {
                this.uploadActionDataToHDFS();
            }
        }
    }

    public void close() throws IOException {
        System.out.println();
        System.out.println("Oozie Launcher ends");
        System.out.println();
    }

    protected JobConf getJobConf() {
        return this.jobConf;
    }

    private void handleActionData() throws IOException, LauncherException {
        File newId;
        String newIdProp;
        File actionOutputData;
        String outputProp;
        File actionStatsData;
        String statsProp;
        File externalChildIDs;
        String externalChildIdsProp = System.getProperty("oozie.action.externalChildIDs");
        if (externalChildIdsProp != null && (externalChildIDs = new File(externalChildIdsProp)).exists()) {
            this.actionData.put(ACTION_DATA_EXTERNAL_CHILD_IDS, LauncherMapper.getLocalFileContentStr(externalChildIDs, "", -1));
        }
        if ((statsProp = System.getProperty("oozie.action.stats.properties")) != null && (actionStatsData = new File(statsProp)).exists()) {
            int statsMaxOutputData = this.getJobConf().getInt(CONF_OOZIE_EXTERNAL_STATS_MAX_SIZE, Integer.MAX_VALUE);
            this.actionData.put(ACTION_DATA_STATS, LauncherMapper.getLocalFileContentStr(actionStatsData, "Stats", statsMaxOutputData));
        }
        if ((outputProp = System.getProperty("oozie.action.output.properties")) != null && (actionOutputData = new File(outputProp)).exists()) {
            int maxOutputData = this.getJobConf().getInt(CONF_OOZIE_ACTION_MAX_OUTPUT_DATA, 2048);
            this.actionData.put(ACTION_DATA_OUTPUT_PROPS, LauncherMapper.getLocalFileContentStr(actionOutputData, "Output", maxOutputData));
        }
        if ((newIdProp = System.getProperty("oozie.action.newId")) != null && (newId = new File(newIdProp)).exists()) {
            this.actionData.put(ACTION_DATA_NEW_ID, LauncherMapper.getLocalFileContentStr(newId, "", -1));
        }
    }

    public static String getLocalFileContentStr(File file, String type, int maxLen) throws LauncherException, IOException {
        int read;
        StringBuffer sb = new StringBuffer();
        FileReader reader = new FileReader(file);
        char[] buffer = new char[2048];
        int count = 0;
        while ((read = reader.read(buffer)) > -1) {
            if (maxLen > -1 && (count += read) > maxLen) {
                throw new LauncherException(type + " data exceeds its limit [" + maxLen + "]");
            }
            sb.append(buffer, 0, read);
        }
        reader.close();
        return sb.toString();
    }

    private void uploadActionDataToHDFS() throws IOException {
        block9: {
            if (!this.actionData.isEmpty()) {
                Path finalPath = new Path(this.actionDir, ACTION_DATA_SEQUENCE_FILE);
                FileSystem fs = FileSystem.get((URI)finalPath.toUri(), (Configuration)this.getJobConf());
                System.out.println("Oozie Launcher, uploading action data to HDFS sequence file: " + new Path(this.actionDir, ACTION_DATA_SEQUENCE_FILE).toUri());
                SequenceFile.Writer wr = null;
                try {
                    wr = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.getJobConf(), (Path)finalPath, Text.class, Text.class);
                    if (wr != null) {
                        Set<String> keys = this.actionData.keySet();
                        for (String propsKey : keys) {
                            wr.append((Writable)new Text(propsKey), (Writable)new Text(this.actionData.get(propsKey)));
                        }
                        break block9;
                    }
                    throw new IOException("SequenceFile.Writer is null for " + finalPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    if (wr != null) {
                        wr.close();
                    }
                }
            }
        }
    }

    private void setupMainConfiguration() throws IOException {
        Path pathNew = new Path(new Path(this.actionDir, ACTION_CONF_XML), new Path(new File(ACTION_CONF_XML).getAbsolutePath()));
        FileSystem fs = FileSystem.get((URI)pathNew.toUri(), (Configuration)this.getJobConf());
        fs.copyToLocalFile(new Path(this.actionDir, ACTION_CONF_XML), new Path(new File(ACTION_CONF_XML).getAbsolutePath()));
        System.setProperty("oozie.launcher.job.id", this.getJobConf().get("mapred.job.id"));
        System.setProperty(OOZIE_JOB_ID, this.getJobConf().get(OOZIE_JOB_ID));
        System.setProperty(OOZIE_ACTION_ID, this.getJobConf().get(OOZIE_ACTION_ID));
        System.setProperty("oozie.action.conf.xml", new File(ACTION_CONF_XML).getAbsolutePath());
        System.setProperty("oozie.action.externalChildIDs", new File(ACTION_DATA_EXTERNAL_CHILD_IDS).getAbsolutePath());
        System.setProperty("oozie.action.stats.properties", new File(ACTION_DATA_STATS).getAbsolutePath());
        System.setProperty("oozie.action.newId", new File(ACTION_DATA_NEW_ID).getAbsolutePath());
        System.setProperty("oozie.action.output.properties", new File(ACTION_DATA_OUTPUT_PROPS).getAbsolutePath());
        System.setProperty("oozie.action.error.properties", new File(ACTION_DATA_ERROR_PROPS).getAbsolutePath());
        System.setProperty("oozie.job.launch.time", this.getJobConf().get("oozie.job.launch.time"));
    }

    private void executePrepare() throws IOException, LauncherException {
        String prepareXML = this.getJobConf().get(ACTION_PREPARE_XML);
        if (prepareXML != null) {
            if (!prepareXML.equals("")) {
                Configuration actionConf = new Configuration((Configuration)this.getJobConf());
                String actionXml = System.getProperty("oozie.action.conf.xml");
                actionConf.addResource(new Path("file:///", actionXml));
                PrepareActionsDriver.doOperations(prepareXML, actionConf);
            } else {
                System.out.println("There are no prepare actions to execute.");
            }
        }
    }

    public static String[] getMainArguments(Configuration conf) {
        String[] args = new String[conf.getInt(CONF_OOZIE_ACTION_MAIN_ARG_COUNT, 0)];
        for (int i = 0; i < args.length; ++i) {
            args[i] = conf.get(CONF_OOZIE_ACTION_MAIN_ARG_PREFIX + i);
        }
        return args;
    }

    private void setupHeartBeater(Reporter reporter) {
        this.timer = new ScheduledThreadPoolExecutor(1);
        this.timer.scheduleAtFixedRate(new LauncherMapper<K1, V1, K2, V2>(reporter), 0L, 30L, TimeUnit.SECONDS);
    }

    private void destroyHeartBeater() {
        this.timer.shutdownNow();
    }

    private LauncherMapper(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void run() {
        System.out.println("Heart beat");
        this.reporter.progress();
    }

    private void failLauncher(int errorCode, String reason, Throwable ex) throws LauncherException {
        StringWriter sw;
        if (ex != null) {
            reason = reason + ", " + ex.getMessage();
        }
        Properties errorProps = new Properties();
        errorProps.setProperty("error.code", Integer.toString(errorCode));
        errorProps.setProperty("error.reason", reason);
        if (ex != null) {
            if (ex.getMessage() != null) {
                errorProps.setProperty("exception.message", ex.getMessage());
            }
            sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.close();
            errorProps.setProperty("exception.stacktrace", sw.toString());
        }
        sw = new StringWriter();
        try {
            File externalChildIDs;
            errorProps.store(sw, "");
            sw.close();
            this.actionData.put(ACTION_DATA_ERROR_PROPS, sw.toString());
            String externalChildIdsProp = System.getProperty("oozie.action.externalChildIDs");
            if (externalChildIdsProp != null && (externalChildIDs = new File(externalChildIdsProp)).exists()) {
                this.actionData.put(ACTION_DATA_EXTERNAL_CHILD_IDS, LauncherMapper.getLocalFileContentStr(externalChildIDs, "", -1));
            }
        }
        catch (IOException ioe) {
            throw new LauncherException(ioe.getMessage(), ioe);
        }
        finally {
            System.out.print("Failing Oozie Launcher, " + reason + "\n");
            System.err.print("Failing Oozie Launcher, " + reason + "\n");
            if (ex != null) {
                ex.printStackTrace(System.out);
                ex.printStackTrace(System.err);
            }
        }
        throw new LauncherException(reason, ex);
    }

    protected void printContentsOfCurrentDir() {
        File[] listOfFiles;
        File folder = new File(".");
        System.out.println();
        System.out.println("Files in current dir:" + folder.getAbsolutePath());
        System.out.println("======================");
        for (File fileName : listOfFiles = folder.listFiles()) {
            File[] moreFiles;
            if (fileName.isFile()) {
                System.out.println("File: " + fileName.getName());
                continue;
            }
            if (!fileName.isDirectory()) continue;
            System.out.println("Dir: " + fileName.getName());
            File subDir = new File(fileName.getName());
            for (File subFileName : moreFiles = subDir.listFiles()) {
                if (subFileName.isFile()) {
                    System.out.println("  File: " + subFileName.getName());
                    continue;
                }
                if (!subFileName.isDirectory()) continue;
                System.out.println("  Dir: " + subFileName.getName());
            }
        }
    }
}

