/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherURIHandler;
import org.apache.oozie.action.hadoop.LauncherURIHandlerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PrepareActionsDriver {
    static void doOperations(String prepareXML, Configuration conf) throws LauncherException {
        try {
            Document doc = PrepareActionsDriver.getDocumentFromXML(prepareXML);
            doc.getDocumentElement().normalize();
            NodeList nl = doc.getDocumentElement().getChildNodes();
            LauncherURIHandlerFactory factory = new LauncherURIHandlerFactory(conf);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                String operation = n.getNodeName();
                if (n.getAttributes() == null || n.getAttributes().getNamedItem("path") == null) continue;
                String path = n.getAttributes().getNamedItem("path").getNodeValue().trim();
                URI uri = new URI(path);
                LauncherURIHandler handler = factory.getURIHandler(uri);
                PrepareActionsDriver.execute(operation, uri, handler, conf);
            }
        }
        catch (IOException ioe) {
            throw new LauncherException(ioe.getMessage(), ioe);
        }
        catch (SAXException saxe) {
            throw new LauncherException(saxe.getMessage(), saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new LauncherException(pce.getMessage(), pce);
        }
        catch (URISyntaxException use) {
            throw new LauncherException(use.getMessage(), use);
        }
    }

    private static void execute(String operation, URI uri, LauncherURIHandler handler, Configuration conf) throws LauncherException {
        if (operation.equals("delete")) {
            handler.delete(uri, conf);
        } else if (operation.equals("mkdir")) {
            handler.create(uri, conf);
        }
    }

    static Document getDocumentFromXML(String prepareXML) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(prepareXML.getBytes("UTF-8"));
        return docBuilder.parse(is);
    }
}

