/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherMainHadoopUtils;

public class MapReduceMain
extends LauncherMain {
    public static final String OOZIE_MAPREDUCE_UBER_JAR = "oozie.mapreduce.uber.jar";

    public static void main(String[] args) throws Exception {
        MapReduceMain.run(MapReduceMain.class, args);
    }

    @Override
    protected void run(String[] args) throws Exception {
        System.out.println();
        System.out.println("Oozie Map-Reduce action configuration");
        System.out.println("=======================");
        Configuration actionConf = new Configuration(false);
        actionConf.addResource(new Path("file:///", System.getProperty("oozie.action.conf.xml")));
        MapReduceMain.logMasking("Map-Reduce job configuration:", new HashSet<String>(), (Iterable)actionConf);
        String jobId = LauncherMainHadoopUtils.getYarnJobForMapReduceAction((Configuration)actionConf);
        File idFile = new File(System.getProperty("oozie.action.newId"));
        if (jobId != null) {
            if (!idFile.exists()) {
                System.out.print("JobId file is mising: writing now... ");
                this.writeJobIdFile(idFile, jobId);
                System.out.print("Done");
            }
            System.out.println("Exiting launcher");
            System.out.println();
        } else {
            System.out.println("Submitting Oozie action Map-Reduce job");
            System.out.println();
            RunningJob runningJob = this.submitJob(actionConf);
            jobId = runningJob.getID().toString();
            this.writeJobIdFile(idFile, jobId);
        }
        System.out.println("=======================");
        System.out.println();
    }

    protected void writeJobIdFile(File idFile, String jobId) throws IOException {
        Properties props = new Properties();
        props.setProperty("id", jobId);
        FileOutputStream os = new FileOutputStream(idFile);
        props.store(os, "");
        ((OutputStream)os).close();
    }

    protected void addActionConf(JobConf jobConf, Configuration actionConf) {
        for (Map.Entry entry : actionConf) {
            jobConf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected RunningJob submitJob(Configuration actionConf) throws Exception {
        JobConf jobConf = new JobConf();
        this.addActionConf(jobConf, actionConf);
        String uberJar = actionConf.get(OOZIE_MAPREDUCE_UBER_JAR);
        if (uberJar != null && uberJar.trim().length() > 0) {
            jobConf.setJar(uberJar);
        }
        if (System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            jobConf.set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        JobClient jobClient = null;
        RunningJob runJob = null;
        boolean exception = false;
        try {
            jobClient = this.createJobClient(jobConf);
            runJob = jobClient.submitJob(jobConf);
        }
        catch (Exception ex) {
            exception = true;
            throw ex;
        }
        finally {
            try {
                if (jobClient != null) {
                    jobClient.close();
                }
            }
            catch (Exception ex) {
                if (exception) {
                    System.out.println("JobClient Error: " + ex);
                }
                throw ex;
            }
        }
        return runJob;
    }

    protected JobClient createJobClient(JobConf jobConf) throws IOException {
        return new JobClient(jobConf);
    }

    public static void setStrings(Configuration conf, String key, String[] values) {
        if (values != null) {
            conf.setInt(key + ".size", values.length);
            for (int i = 0; i < values.length; ++i) {
                conf.set(key + "." + i, values[i]);
            }
        }
    }

    public static String[] getStrings(Configuration conf, String key) {
        String[] values = new String[conf.getInt(key + ".size", 0)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = conf.get(key + "." + i);
            if (values[i] != null) continue;
            values[i] = "";
        }
        return values;
    }
}

