/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.JavaMainException;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherMainHadoopUtils;

public class JavaMain
extends LauncherMain {
    public static final String JAVA_MAIN_CLASS = "oozie.action.java.main";

    public static void main(String[] args) throws Exception {
        JavaMain.run(JavaMain.class, args);
    }

    @Override
    protected void run(String[] args) throws Exception {
        Configuration actionConf = this.loadActionConf();
        LauncherMainHadoopUtils.killChildYarnJobs((Configuration)actionConf);
        Class klass = actionConf.getClass(JAVA_MAIN_CLASS, Object.class);
        System.out.println("Main class        : " + klass.getName());
        System.out.println("Arguments         :");
        for (String arg : args) {
            System.out.println("                    " + arg);
        }
        System.out.println();
        Method mainMethod = klass.getMethod("main", String[].class);
        try {
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException ex) {
            throw new JavaMainException(ex.getCause());
        }
    }

    protected Configuration loadActionConf() throws IOException {
        Configuration actionConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        actionConf.addResource(new Path("file:///", actionXml));
        return actionConf;
    }
}

