/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.action.hadoop.PrepareActionsDriver;

public class LauncherMapper<K1, V1, K2, V2>
implements Mapper<K1, V1, K2, V2>,
Runnable {
    public static final String CONF_OOZIE_ACTION_MAIN_CLASS = "oozie.launcher.action.main.class";
    public static final String CONF_OOZIE_ACTION_MAX_OUTPUT_DATA = "oozie.action.max.output.data";
    static final String CONF_OOZIE_ACTION_MAIN_ARG_COUNT = "oozie.action.main.arg.count";
    static final String CONF_OOZIE_ACTION_MAIN_ARG_PREFIX = "oozie.action.main.arg.";
    static final String CONF_OOZIE_EXTERNAL_STATS_MAX_SIZE = "oozie.external.stats.max.size";
    static final String COUNTER_GROUP = "oozie.launcher";
    static final String COUNTER_DO_ID_SWAP = "oozie.do.id.swap";
    static final String COUNTER_OUTPUT_DATA = "oozie.output.data";
    static final String COUNTER_STATS_DATA = "oozie.stats.data";
    static final String COUNTER_LAUNCHER_ERROR = "oozie.launcher.error";
    static final String OOZIE_JOB_ID = "oozie.job.id";
    static final String OOZIE_ACTION_ID = "oozie.action.id";
    static final String OOZIE_ACTION_DIR_PATH = "oozie.action.dir.path";
    static final String OOZIE_ACTION_RECOVERY_ID = "oozie.action.recovery.id";
    public static final String ACTION_PREFIX = "oozie.action.";
    public static final String EXTERNAL_CHILD_IDS = "oozie.action.externalChildIDs.properties";
    public static final String EXTERNAL_ACTION_STATS = "oozie.action.stats.properties";
    static final String ACTION_CONF_XML = "action.xml";
    public static final String ACTION_PREPARE_XML = "oozie.action.prepare.xml";
    static final String ACTION_OUTPUT_PROPS = "output.properties";
    static final String ACTION_STATS_PROPS = "stats.properties";
    static final String ACTION_EXTERNAL_CHILD_IDS_PROPS = "externalChildIds.properties";
    static final String ACTION_NEW_ID_PROPS = "newId.properties";
    static final String ACTION_ERROR_PROPS = "error.properties";
    static final String JOB_ID_REGEX = "^job_\\d+_\\d+$";
    private JobConf jobConf;
    private Path actionDir;
    private ScheduledThreadPoolExecutor timer;
    private boolean configFailure = false;
    private LauncherException configureFailureEx;
    private Reporter reporter;

    private void setRecoveryId(Configuration launcherConf, Path actionDir, String recoveryId) throws LauncherException {
        try {
            String jobId = launcherConf.get("mapred.job.id");
            Path path = new Path(actionDir, recoveryId);
            FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)launcherConf);
            if (!fs.exists(path)) {
                try {
                    System.out.printf("Attempt to create recovery file %s\n", path.toString());
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(path));
                    writer.write(jobId);
                    ((Writer)writer).close();
                    System.out.printf("%s successfully written with value '%s'\n", path.toString(), jobId);
                }
                catch (IOException ex) {
                    this.failLauncher(0, "IO error", ex);
                }
            } else {
                FSDataInputStream is = fs.open(path);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
                String id = reader.readLine();
                reader.close();
                System.out.printf("%s found with jobId '%s'\n", path, id);
                if (id == null || !Pattern.matches(JOB_ID_REGEX, id)) {
                    System.out.printf("Malformed jobId %s. Attempt to recover with jobId '%s'\n", id, jobId);
                    fs.delete(path, true);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(path));
                    writer.write(jobId);
                    ((Writer)writer).close();
                    System.out.printf("%s successfully written with value '%s'\n", path.toString(), jobId);
                } else if (!jobId.equals(id)) {
                    this.failLauncher(0, MessageFormat.format("Hadoop job Id mismatch, action file [{0}] declares Id [{1}] current Id [{2}]", path, id, jobId), null);
                }
            }
        }
        catch (IOException ex) {
            this.failLauncher(0, "IO error", ex);
        }
    }

    public LauncherMapper() {
    }

    public void configure(JobConf jobConf) {
        System.out.println();
        System.out.println("Oozie Launcher starts");
        System.out.println();
        this.jobConf = jobConf;
        this.actionDir = new Path(this.getJobConf().get(OOZIE_ACTION_DIR_PATH));
        String recoveryId = jobConf.get(OOZIE_ACTION_RECOVERY_ID, null);
        try {
            this.setRecoveryId((Configuration)jobConf, this.actionDir, recoveryId);
        }
        catch (LauncherException ex) {
            System.out.println("Launcher config error " + ex.getMessage());
            this.configureFailureEx = ex;
            this.configFailure = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(K1 key, V1 value, OutputCollector<K2, V2> collector, Reporter reporter) throws IOException {
        try {
            if (this.configFailure) {
                throw this.configureFailureEx;
            }
            String mainClass = this.getJobConf().get(CONF_OOZIE_ACTION_MAIN_CLASS);
            if (this.getJobConf().getBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", false)) {
                System.err.println("WARNING, workaround for Hadoop 2.0.2-alpha distributed cached issue (MAPREDUCE-4820) enabled");
            }
            String msgPrefix = "Main class [" + mainClass + "], ";
            int errorCode = 0;
            Throwable errorCause = null;
            String errorMessage = null;
            try {
                new LauncherSecurityManager();
            }
            catch (SecurityException ex) {
                errorMessage = "Could not set LauncherSecurityManager";
                errorCause = ex;
            }
            try {
                block34: {
                    this.setupHeartBeater(reporter);
                    this.setupMainConfiguration();
                    try {
                        System.out.println("Starting the execution of prepare actions");
                        this.executePrepare();
                        System.out.println("Completed the execution of prepare actions successfully");
                    }
                    catch (Exception ex) {
                        System.out.println("Prepare execution in the Launcher Mapper has failed");
                        throw new LauncherException(ex.getMessage(), ex);
                    }
                    String[] args = LauncherMapper.getMainArguments((Configuration)this.getJobConf());
                    this.printContentsOfCurrentDir();
                    System.out.println();
                    System.out.println("Oozie Java/Map-Reduce/Pig action launcher-job configuration");
                    System.out.println("=================================================================");
                    System.out.println("Workflow job id   : " + System.getProperty(OOZIE_JOB_ID));
                    System.out.println("Workflow action id: " + System.getProperty(OOZIE_ACTION_ID));
                    System.out.println();
                    System.out.println("Classpath         :");
                    System.out.println("------------------------");
                    StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path"), ":");
                    while (st.hasMoreTokens()) {
                        System.out.println("  " + st.nextToken());
                    }
                    System.out.println("------------------------");
                    System.out.println();
                    System.out.println("Main class        : " + mainClass);
                    System.out.println();
                    System.out.println("Maximum output    : " + this.getJobConf().getInt(CONF_OOZIE_ACTION_MAX_OUTPUT_DATA, 2048));
                    System.out.println();
                    System.out.println("Arguments         :");
                    for (String arg : args) {
                        System.out.println("                    " + arg);
                    }
                    System.out.println();
                    System.out.println("Java System Properties:");
                    System.out.println("------------------------");
                    System.getProperties().store(System.out, "");
                    System.out.flush();
                    System.out.println("------------------------");
                    System.out.println();
                    System.out.println("=================================================================");
                    System.out.println();
                    System.out.println(">>> Invoking Main class now >>>");
                    System.out.println();
                    System.out.flush();
                    try {
                        Class klass = this.getJobConf().getClass(CONF_OOZIE_ACTION_MAIN_CLASS, Object.class);
                        Method mainMethod = klass.getMethod("main", String[].class);
                        mainMethod.invoke(null, new Object[]{args});
                    }
                    catch (InvocationTargetException ex) {
                        if (LauncherMainException.class.isInstance(ex.getCause())) {
                            errorMessage = msgPrefix + "exit code [" + ((LauncherMainException)ex.getCause()).getErrorCode() + "]";
                            errorCause = null;
                            break block34;
                        }
                        if (SecurityException.class.isInstance(ex.getCause())) {
                            if (LauncherSecurityManager.getExitInvoked()) {
                                System.out.println("Intercepting System.exit(" + LauncherSecurityManager.getExitCode() + ")");
                                System.err.println("Intercepting System.exit(" + LauncherSecurityManager.getExitCode() + ")");
                                errorCode = LauncherSecurityManager.getExitCode();
                                if (errorCode != 0) {
                                    errorMessage = msgPrefix + "exit code [" + errorCode + "]";
                                    errorCause = null;
                                }
                            }
                            break block34;
                        }
                        throw ex;
                    }
                    finally {
                        System.out.println();
                        System.out.println("<<< Invocation of Main class completed <<<");
                        System.out.println();
                        this.handleExternalChildIDs(reporter);
                    }
                }
                if (errorMessage == null) {
                    File outputData = new File(System.getProperty("oozie.action.output.properties"));
                    if (outputData.exists()) {
                        URI actionDirUri = new Path(this.actionDir, ACTION_OUTPUT_PROPS).toUri();
                        FileSystem fs = FileSystem.get((URI)actionDirUri, (Configuration)this.getJobConf());
                        fs.copyFromLocalFile(new Path(outputData.toString()), new Path(this.actionDir, ACTION_OUTPUT_PROPS));
                        reporter.incrCounter(COUNTER_GROUP, COUNTER_OUTPUT_DATA, 1L);
                        int maxOutputData = this.getJobConf().getInt(CONF_OOZIE_ACTION_MAX_OUTPUT_DATA, 2048);
                        if (outputData.length() > (long)maxOutputData) {
                            String msg = MessageFormat.format("Output data size [{0}] exceeds maximum [{1}]", outputData.length(), maxOutputData);
                            this.failLauncher(0, msg, null);
                        }
                        System.out.println();
                        System.out.println("Oozie Launcher, capturing output data:");
                        System.out.println("=======================");
                        Properties props = new Properties();
                        props.load(new FileReader(outputData));
                        props.store(System.out, "");
                        System.out.println();
                        System.out.println("=======================");
                        System.out.println();
                    }
                    this.handleActionStatsData(reporter);
                    this.handleExternalChildIDs(reporter);
                    File newId = new File(System.getProperty("oozie.action.newId.properties"));
                    if (newId.exists()) {
                        Properties props = new Properties();
                        props.load(new FileReader(newId));
                        if (props.getProperty("id") == null) {
                            throw new IllegalStateException("ID swap file does not have [id] property");
                        }
                        URI actionDirUri = new Path(this.actionDir, ACTION_NEW_ID_PROPS).toUri();
                        FileSystem fs = FileSystem.get((URI)actionDirUri, (Configuration)this.getJobConf());
                        fs.copyFromLocalFile(new Path(newId.toString()), new Path(this.actionDir, ACTION_NEW_ID_PROPS));
                        reporter.incrCounter(COUNTER_GROUP, COUNTER_DO_ID_SWAP, 1L);
                        System.out.println("Oozie Launcher, copying new Hadoop job id to file: " + new Path(this.actionDir, ACTION_NEW_ID_PROPS).toUri());
                        System.out.println();
                        System.out.println("Oozie Launcher, propagating new Hadoop job id to Oozie");
                        System.out.println("=======================");
                        System.out.println("id: " + props.getProperty("id"));
                        System.out.println("=======================");
                        System.out.println();
                    }
                }
            }
            catch (NoSuchMethodException ex) {
                errorMessage = msgPrefix + "main() method not found";
                errorCause = ex;
            }
            catch (InvocationTargetException ex) {
                errorMessage = msgPrefix + "main() threw exception";
                errorCause = ex.getTargetException();
            }
            catch (Throwable ex) {
                errorMessage = msgPrefix + "exception invoking main()";
                errorCause = ex;
            }
            finally {
                this.destroyHeartBeater();
                if (errorMessage != null) {
                    this.failLauncher(errorCode, errorMessage, errorCause);
                }
            }
        }
        catch (LauncherException ex) {
            reporter.incrCounter(COUNTER_GROUP, COUNTER_LAUNCHER_ERROR, 1L);
            System.out.println();
            System.out.println("Oozie Launcher failed, finishing Hadoop job gracefully");
            System.out.println();
        }
    }

    public void close() throws IOException {
        System.out.println();
        System.out.println("Oozie Launcher ends");
        System.out.println();
    }

    protected JobConf getJobConf() {
        return this.jobConf;
    }

    private void handleActionStatsData(Reporter reporter) throws IOException, LauncherException {
        File actionStatsData = new File(System.getProperty(EXTERNAL_ACTION_STATS));
        if (actionStatsData.exists()) {
            int statsMaxOutputData = this.getJobConf().getInt(CONF_OOZIE_EXTERNAL_STATS_MAX_SIZE, Integer.MAX_VALUE);
            reporter.incrCounter(COUNTER_GROUP, COUNTER_STATS_DATA, 1L);
            if (actionStatsData.length() > (long)statsMaxOutputData) {
                String msg = MessageFormat.format("Output stats size [{0}] exceeds maximum [{1}]", actionStatsData.length(), statsMaxOutputData);
                this.failLauncher(0, msg, null);
            }
            URI actionDirUri = new Path(this.actionDir, ACTION_STATS_PROPS).toUri();
            FileSystem fs = FileSystem.get((URI)actionDirUri, (Configuration)this.getJobConf());
            fs.copyFromLocalFile(new Path(actionStatsData.toString()), new Path(this.actionDir, ACTION_STATS_PROPS));
        }
    }

    private void handleExternalChildIDs(Reporter reporter) throws IOException {
        File externalChildIDs = new File(System.getProperty(EXTERNAL_CHILD_IDS));
        if (externalChildIDs.exists()) {
            URI actionDirUri = new Path(this.actionDir, ACTION_EXTERNAL_CHILD_IDS_PROPS).toUri();
            FileSystem fs = FileSystem.get((URI)actionDirUri, (Configuration)this.getJobConf());
            fs.copyFromLocalFile(new Path(externalChildIDs.toString()), new Path(this.actionDir, ACTION_EXTERNAL_CHILD_IDS_PROPS));
        }
    }

    private void setupMainConfiguration() throws IOException {
        Path pathNew = new Path(new Path(this.actionDir, ACTION_CONF_XML), new Path(new File(ACTION_CONF_XML).getAbsolutePath()));
        FileSystem fs = FileSystem.get((URI)pathNew.toUri(), (Configuration)this.getJobConf());
        fs.copyToLocalFile(new Path(this.actionDir, ACTION_CONF_XML), new Path(new File(ACTION_CONF_XML).getAbsolutePath()));
        System.setProperty("oozie.launcher.job.id", this.getJobConf().get("mapred.job.id"));
        System.setProperty(OOZIE_JOB_ID, this.getJobConf().get(OOZIE_JOB_ID));
        System.setProperty(OOZIE_ACTION_ID, this.getJobConf().get(OOZIE_ACTION_ID));
        System.setProperty("oozie.action.conf.xml", new File(ACTION_CONF_XML).getAbsolutePath());
        System.setProperty("oozie.action.output.properties", new File(ACTION_OUTPUT_PROPS).getAbsolutePath());
        System.setProperty(EXTERNAL_ACTION_STATS, new File(ACTION_STATS_PROPS).getAbsolutePath());
        System.setProperty(EXTERNAL_CHILD_IDS, new File(ACTION_EXTERNAL_CHILD_IDS_PROPS).getAbsolutePath());
        System.setProperty("oozie.action.newId.properties", new File(ACTION_NEW_ID_PROPS).getAbsolutePath());
    }

    private void executePrepare() throws IOException, LauncherException {
        String prepareXML = this.getJobConf().get(ACTION_PREPARE_XML);
        if (prepareXML != null) {
            if (!prepareXML.equals("")) {
                Configuration actionConf = new Configuration((Configuration)this.getJobConf());
                String actionXml = System.getProperty("oozie.action.conf.xml");
                actionConf.addResource(new Path("file:///", actionXml));
                PrepareActionsDriver.doOperations(prepareXML, actionConf);
            } else {
                System.out.println("There are no prepare actions to execute.");
            }
        }
    }

    public static String[] getMainArguments(Configuration conf) {
        String[] args = new String[conf.getInt(CONF_OOZIE_ACTION_MAIN_ARG_COUNT, 0)];
        for (int i = 0; i < args.length; ++i) {
            args[i] = conf.get(CONF_OOZIE_ACTION_MAIN_ARG_PREFIX + i);
        }
        return args;
    }

    private void setupHeartBeater(Reporter reporter) {
        this.timer = new ScheduledThreadPoolExecutor(1);
        this.timer.scheduleAtFixedRate(new LauncherMapper<K1, V1, K2, V2>(reporter), 0L, 30L, TimeUnit.SECONDS);
    }

    private void destroyHeartBeater() {
        this.timer.shutdownNow();
    }

    private LauncherMapper(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void run() {
        System.out.println("Heart beat");
        this.reporter.progress();
    }

    private void failLauncher(int errorCode, String reason, Throwable ex) throws LauncherException {
        try {
            if (ex != null) {
                reason = reason + ", " + ex.getMessage();
            }
            Properties errorProps = new Properties();
            errorProps.setProperty("error.code", Integer.toString(errorCode));
            errorProps.setProperty("error.reason", reason);
            if (ex != null) {
                if (ex.getMessage() != null) {
                    errorProps.setProperty("exception.message", ex.getMessage());
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.close();
                errorProps.setProperty("exception.stacktrace", sw.toString());
            }
            FileSystem fs = FileSystem.get((URI)new Path(this.actionDir, ACTION_ERROR_PROPS).toUri(), (Configuration)this.getJobConf());
            FSDataOutputStream os = fs.create(new Path(this.actionDir, ACTION_ERROR_PROPS));
            errorProps.store((OutputStream)os, "");
            os.close();
            System.out.print("Failing Oozie Launcher, " + reason + "\n");
            System.err.print("Failing Oozie Launcher, " + reason + "\n");
            if (ex != null) {
                ex.printStackTrace(System.out);
                ex.printStackTrace(System.err);
            }
            throw new LauncherException(reason, ex);
        }
        catch (IOException rex) {
            throw new RuntimeException("Error while failing launcher, " + rex.getMessage(), rex);
        }
    }

    protected void printContentsOfCurrentDir() {
        File[] listOfFiles;
        File folder = new File(".");
        System.out.println();
        System.out.println("Files in current dir:" + folder.getAbsolutePath());
        System.out.println("======================");
        for (File fileName : listOfFiles = folder.listFiles()) {
            File[] moreFiles;
            if (fileName.isFile()) {
                System.out.println("File: " + fileName.getName());
                continue;
            }
            if (!fileName.isDirectory()) continue;
            System.out.println("Dir: " + fileName.getName());
            File subDir = new File(fileName.getName());
            for (File subFileName : moreFiles = subDir.listFiles()) {
                if (subFileName.isFile()) {
                    System.out.println("  File: " + subFileName.getName());
                    continue;
                }
                if (!subFileName.isDirectory()) continue;
                System.out.println("  Dir: " + subFileName.getName());
            }
        }
    }
}

