/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherURIHandler;

public class FSLauncherURIHandler
implements LauncherURIHandler {
    @Override
    public boolean create(URI uri, Configuration conf) throws LauncherException {
        boolean status = false;
        try {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
            Path path = this.getNormalizedPath(uri);
            if (!fs.exists(path)) {
                status = fs.mkdirs(path);
                if (status) {
                    System.out.println("Creating directory at " + path + " succeeded.");
                } else {
                    System.out.println("Creating directory at " + path + " failed.");
                }
            }
        }
        catch (IOException e) {
            throw new LauncherException("Creating directory at " + uri + " failed.", e);
        }
        return status;
    }

    @Override
    public boolean delete(URI uri, Configuration conf) throws LauncherException {
        boolean status = false;
        try {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
            Path path = this.getNormalizedPath(uri);
            if (fs.exists(path)) {
                status = fs.delete(path, true);
                if (status) {
                    System.out.println("Deletion of path " + path + " succeeded.");
                } else {
                    System.out.println("Deletion of path " + path + " failed.");
                }
            }
        }
        catch (IOException e) {
            throw new LauncherException("Deletion of path " + uri + " failed.", e);
        }
        return status;
    }

    private Path getNormalizedPath(URI uri) {
        return new Path(uri.getScheme(), uri.getAuthority(), uri.getPath());
    }

    @Override
    public List<Class<?>> getClassesForLauncher() {
        return null;
    }
}

