/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hive.beeline.BeeLine;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherMainHadoopUtils;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.action.hadoop.MapReduceMain;

public class HiveServer2Main
extends LauncherMain {
    private static final Set<String> DISALLOWED_BEELINE_OPTIONS = new HashSet<String>();

    public static void main(String[] args) throws Exception {
        HiveServer2Main.run(HiveServer2Main.class, (String[])args);
    }

    private static Configuration initActionConf() {
        Configuration actionConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        System.out.println("Using action configuration file " + actionXml);
        actionConf.addResource(new Path("file:///", actionXml));
        String delegationToken = HiveServer2Main.getFilePathFromEnv((String)"HADOOP_TOKEN_FILE_LOCATION");
        if (delegationToken != null) {
            actionConf.set("mapreduce.job.credentials.binary", delegationToken);
            System.out.println("------------------------");
            System.out.println("Setting env property for mapreduce.job.credentials.binary to: " + delegationToken);
            System.out.println("------------------------");
            System.setProperty("mapreduce.job.credentials.binary", delegationToken);
        } else {
            System.out.println("Non-Kerberos execution");
        }
        actionConf.set("datanucleus.plugin.pluginRegistryBundleCheck", "LOG");
        return actionConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(String[] args) throws Exception {
        String[] beelineArgs;
        System.out.println();
        System.out.println("Oozie Hive Server 2 action configuration");
        System.out.println("=================================================================");
        System.out.println();
        Configuration actionConf = HiveServer2Main.initActionConf();
        ArrayList<String> arguments = new ArrayList<String>();
        String jdbcUrl = actionConf.get("oozie.hiveserver2.jdbc.url");
        if (jdbcUrl == null) {
            throw new RuntimeException("Action Configuration does not have [oozie.hiveserver2.jdbc.url] property");
        }
        arguments.add("-u");
        arguments.add(jdbcUrl);
        String username = actionConf.get("user.name");
        arguments.add("-n");
        arguments.add(username);
        String password = actionConf.get("oozie.hiveserver2.password");
        if (password == null) {
            throw new RuntimeException("Action Configuration does not have [oozie.hiveserver2.password] property");
        }
        arguments.add("-p");
        arguments.add(password);
        arguments.add("-d");
        arguments.add("org.apache.hive.jdbc.HiveDriver");
        String scriptPath = actionConf.get("oozie.hiveserver2.script");
        if (scriptPath == null) {
            throw new RuntimeException("Action Configuration does not have [oozie.hiveserver2.script] property");
        }
        if (!new File(scriptPath).exists()) {
            throw new RuntimeException("Hive Server 2 script file [" + scriptPath + "] does not exist");
        }
        File localDir = new File("dummy").getAbsoluteFile().getParentFile();
        System.out.println("Current (local) dir = " + localDir.getAbsolutePath());
        System.out.println("------------------------");
        for (String file : localDir.list()) {
            System.out.println("  " + file);
        }
        System.out.println("------------------------");
        System.out.println();
        String script = HiveServer2Main.readStringFromFile(scriptPath);
        System.out.println();
        System.out.println("Script [" + scriptPath + "] content: ");
        System.out.println("------------------------");
        System.out.println(script);
        System.out.println("------------------------");
        System.out.println();
        String[] params = MapReduceMain.getStrings((Configuration)actionConf, (String)"oozie.hiveserver2.params");
        if (params.length > 0) {
            System.out.println("Parameters:");
            System.out.println("------------------------");
            for (String param : params) {
                System.out.println("  " + param);
                int idx = param.indexOf(61);
                if (idx == -1) {
                    throw new RuntimeException("Parameter expression must contain an assignment: " + param);
                }
                if (idx == 0) {
                    throw new RuntimeException("Parameter value not specified: " + param);
                }
                arguments.add("--hivevar");
                arguments.add(param);
            }
            System.out.println("------------------------");
            System.out.println();
        }
        arguments.add("-f");
        arguments.add(scriptPath);
        arguments.add("-a");
        arguments.add("delegationToken");
        for (String beelineArg : beelineArgs = MapReduceMain.getStrings((Configuration)actionConf, (String)"oozie.hiveserver2.args")) {
            if (DISALLOWED_BEELINE_OPTIONS.contains(beelineArg)) {
                throw new RuntimeException("Error: Beeline argument " + beelineArg + " is not supported");
            }
            arguments.add(beelineArg);
        }
        System.out.println("Beeline command arguments :");
        for (String arg : arguments) {
            System.out.println("             " + arg);
        }
        System.out.println();
        LauncherMainHadoopUtils.killChildYarnJobs((Configuration)actionConf);
        System.out.println("=================================================================");
        System.out.println();
        System.out.println(">>> Invoking Beeline command line now >>>");
        System.out.println();
        System.out.flush();
        try {
            this.runBeeline(arguments.toArray(new String[arguments.size()]));
        }
        catch (SecurityException ex) {
            if (LauncherSecurityManager.getExitInvoked() && LauncherSecurityManager.getExitCode() != 0) {
                throw ex;
            }
        }
        finally {
            System.out.println("\n<<< Invocation of Beeline command completed <<<\n");
        }
    }

    private void runBeeline(String[] args) throws Exception {
        BeeLine.main((String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStringFromFile(String filePath) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(filePath));
            StringBuilder sb = new StringBuilder();
            String sep = System.getProperty("line.separator");
            while ((line = br.readLine()) != null) {
                sb.append(line).append(sep);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    static {
        DISALLOWED_BEELINE_OPTIONS.add("-u");
        DISALLOWED_BEELINE_OPTIONS.add("-n");
        DISALLOWED_BEELINE_OPTIONS.add("-p");
        DISALLOWED_BEELINE_OPTIONS.add("-d");
        DISALLOWED_BEELINE_OPTIONS.add("-e");
        DISALLOWED_BEELINE_OPTIONS.add("-f");
        DISALLOWED_BEELINE_OPTIONS.add("-a");
        DISALLOWED_BEELINE_OPTIONS.add("--help");
    }
}

