/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.action.hadoop.MapReduceMain;

public class HiveMain
extends LauncherMain {
    private static final Pattern[] HIVE_JOB_IDS_PATTERNS = new Pattern[]{Pattern.compile("Ended Job = (job_\\S*)")};
    private static final Set<String> DISALLOWED_HIVE_OPTIONS = new HashSet<String>();
    public static final String HIVE_L4J_PROPS = "hive-log4j.properties";
    public static final String HIVE_EXEC_L4J_PROPS = "hive-exec-log4j.properties";
    public static final String HIVE_SITE_CONF = "hive-site.xml";

    public static void main(String[] args) throws Exception {
        HiveMain.run(HiveMain.class, (String[])args);
    }

    private static Configuration initActionConf() {
        Configuration hiveConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        System.out.println("Using action configuration file " + actionXml);
        hiveConf.addResource(new Path("file:///", actionXml));
        String delegationToken = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
        if (delegationToken != null) {
            hiveConf.set("mapreduce.job.credentials.binary", delegationToken);
            System.out.println("------------------------");
            System.out.println("Setting env property for mapreduce.job.credentials.binary to: " + delegationToken);
            System.out.println("------------------------");
            System.setProperty("mapreduce.job.credentials.binary", delegationToken);
        } else {
            System.out.println("Non-Kerberos execution");
        }
        hiveConf.set("mapred.job.name", "");
        hiveConf.set("datanucleus.plugin.pluginRegistryBundleCheck", "LOG");
        hiveConf.setBoolean("hive.exec.mode.local.auto", false);
        return hiveConf;
    }

    public static String setUpHiveLog4J(Configuration hiveConf) throws IOException {
        String hadoopJobId = System.getProperty("oozie.launcher.job.id");
        if (hadoopJobId == null) {
            throw new RuntimeException("Launcher Hadoop Job ID system property not set");
        }
        String logFile = new File("hive-oozie-" + hadoopJobId + ".log").getAbsolutePath();
        Properties hadoopProps = new Properties();
        URL log4jFile = Thread.currentThread().getContextClassLoader().getResource("log4j.properties");
        if (log4jFile != null) {
            hadoopProps.load(log4jFile.openStream());
        }
        String logLevel = hiveConf.get("oozie.hive.log.level", "INFO");
        hadoopProps.setProperty("log4j.logger.org.apache.hadoop.hive", logLevel + ", A");
        hadoopProps.setProperty("log4j.logger.hive", logLevel + ", A");
        hadoopProps.setProperty("log4j.logger.DataNucleus", logLevel + ", A");
        hadoopProps.setProperty("log4j.logger.DataStore", logLevel + ", A");
        hadoopProps.setProperty("log4j.logger.JPOX", logLevel + ", A");
        hadoopProps.setProperty("log4j.appender.A", "org.apache.log4j.ConsoleAppender");
        hadoopProps.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout");
        hadoopProps.setProperty("log4j.appender.A.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        hadoopProps.setProperty("log4j.appender.jobid", "org.apache.log4j.FileAppender");
        hadoopProps.setProperty("log4j.appender.jobid.file", logFile);
        hadoopProps.setProperty("log4j.appender.jobid.layout", "org.apache.log4j.PatternLayout");
        hadoopProps.setProperty("log4j.appender.jobid.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        hadoopProps.setProperty("log4j.logger.org.apache.hadoop.hive.ql.exec", "INFO, jobid");
        String localProps = new File(HIVE_L4J_PROPS).getAbsolutePath();
        FileOutputStream os1 = new FileOutputStream(localProps);
        hadoopProps.store(os1, "");
        ((OutputStream)os1).close();
        localProps = new File(HIVE_EXEC_L4J_PROPS).getAbsolutePath();
        os1 = new FileOutputStream(localProps);
        hadoopProps.store(os1, "");
        ((OutputStream)os1).close();
        return logFile;
    }

    public static Configuration setUpHiveSite() throws Exception {
        Configuration hiveConf = HiveMain.initActionConf();
        FileOutputStream os = new FileOutputStream(HIVE_SITE_CONF);
        hiveConf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        System.out.println();
        System.out.println("Hive Configuration Properties:");
        System.out.println("------------------------");
        for (Map.Entry entry : hiveConf) {
            System.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        System.out.flush();
        System.out.println("------------------------");
        System.out.println();
        Field declaredField = HiveConf.class.getDeclaredField("hiveSiteURL");
        if (declaredField != null) {
            declaredField.setAccessible(true);
            declaredField.set(null, HiveConf.class.getClassLoader().getResource(HIVE_SITE_CONF));
        }
        return hiveConf;
    }

    protected void run(String[] args) throws Exception {
        String logFile;
        block12: {
            String[] hiveArgs;
            System.out.println();
            System.out.println("Oozie Hive action configuration");
            System.out.println("=================================================================");
            System.out.println();
            Configuration hiveConf = HiveMain.setUpHiveSite();
            ArrayList<String> arguments = new ArrayList<String>();
            String scriptPath = hiveConf.get("oozie.hive.script");
            if (scriptPath == null) {
                throw new RuntimeException("Action Configuration does not have [oozie.hive.script] property");
            }
            if (!new File(scriptPath).exists()) {
                throw new RuntimeException("Hive script file [" + scriptPath + "] does not exist");
            }
            logFile = HiveMain.setUpHiveLog4J(hiveConf);
            File localDir = new File("dummy").getAbsoluteFile().getParentFile();
            System.out.println("Current (local) dir = " + localDir.getAbsolutePath());
            System.out.println("------------------------");
            for (String file : localDir.list()) {
                System.out.println("  " + file);
            }
            System.out.println("------------------------");
            System.out.println();
            String script = HiveMain.readStringFromFile(scriptPath);
            System.out.println();
            System.out.println("Script [" + scriptPath + "] content: ");
            System.out.println("------------------------");
            System.out.println(script);
            System.out.println("------------------------");
            System.out.println();
            String[] params = MapReduceMain.getStrings((Configuration)hiveConf, (String)"oozie.hive.params");
            if (params.length > 0) {
                System.out.println("Parameters:");
                System.out.println("------------------------");
                for (String param : params) {
                    System.out.println("  " + param);
                    int idx = param.indexOf(61);
                    if (idx == -1) {
                        throw new RuntimeException("Parameter expression must contain an assignment: " + param);
                    }
                    if (idx == 0) {
                        throw new RuntimeException("Parameter value not specified: " + param);
                    }
                    arguments.add("--hivevar");
                    arguments.add(param);
                }
                System.out.println("------------------------");
                System.out.println();
            }
            arguments.add("-f");
            arguments.add(scriptPath);
            for (String hiveArg : hiveArgs = MapReduceMain.getStrings((Configuration)hiveConf, (String)"oozie.hive.args")) {
                if (DISALLOWED_HIVE_OPTIONS.contains(hiveArg)) {
                    throw new RuntimeException("Error: Hive argument " + hiveArg + " is not supported");
                }
                arguments.add(hiveArg);
            }
            System.out.println("Hive command arguments :");
            for (String arg : arguments) {
                System.out.println("             " + arg);
            }
            System.out.println();
            System.out.println("=================================================================");
            System.out.println();
            System.out.println(">>> Invoking Hive command line now >>>");
            System.out.println();
            System.out.flush();
            try {
                this.runHive(arguments.toArray(new String[arguments.size()]));
            }
            catch (SecurityException ex) {
                if (!LauncherSecurityManager.getExitInvoked() || LauncherSecurityManager.getExitCode() == 0) break block12;
                this.writeExternalChildIDs(logFile);
                throw ex;
            }
        }
        System.out.println("\n<<< Invocation of Hive command completed <<<\n");
        Properties jobIds = HiveMain.getHadoopJobIds((String)logFile, (Pattern[])HIVE_JOB_IDS_PATTERNS);
        File file = new File(System.getProperty("oozie.action.output.properties"));
        FileOutputStream os = new FileOutputStream(file);
        jobIds.store(os, "");
        ((OutputStream)os).close();
        System.out.println(" Hadoop Job IDs executed by Hive: " + jobIds.getProperty("hadoopJobs"));
        System.out.println();
    }

    private void writeExternalChildIDs(String logFile) {
        try {
            Properties jobIds = HiveMain.getHadoopJobIds((String)logFile, (Pattern[])HIVE_JOB_IDS_PATTERNS);
            File file = new File(System.getProperty("oozie.action.externalChildIDs.properties"));
            String hadoopJobIDs = jobIds.getProperty("hadoopJobs");
            FileOutputStream os = new FileOutputStream(file);
            ((OutputStream)os).write(hadoopJobIDs.getBytes());
            ((OutputStream)os).close();
            System.out.println(" Hadoop Job IDs executed by Hive: " + hadoopJobIDs);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("WARN: Error getting Hadoop Job IDs executed by Hive");
            e.printStackTrace(System.out);
        }
    }

    private void runHive(String[] args) throws Exception {
        CliDriver.main((String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStringFromFile(String filePath) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(filePath));
            StringBuilder sb = new StringBuilder();
            String sep = System.getProperty("line.separator");
            while ((line = br.readLine()) != null) {
                sb.append(line).append(sep);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    static {
        DISALLOWED_HIVE_OPTIONS.add("-d");
        DISALLOWED_HIVE_OPTIONS.add("--define");
        DISALLOWED_HIVE_OPTIONS.add("-e");
        DISALLOWED_HIVE_OPTIONS.add("-f");
        DISALLOWED_HIVE_OPTIONS.add("-H");
        DISALLOWED_HIVE_OPTIONS.add("--help");
        DISALLOWED_HIVE_OPTIONS.add("--hiveconf");
        DISALLOWED_HIVE_OPTIONS.add("--hivevar");
        DISALLOWED_HIVE_OPTIONS.add("-s");
        DISALLOWED_HIVE_OPTIONS.add("--silent");
        DISALLOWED_HIVE_OPTIONS.add("-D");
    }
}

