/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.util.Tool;
import org.apache.oozie.action.hadoop.JavaMain;
import org.apache.oozie.action.hadoop.JavaMainException;
import org.apache.oozie.action.hadoop.LauncherMainHadoopUtils;

public class DistcpMain
extends JavaMain {
    private Constructor<?> construct;
    private Object[] constArgs;

    public static void main(String[] args) throws Exception {
        DistcpMain.run(DistcpMain.class, (String[])args);
    }

    protected void run(String[] args) throws Exception {
        Configuration actionConf = this.loadActionConf();
        LauncherMainHadoopUtils.killChildYarnJobs((Configuration)actionConf);
        Class klass = actionConf.getClass("oozie.launcher.action.main.class", DistCp.class);
        System.out.println("Main class        : " + klass.getName());
        System.out.println("Arguments         :");
        for (String arg : args) {
            System.out.println("                    " + arg);
        }
        if (DistcpMain.getFilePathFromEnv((String)"HADOOP_TOKEN_FILE_LOCATION") != null) {
            actionConf.set("mapreduce.job.credentials.binary", DistcpMain.getFilePathFromEnv((String)"HADOOP_TOKEN_FILE_LOCATION"));
        }
        this.getConstructorAndArgs(klass, actionConf);
        if (this.construct == null) {
            throw new RuntimeException("Distcp constructor was not found, unable to instantiate");
        }
        if (this.constArgs == null) {
            throw new RuntimeException("Arguments for distcp constructor is null, unable to instantiate");
        }
        try {
            Tool distcp = (Tool)this.construct.newInstance(this.constArgs);
            int i = distcp.run(args);
            if (i != 0) {
                throw new RuntimeException("Returned value from distcp is non-zero (" + i + ")");
            }
        }
        catch (InvocationTargetException ex) {
            throw new JavaMainException(ex.getCause());
        }
    }

    protected void getConstructorAndArgs(Class<?> klass, Configuration actionConf) throws Exception {
        Constructor<?>[] allConstructors;
        for (Constructor<?> cstruct : allConstructors = klass.getConstructors()) {
            Class<?>[] pType = cstruct.getParameterTypes();
            this.construct = cstruct;
            if (pType.length == 1 && pType[0].equals(Class.forName("org.apache.hadoop.conf.Configuration"))) {
                System.out.println("found Distcp v1 Constructor");
                System.out.println("                    " + cstruct.toString());
                this.constArgs = new Object[1];
                this.constArgs[0] = actionConf;
                break;
            }
            if (pType.length != 2 || !pType[0].equals(Class.forName("org.apache.hadoop.conf.Configuration"))) continue;
            System.out.println("found Distcp v2 Constructor");
            System.out.println("                    " + cstruct.toString());
            this.constArgs = new Object[2];
            this.constArgs[0] = actionConf;
            this.constArgs[1] = null;
            break;
        }
    }
}

