/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.example;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.action.hadoop.OozieActionConfigurator;
import org.apache.oozie.action.hadoop.OozieActionConfiguratorException;
import org.apache.oozie.example.SampleMapper;
import org.apache.oozie.example.SampleReducer;

public class SampleOozieActionConfigurator
implements OozieActionConfigurator {
    public void configure(JobConf actionConf) throws OozieActionConfiguratorException {
        if (actionConf.getUser() == null) {
            throw new OozieActionConfiguratorException("No user set");
        }
        if (actionConf.get("examples.root") == null) {
            throw new OozieActionConfiguratorException("examples.root not set");
        }
        if (actionConf.get("output.dir.name") == null) {
            throw new OozieActionConfiguratorException("output.dir.name not set");
        }
        actionConf.setMapperClass(SampleMapper.class);
        actionConf.setReducerClass(SampleReducer.class);
        actionConf.setNumMapTasks(1);
        FileInputFormat.setInputPaths((JobConf)actionConf, (Path[])new Path[]{new Path("/user/" + actionConf.getUser() + "/input-data/text")});
        FileOutputFormat.setOutputPath((JobConf)actionConf, (Path)new Path("/user/" + actionConf.getUser() + "/output-data/" + actionConf.get("output.dir.name")));
    }
}

