/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.util.Properties;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class XOozieClient
extends OozieClient {
    public static final String JT = "mapred.job.tracker";
    public static final String JT_2 = "mapreduce.jobtracker.address";
    public static final String NN = "fs.default.name";
    public static final String NN_2 = "fs.defaultFS";
    @Deprecated
    public static final String JT_PRINCIPAL = "mapreduce.jobtracker.kerberos.principal";
    @Deprecated
    public static final String NN_PRINCIPAL = "dfs.namenode.kerberos.principal";
    public static final String PIG_SCRIPT = "oozie.pig.script";
    public static final String PIG_OPTIONS = "oozie.pig.options";
    public static final String FILES = "oozie.files";
    public static final String ARCHIVES = "oozie.archives";
    public static final String IS_PROXY_SUBMISSION = "oozie.proxysubmission";

    protected XOozieClient() {
    }

    public XOozieClient(String oozieUrl) {
        super(oozieUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPigScript(String script) throws IOException {
        if (!new File(script).exists()) {
            throw new IOException("Error: Pig script file [" + script + "] does not exist");
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(script));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {
                System.err.println("Error: " + ex.getMessage());
            }
        }
    }

    static void setStrings(Properties conf, String key, String[] values) {
        if (values != null) {
            conf.setProperty(key + ".size", new Integer(values.length).toString());
            for (int i = 0; i < values.length; ++i) {
                conf.setProperty(key + "." + i, values[i]);
            }
        }
    }

    private void validateHttpSubmitConf(Properties conf) {
        String JT = conf.getProperty(JT);
        String JT_2 = conf.getProperty(JT_2);
        if (JT == null && JT_2 == null) {
            throw new RuntimeException("jobtracker is not specified in conf");
        }
        String NN = conf.getProperty(NN);
        String NN_2 = conf.getProperty(NN_2);
        if (NN == null && NN_2 == null) {
            throw new RuntimeException("namenode is not specified in conf");
        }
        String libPath = conf.getProperty("oozie.libpath");
        if (libPath == null) {
            throw new RuntimeException("libpath is not specified in conf");
        }
        if (!libPath.contains(":/")) {
            String newLibPath;
            if (libPath.startsWith("/")) {
                newLibPath = NN.endsWith("/") ? NN + libPath.substring(1) : NN + libPath;
            } else {
                throw new RuntimeException("libpath should be absolute");
            }
            conf.setProperty("oozie.libpath", newLibPath);
        }
        conf.setProperty(IS_PROXY_SUBMISSION, "true");
    }

    public String submitPig(Properties conf, String pigScriptFile, String[] pigArgs) throws IOException, OozieClientException {
        if (conf == null) {
            throw new IllegalArgumentException("conf cannot be null");
        }
        if (pigScriptFile == null) {
            throw new IllegalArgumentException("pigScriptFile cannot be null");
        }
        this.validateHttpSubmitConf(conf);
        conf.setProperty(PIG_SCRIPT, this.readPigScript(pigScriptFile));
        XOozieClient.setStrings(conf, PIG_OPTIONS, pigArgs);
        return (String)new HttpJobSubmit(conf, "pig").call();
    }

    public String submitMapReduce(Properties conf) throws OozieClientException {
        if (conf == null) {
            throw new IllegalArgumentException("conf cannot be null");
        }
        this.validateHttpSubmitConf(conf);
        return (String)new HttpJobSubmit(conf, "mapreduce").call();
    }

    public void setLib(Properties conf, String pathStr) {
        conf.setProperty("oozie.libpath", pathStr);
    }

    public void addFile(Properties conf, String file) {
        if (file == null || file.length() == 0) {
            throw new IllegalArgumentException("file cannot be null or empty");
        }
        String files = conf.getProperty(FILES);
        conf.setProperty(FILES, files == null ? file : files + "," + file);
    }

    public void addArchive(Properties conf, String file) {
        if (file == null || file.length() == 0) {
            throw new IllegalArgumentException("file cannot be null or empty");
        }
        String files = conf.getProperty(ARCHIVES);
        conf.setProperty(ARCHIVES, files == null ? file : files + "," + file);
    }

    private class HttpJobSubmit
    extends OozieClient.ClientCallable<String> {
        private Properties conf;

        HttpJobSubmit(Properties conf, String jobType) {
            super(XOozieClient.this, "POST", "jobs", "", OozieClient.prepareParams("jobtype", jobType));
            this.conf = OozieClient.notNull(conf, "conf");
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            XOozieClient.this.writeToXml(this.conf, conn.getOutputStream());
            if (conn.getResponseCode() == 201) {
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                return (String)json.get((Object)"id");
            }
            if (conn.getResponseCode() != 200) {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }
}

