/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.authentication.client.PseudoAuthenticator;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.XOozieClient;

public class AuthOozieClient
extends XOozieClient {
    public static final String AUTHENTICATOR_CLASS_SYS_PROP = "authenticator.class";
    public static final String USE_AUTH_TOKEN_CACHE_SYS_PROP = "oozie.auth.token.cache";
    public static final File AUTH_TOKEN_CACHE_FILE = new File(System.getProperty("user.home"), ".oozie-auth-token");
    private String authOption = null;

    public AuthOozieClient(String oozieUrl) {
        this(oozieUrl, null);
    }

    public AuthOozieClient(String oozieUrl, String authOption) {
        super(oozieUrl);
        this.authOption = authOption;
    }

    @Override
    protected HttpURLConnection createConnection(URL url, String method) throws IOException, OozieClientException {
        HttpURLConnection conn;
        boolean useAuthFile = System.getProperty(USE_AUTH_TOKEN_CACHE_SYS_PROP, "false").equalsIgnoreCase("true");
        AuthenticatedURL.Token readToken = new AuthenticatedURL.Token();
        AuthenticatedURL.Token currentToken = new AuthenticatedURL.Token();
        if (useAuthFile && (readToken = this.readAuthToken()) != null) {
            currentToken = new AuthenticatedURL.Token(readToken.toString());
        }
        if (currentToken.isSet()) {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("OPTIONS");
            AuthenticatedURL.injectToken((HttpURLConnection)conn, (AuthenticatedURL.Token)currentToken);
            if (conn.getResponseCode() == 401) {
                AUTH_TOKEN_CACHE_FILE.delete();
                currentToken = new AuthenticatedURL.Token();
            }
        }
        if (!currentToken.isSet()) {
            Authenticator authenticator = this.getAuthenticator();
            try {
                new AuthenticatedURL(authenticator).openConnection(url, currentToken);
            }
            catch (AuthenticationException ex) {
                AUTH_TOKEN_CACHE_FILE.delete();
                throw new OozieClientException("AUTHENTICATION", "Could not authenticate, " + ex.getMessage(), ex);
            }
        }
        if (useAuthFile && !currentToken.equals((Object)readToken)) {
            this.writeAuthToken(currentToken);
        }
        conn = super.createConnection(url, method);
        AuthenticatedURL.injectToken((HttpURLConnection)conn, (AuthenticatedURL.Token)currentToken);
        return conn;
    }

    protected AuthenticatedURL.Token readAuthToken() {
        AuthenticatedURL.Token authToken = null;
        if (AUTH_TOKEN_CACHE_FILE.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(AUTH_TOKEN_CACHE_FILE));
                String line = reader.readLine();
                reader.close();
                if (line != null) {
                    authToken = new AuthenticatedURL.Token(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return authToken;
    }

    protected void writeAuthToken(AuthenticatedURL.Token authToken) {
        try {
            FileWriter writer = new FileWriter(AUTH_TOKEN_CACHE_FILE);
            writer.write(authToken.toString());
            ((Writer)writer).close();
            AUTH_TOKEN_CACHE_FILE.setReadable(false, false);
            AUTH_TOKEN_CACHE_FILE.setReadable(true, true);
            AUTH_TOKEN_CACHE_FILE.setWritable(true, true);
        }
        catch (IOException ioe) {
            AUTH_TOKEN_CACHE_FILE.delete();
        }
    }

    protected Authenticator getAuthenticator() throws OozieClientException {
        if (this.authOption != null) {
            try {
                Class<? extends Authenticator> authClass = this.getAuthenticators().get(this.authOption.toUpperCase());
                if (authClass == null) {
                    throw new OozieClientException("AUTHENTICATION", "Authenticator class not found [" + authClass + "]");
                }
                return authClass.newInstance();
            }
            catch (IllegalArgumentException iae) {
                throw new OozieClientException("AUTHENTICATION", "Invalid options provided for auth: " + this.authOption + ", (" + (Object)((Object)AuthType.KERBEROS) + " or " + (Object)((Object)AuthType.SIMPLE) + " expected.)");
            }
            catch (InstantiationException ex) {
                throw new OozieClientException("AUTHENTICATION", "Could not instantiate Authenticator for option [" + this.authOption + "], " + ex.getMessage(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new OozieClientException("AUTHENTICATION", "Could not instantiate Authenticator for option [" + this.authOption + "], " + ex.getMessage(), ex);
            }
        }
        String className = System.getProperty(AUTHENTICATOR_CLASS_SYS_PROP, KerberosAuthenticator.class.getName());
        if (className != null) {
            try {
                Class<?> klass;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = klass = cl != null ? cl.loadClass(className) : this.getClass().getClassLoader().loadClass(className);
                if (klass == null) {
                    throw new OozieClientException("AUTHENTICATION", "Authenticator class not found [" + className + "]");
                }
                return (Authenticator)klass.newInstance();
            }
            catch (Exception ex) {
                throw new OozieClientException("AUTHENTICATION", "Could not instantiate Authenticator [" + className + "], " + ex.getMessage(), ex);
            }
        }
        throw new OozieClientException("AUTHENTICATION", "Authenticator class not found [" + className + "]");
    }

    protected Map<String, Class<? extends Authenticator>> getAuthenticators() {
        HashMap<String, Class<? extends Authenticator>> authClasses = new HashMap<String, Class<? extends Authenticator>>();
        authClasses.put(AuthType.KERBEROS.toString(), KerberosAuthenticator.class);
        authClasses.put(AuthType.SIMPLE.toString(), PseudoAuthenticator.class);
        authClasses.put(null, KerberosAuthenticator.class);
        return authClasses;
    }

    public String getAuthOption() {
        return this.authOption;
    }

    public static enum AuthType {
        KERBEROS,
        SIMPLE;

    }
}

