/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import org.apache.maven.surefire.junitcore.LogicalStream;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ConsoleOutputReceiverForCurrentThread;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;

class TestMethod
implements ConsoleOutputReceiver {
    private final ReportEntry description;
    private final long startTime;
    private long endTime;
    private volatile ReportEntry testFailure;
    private volatile ReportEntry testError;
    private volatile ReportEntry ignored;
    private static final InheritableThreadLocal<TestMethod> TEST_METHOD = new InheritableThreadLocal();
    private volatile LogicalStream output;

    public TestMethod(ReportEntry description) {
        this.description = description;
        this.startTime = System.currentTimeMillis();
    }

    public void testFinished() {
        this.setEndTime();
    }

    public void testIgnored(ReportEntry description) {
        this.ignored = description;
        this.setEndTime();
    }

    public void testFailure(ReportEntry failure) {
        this.testFailure = failure;
        this.setEndTime();
    }

    public void testError(ReportEntry failure) {
        this.testError = failure;
        this.setEndTime();
    }

    private void setEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    public int getElapsed() {
        return (int)(this.endTime - this.startTime);
    }

    public void replay(RunListener reporter) {
        if (this.ignored != null) {
            reporter.testSkipped(this.createReportEntry());
            return;
        }
        reporter.testStarting(this.createReportEntry());
        if (this.output != null) {
            this.output.writeDetails((ConsoleOutputReceiver)reporter);
        }
        if (this.testFailure != null) {
            reporter.testFailed(this.testFailure);
        } else if (this.testError != null) {
            reporter.testError(this.testError);
        } else {
            reporter.testSucceeded(this.createReportEntry());
        }
    }

    private ReportEntry createReportEntry() {
        int elapsed = (int)(this.endTime - this.startTime);
        return new CategorizedReportEntry(this.description.getSourceName(), this.description.getName(), this.description.getGroup(), this.description.getStackTraceWriter(), Integer.valueOf(elapsed));
    }

    public void attachToThread() {
        TEST_METHOD.set(this);
        ConsoleOutputReceiverForCurrentThread.set((ConsoleOutputReceiver)this);
    }

    public static void detachFromCurrentThread() {
        TEST_METHOD.remove();
        ConsoleOutputReceiverForCurrentThread.remove();
    }

    public static TestMethod getThreadTestMethod() {
        return (TestMethod)TEST_METHOD.get();
    }

    public LogicalStream getLogicalStream(LogicalStream pastOutput) {
        if (this.output == null) {
            this.output = pastOutput == null ? new LogicalStream() : pastOutput;
        }
        return this.output;
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        this.getLogicalStream(null).write(stdout, buf, off, len);
    }
}

