/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.common.junit48.FilterFactory;
import org.apache.maven.surefire.common.junit48.JUnit48Reflector;
import org.apache.maven.surefire.junitcore.ConcurrentReporterManager;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.JUnitCoreRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreWrapper;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;

public class JUnitCoreProvider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final DirectoryScanner directoryScanner;
    private final JUnitCoreParameters jUnitCoreParameters;
    private final ScannerFilter scannerFilter;
    private final List<RunListener> customRunListeners;
    private final ProviderParameters providerParameters;
    private TestsToRun testsToRun;
    private JUnit48Reflector jUnit48Reflector;
    private RunOrderCalculator runOrderCalculator;
    private String requestedTestMethod;

    public JUnitCoreProvider(ProviderParameters providerParameters) {
        this.providerParameters = providerParameters;
        this.testClassLoader = providerParameters.getTestClassLoader();
        this.directoryScanner = providerParameters.getDirectoryScanner();
        this.runOrderCalculator = providerParameters.getRunOrderCalculator();
        this.jUnitCoreParameters = new JUnitCoreParameters(providerParameters.getProviderProperties());
        this.scannerFilter = new JUnit4TestChecker(this.testClassLoader);
        this.requestedTestMethod = providerParameters.getTestRequest().getRequestedTestMethod();
        this.customRunListeners = JUnit4RunListenerFactory.createCustomListeners(providerParameters.getProviderProperties().getProperty("listener"));
        this.jUnit48Reflector = new JUnit48Reflector(this.testClassLoader);
    }

    public Boolean isRunnable() {
        return Boolean.TRUE;
    }

    public Iterator getSuites() {
        Filter filter = this.jUnit48Reflector.isJUnit48Available() ? this.createJUnit48Filter() : null;
        this.testsToRun = this.getSuitesAsList(filter);
        return this.testsToRun.iterator();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        Filter filter;
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        ConsoleLogger consoleLogger = this.providerParameters.getConsoleLogger();
        Filter filter2 = filter = this.jUnit48Reflector.isJUnit48Available() ? this.createJUnit48Filter() : null;
        if (this.testsToRun == null) {
            TestsToRun testsToRun = this.testsToRun = forkTestSet == null ? this.getSuitesAsList(filter) : TestsToRun.fromClass((Class)((Class)forkTestSet));
        }
        if (this.testsToRun.size() == 0) {
            filter = null;
        }
        ConcurrentHashMap<String, TestSet> testSetMap = new ConcurrentHashMap<String, TestSet>();
        ConcurrentReporterManager listener = ConcurrentReporterManager.createInstance(testSetMap, reporterFactory, this.jUnitCoreParameters.isParallelClasses(), this.jUnitCoreParameters.isParallelBoth(), consoleLogger);
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)listener);
        JUnitCoreRunListener jUnit4RunListener = new JUnitCoreRunListener(listener, testSetMap);
        this.customRunListeners.add(0, jUnit4RunListener);
        JUnitCoreWrapper.execute(this.testsToRun, this.jUnitCoreParameters, this.customRunListeners, filter);
        return reporterFactory.close();
    }

    private TestsToRun getSuitesAsList(Filter filter) {
        ArrayList<Class> res = new ArrayList<Class>(500);
        TestsToRun max = this.scanClassPath();
        if (filter == null) {
            return max;
        }
        block0: for (Class clazz : max) {
            boolean isCategoryAnnotatedClass = this.jUnit48Reflector.isCategoryAnnotationPresent(clazz);
            Description d = Description.createSuiteDescription((Class)clazz);
            if (filter.shouldRun(d)) {
                res.add(clazz);
                continue;
            }
            for (Method method : clazz.getMethods()) {
                Description testDescription = Description.createTestDescription((Class)clazz, (String)method.getName(), (Annotation[])method.getAnnotations());
                if (!filter.shouldRun(testDescription)) continue;
                res.add(clazz);
                continue block0;
            }
        }
        return new TestsToRun(res);
    }

    private Filter createJUnit48Filter() {
        FilterFactory filterFactory = new FilterFactory(this.testClassLoader);
        return this.isMethodFilterSpecified() ? filterFactory.createMethodFilter(this.requestedTestMethod) : filterFactory.createGroupFilter(this.providerParameters.getProviderProperties());
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanned = this.directoryScanner.locateTestClasses(this.testClassLoader, this.scannerFilter);
        return this.runOrderCalculator.orderTestClasses(scanned);
    }

    private boolean isMethodFilterSpecified() {
        return !StringUtils.isBlank((String)this.requestedTestMethod);
    }
}

