/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.apache.maven.surefire.booter.ForkingRunListener;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.suite.RunResult;

public class ForkingReporterFactory
implements ReporterFactory {
    private final Boolean isTrimstackTrace;
    private final PrintStream originalSystemOut;
    private static volatile int testSetChannelId;

    public ForkingReporterFactory(Boolean trimstackTrace, PrintStream originalSystemOut) {
        this.isTrimstackTrace = trimstackTrace;
        this.originalSystemOut = originalSystemOut;
    }

    public synchronized RunListener createReporter() {
        return new ForkingRunListener(this.originalSystemOut, testSetChannelId++, this.isTrimstackTrace);
    }

    public RunResult close() {
        return new RunResult(17, 17, 17, 17);
    }

    public RunStatistics getGlobalRunStatistics() {
        return new RunStatistics();
    }

    static {
        RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
        String name = mx.getName();
        if (name.indexOf(64) < 0) {
            System.err.println("Can't get process pid, starting at 1");
            testSetChannelId = 1;
        } else {
            String pidString = name.substring(0, name.indexOf(64) - 1);
            testSetChannelId = Integer.parseInt(pidString);
            testSetChannelId *= 100;
            testSetChannelId = 1;
        }
    }
}

