/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.List;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;

public class MulticastingReporter
implements Reporter {
    private final Reporter[] target;
    private final int size;
    private volatile long lastStartAt;

    public MulticastingReporter(List target) {
        this.size = target.size();
        this.target = target.toArray(new Reporter[target.size()]);
    }

    public void testSetStarting(final ReportEntry report) {
        Exec e = new Exec(){

            public void f(Reporter r) {
                r.testSetStarting(report);
            }
        };
        e.exec();
    }

    public void testSetCompleted(final ReportEntry report) {
        Exec e = new Exec(){

            public void f(Reporter r) {
                r.testSetCompleted(report);
            }
        };
        e.exec();
    }

    public void testStarting(final ReportEntry report) {
        this.lastStartAt = System.currentTimeMillis();
        Exec e = new Exec(){

            public void f(Reporter r) {
                r.testStarting(report);
            }
        };
        e.exec();
    }

    public void testSucceeded(final ReportEntry report) {
        Exec e = new Exec(){
            ReportEntry wrapped;
            {
                this.wrapped = MulticastingReporter.this.wrap(report);
            }

            public void f(Reporter r) {
                r.testSucceeded(this.wrapped);
            }
        };
        e.exec();
    }

    public void testError(final ReportEntry report, final String stdOut, final String stdErr) {
        Exec e = new Exec(){
            ReportEntry wrapped;
            {
                this.wrapped = MulticastingReporter.this.wrap(report);
            }

            public void f(Reporter r) {
                r.testError(this.wrapped, stdOut, stdErr);
            }
        };
        e.exec();
    }

    public void testFailed(final ReportEntry report, final String stdOut, final String stdErr) {
        Exec e = new Exec(){
            ReportEntry wrapped;
            {
                this.wrapped = MulticastingReporter.this.wrap(report);
            }

            public void f(Reporter r) {
                r.testFailed(this.wrapped, stdOut, stdErr);
            }
        };
        e.exec();
    }

    public void testSkipped(final ReportEntry report) {
        Exec e = new Exec(){
            ReportEntry wrapped;
            {
                this.wrapped = MulticastingReporter.this.wrap(report);
            }

            public void f(Reporter r) {
                r.testSkipped(this.wrapped);
            }
        };
        e.exec();
    }

    private ReportEntry wrap(ReportEntry other) {
        if (other.getElapsed() != null) {
            return other;
        }
        return new CategorizedReportEntry(other.getSourceName(), other.getName(), other.getGroup(), other.getStackTraceWriter(), Integer.valueOf((int)(System.currentTimeMillis() - this.lastStartAt)));
    }

    public void writeMessage(final String message) {
        Exec e = new Exec(){

            public void f(Reporter r) {
                r.writeMessage(message);
            }
        };
        e.exec();
    }

    public void writeMessage(final byte[] b, final int off, final int len) {
        Exec e = new Exec(){

            public void f(Reporter r) {
                r.writeMessage(b, off, len);
            }
        };
        e.exec();
    }

    public void reset() {
        Exec e = new Exec(){

            public void f(Reporter r) {
                r.reset();
            }
        };
        e.exec();
    }

    abstract class Exec {
        Exec() {
        }

        public abstract void f(Reporter var1);

        public void exec() {
            RuntimeException possibleThrowable = null;
            for (int i = 0; i < MulticastingReporter.this.target.length; ++i) {
                try {
                    this.f(MulticastingReporter.this.target[i]);
                    continue;
                }
                catch (RuntimeException t) {
                    if (possibleThrowable != null) continue;
                    possibleThrowable = t;
                }
            }
            if (possibleThrowable != null) {
                throw possibleThrowable;
            }
        }
    }
}

