/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.AbstractTextReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;

public abstract class AbstractFileReporter
extends AbstractTextReporter {
    private final File reportsDirectory;
    private final boolean deleteOnStarting;
    private final String reportNameSuffix;

    AbstractFileReporter(boolean trimStackTrace, String format, File reportsDirectory) {
        this(trimStackTrace, format, reportsDirectory, null);
    }

    AbstractFileReporter(boolean trimStackTrace, String format, File reportsDirectory, String reportNameSuffix) {
        super(trimStackTrace, format);
        this.reportsDirectory = reportsDirectory;
        this.deleteOnStarting = false;
        this.reportNameSuffix = reportNameSuffix;
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        super.testSetStarting(report);
        File reportFile = AbstractFileReporter.getReportFile(this.reportsDirectory, report.getName(), this.reportNameSuffix, ".txt");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        if (this.deleteOnStarting && reportFile.exists()) {
            reportFile.delete();
        }
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(reportFile));
            writer.println("-------------------------------------------------------------------------------");
            writer.println("Test set: " + report.getName());
            writer.println("-------------------------------------------------------------------------------");
            this.setWriter(writer);
        }
        catch (IOException e) {
            throw new ReporterException("Unable to create file for report: " + e.getMessage(), (Exception)e);
        }
    }

    public static File getReportFile(File reportsDirectory, String reportEntryName, String reportNameSuffix, String fileExtension) {
        File reportFile = reportNameSuffix != null && reportNameSuffix.length() > 0 ? new File(reportsDirectory, reportEntryName + "-" + reportNameSuffix + fileExtension) : new File(reportsDirectory, reportEntryName + fileExtension);
        return reportFile;
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
        super.testSetCompleted(report);
        if (this.writer == null) {
            throw new NullPointerException(((Object)((Object)this)).hashCode() + "-" + ((Object)((Object)this)).getClass().getName() + ":testSetCompleted: writer is null for report " + report.getName() + " - this error should have not impact");
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
    }
}

