/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.surefire.CommonReflector;
import org.apache.maven.plugin.surefire.booterclient.BooterSerializer;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.output.ForkClient;
import org.apache.maven.plugin.surefire.booterclient.output.ThreadedStreamConsumer;
import org.apache.maven.plugin.surefire.report.FileReporterFactory;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.StartupReportConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.suite.RunResult;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ForkStarter {
    private final int forkedProcessTimeoutInSeconds;
    private final ProviderConfiguration providerConfiguration;
    private final StartupConfiguration startupConfiguration;
    private final ForkConfiguration forkConfiguration;
    private final StartupReportConfiguration startupReportConfiguration;
    private final FileReporterFactory fileReporterFactory;
    private static volatile int systemPropertiesFileCounter = 0;
    private static final Object lock = new Object();

    public ForkStarter(ProviderConfiguration providerConfiguration, StartupConfiguration startupConfiguration, ForkConfiguration forkConfiguration, int forkedProcessTimeoutInSeconds, StartupReportConfiguration startupReportConfiguration) {
        this.forkConfiguration = forkConfiguration;
        this.providerConfiguration = providerConfiguration;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.startupConfiguration = startupConfiguration;
        this.startupReportConfiguration = startupReportConfiguration;
        this.fileReporterFactory = new FileReporterFactory(startupReportConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult run() throws SurefireBooterForkException, SurefireExecutionException {
        RunResult result;
        block6: {
            String requestedForkMode = this.forkConfiguration.getForkMode();
            try {
                if ("once".equals(requestedForkMode)) {
                    result = this.fork(null, this.providerConfiguration.getProviderProperties(), new ForkClient(this.fileReporterFactory, this.startupReportConfiguration.getTestVmSystemProperties()), this.fileReporterFactory.getGlobalRunStatistics());
                    break block6;
                }
                if ("always".equals(requestedForkMode)) {
                    result = this.runSuitesForkPerTestSet(this.providerConfiguration.getProviderProperties(), 1);
                    break block6;
                }
                if ("perThread".equals(requestedForkMode)) {
                    result = this.runSuitesForkPerTestSet(this.providerConfiguration.getProviderProperties(), this.forkConfiguration.getThreadCount());
                    break block6;
                }
                throw new SurefireExecutionException("Unknown forkmode: " + requestedForkMode, null);
            }
            finally {
                this.fileReporterFactory.close();
            }
        }
        return result;
    }

    private RunResult runSuitesForkPerTestSet(Properties properties, int forkCount) throws SurefireBooterForkException {
        ArrayList results = new ArrayList(500);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(forkCount, forkCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(500));
        RunResult globalResult = new RunResult(0, 0, 0, 0);
        Iterator suites = this.getSuitesIterator();
        while (suites.hasNext()) {
            Object testSet = suites.next();
            ParallelFork parallelFork = new ParallelFork(this, testSet, properties, new ForkClient(this.fileReporterFactory, this.startupReportConfiguration.getTestVmSystemProperties()), this.fileReporterFactory.getGlobalRunStatistics());
            results.add(executorService.submit(parallelFork));
        }
        for (Future future : results) {
            try {
                RunResult cur = (RunResult)future.get();
                if (cur != null) {
                    globalResult = globalResult.aggregate(cur);
                    continue;
                }
                System.err.println("No results for " + future.toString());
            }
            catch (InterruptedException e) {
                throw new SurefireBooterForkException("Interrupted", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SurefireBooterForkException("ExecutionException", (Throwable)e);
            }
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            throw new SurefireBooterForkException("Interrupted", (Throwable)e);
        }
        return globalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult fork(Object testSet, Properties properties, ForkClient forkClient, RunStatistics globalRunStatistics) throws SurefireBooterForkException {
        File surefireProperties;
        File systemProperties = null;
        try {
            Object object = lock;
            synchronized (object) {
                BooterSerializer booterSerializer = new BooterSerializer(this.forkConfiguration, properties);
                surefireProperties = booterSerializer.serialize(this.providerConfiguration, this.startupConfiguration, testSet, this.forkConfiguration.getForkMode());
                if (this.forkConfiguration.getSystemProperties() != null) {
                    systemProperties = SystemPropertyManager.writePropertiesFile((Properties)this.forkConfiguration.getSystemProperties(), (File)this.forkConfiguration.getTempDirectory(), (String)("surefire_" + systemPropertiesFileCounter++), (boolean)this.forkConfiguration.isDebug());
                }
            }
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating properties files for forking", (Throwable)e);
        }
        Classpath bootClasspathConfiguration = this.forkConfiguration.getBootClasspath();
        Classpath additionlClassPathUrls = this.startupConfiguration.useSystemClassLoader() ? this.startupConfiguration.getClasspathConfiguration().getTestClasspath() : null;
        Classpath bootClasspath = Classpath.join((Classpath)bootClasspathConfiguration, (Classpath)additionlClassPathUrls);
        Commandline cli = this.forkConfiguration.createCommandLine(bootClasspath.getClassPath(), this.startupConfiguration.getClassLoaderConfiguration(), this.startupConfiguration.isShadefire());
        cli.createArg().setFile(surefireProperties);
        if (systemProperties != null) {
            cli.createArg().setFile(systemProperties);
        }
        ThreadedStreamConsumer threadedStreamConsumer = new ThreadedStreamConsumer(forkClient);
        if (this.forkConfiguration.isDebug()) {
            System.out.println("Forking command line: " + cli);
        }
        try {
            int timeout = this.forkedProcessTimeoutInSeconds > 0 ? this.forkedProcessTimeoutInSeconds : 0;
            int result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)threadedStreamConsumer, (StreamConsumer)threadedStreamConsumer, (int)timeout);
            if (result != 0) {
                throw new SurefireBooterForkException("Error occurred in starting fork, check output in log");
            }
        }
        catch (CommandLineTimeOutException e) {
            RunResult runResult = RunResult.Timeout;
            return runResult;
        }
        catch (CommandLineException e) {
            throw new SurefireBooterForkException("Error while executing forked tests.", e.getCause());
        }
        finally {
            threadedStreamConsumer.close();
            forkClient.close();
        }
        RunResult runResult = globalRunStatistics.getRunResult();
        return runResult;
    }

    private Iterator getSuitesIterator() throws SurefireBooterForkException {
        try {
            ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
            ClassLoader testsClassLoader = classpathConfiguration.createTestClassLoader(false);
            ClassLoader surefireClassLoader = classpathConfiguration.createInprocSurefireClassLoader(testsClassLoader);
            CommonReflector commonReflector = new CommonReflector(surefireClassLoader);
            Object reporterFactory = commonReflector.createReportingReporterFactory(this.startupReportConfiguration);
            ProviderFactory providerFactory = new ProviderFactory(this.startupConfiguration, this.providerConfiguration, surefireClassLoader, testsClassLoader, reporterFactory);
            SurefireProvider surefireProvider = providerFactory.createProvider(false);
            return surefireProvider.getSuites();
        }
        catch (SurefireExecutionException e) {
            throw new SurefireBooterForkException("Unable to create classloader to find test suites", (Throwable)e);
        }
    }

    static class ParallelFork
    implements Callable {
        ForkStarter f;
        Object testSet;
        Properties properties;
        ForkClient forkClient;
        RunStatistics globalRunStatistics;

        public ParallelFork(ForkStarter f, Object testSet, Properties properties, ForkClient forkClient, RunStatistics globalRunStatistics) {
            this.f = f;
            this.testSet = testSet;
            this.properties = properties;
            this.forkClient = forkClient;
            this.globalRunStatistics = globalRunStatistics;
        }

        public RunResult call() {
            try {
                return this.f.fork(this.testSet, this.properties, this.forkClient, this.globalRunStatistics);
            }
            catch (SurefireBooterForkException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

