/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.Schedulable;

class SchedulingAlgorithms {
    public static final Log LOG = LogFactory.getLog((String)SchedulingAlgorithms.class.getName());
    private static final int COMPUTE_FAIR_SHARES_ITERATIONS = 25;

    SchedulingAlgorithms() {
    }

    public static void computeFairShares(Collection<? extends Schedulable> schedulables, double totalSlots) {
        double totalDemand = 0.0;
        for (Schedulable schedulable : schedulables) {
            totalDemand += (double)schedulable.getDemand();
        }
        double cap = Math.min(totalDemand, totalSlots);
        double rMax = 1.0;
        while (SchedulingAlgorithms.slotsUsedWithWeightToSlotRatio(rMax, schedulables) < cap) {
            rMax *= 2.0;
        }
        double left = 0.0;
        double right = rMax;
        for (int i = 0; i < 25; ++i) {
            double d = (left + right) / 2.0;
            if (SchedulingAlgorithms.slotsUsedWithWeightToSlotRatio(d, schedulables) < cap) {
                left = d;
                continue;
            }
            right = d;
        }
        for (Schedulable schedulable : schedulables) {
            schedulable.setFairShare(SchedulingAlgorithms.computeShare(schedulable, right));
        }
    }

    private static double slotsUsedWithWeightToSlotRatio(double w2sRatio, Collection<? extends Schedulable> schedulables) {
        double slotsTaken = 0.0;
        for (Schedulable schedulable : schedulables) {
            double share = SchedulingAlgorithms.computeShare(schedulable, w2sRatio);
            slotsTaken += share;
        }
        return slotsTaken;
    }

    private static double computeShare(Schedulable sched, double w2sRatio) {
        double share = sched.getWeight() * w2sRatio;
        share = Math.max(share, (double)sched.getMinShare());
        share = Math.min(share, (double)sched.getDemand());
        return share;
    }

    public static class FairShareComparator
    implements Comparator<Schedulable> {
        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            int minShare1 = Math.min(s1.getMinShare(), s1.getDemand());
            int minShare2 = Math.min(s2.getMinShare(), s2.getDemand());
            boolean s1Needy = s1.getRunningTasks() < minShare1;
            boolean s2Needy = s2.getRunningTasks() < minShare2;
            double minShareRatio1 = (double)s1.getRunningTasks() / Math.max((double)minShare1, 1.0);
            double minShareRatio2 = (double)s2.getRunningTasks() / Math.max((double)minShare2, 1.0);
            double tasksToWeightRatio1 = (double)s1.getRunningTasks() / s1.getWeight();
            double tasksToWeightRatio2 = (double)s2.getRunningTasks() / s2.getWeight();
            int res = 0;
            res = s1Needy && !s2Needy ? -1 : (s2Needy && !s1Needy ? 1 : (s1Needy && s2Needy ? (int)Math.signum(minShareRatio1 - minShareRatio2) : (int)Math.signum(tasksToWeightRatio1 - tasksToWeightRatio2)));
            if (res == 0 && (res = (int)Math.signum(s1.getStartTime() - s2.getStartTime())) == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }
    }

    public static class FifoComparator
    implements Comparator<Schedulable> {
        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            int res = s1.getPriority().compareTo((Enum)s2.getPriority());
            if (res == 0) {
                res = (int)Math.signum(s1.getStartTime() - s2.getStartTime());
            }
            if (res == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }
    }
}

