/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.FairScheduler;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobSchedulable;
import org.apache.hadoop.mapred.Pool;
import org.apache.hadoop.mapred.PoolManager;
import org.apache.hadoop.mapred.Schedulable;
import org.apache.hadoop.mapred.SchedulingAlgorithms;
import org.apache.hadoop.mapred.SchedulingMode;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.TaskType;

public class PoolSchedulable
extends Schedulable {
    public static final Log LOG = LogFactory.getLog((String)PoolSchedulable.class.getName());
    private FairScheduler scheduler;
    private Pool pool;
    private TaskType taskType;
    private PoolManager poolMgr;
    private List<JobSchedulable> jobScheds = new LinkedList<JobSchedulable>();
    private int demand = 0;
    long lastTimeAtMinShare;
    long lastTimeAtHalfFairShare;

    public PoolSchedulable(FairScheduler scheduler, Pool pool, TaskType type) {
        long currentTime;
        this.scheduler = scheduler;
        this.pool = pool;
        this.taskType = type;
        this.poolMgr = scheduler.getPoolManager();
        this.lastTimeAtMinShare = currentTime = scheduler.getClock().getTime();
        this.lastTimeAtHalfFairShare = currentTime;
        this.initMetrics();
    }

    public void addJob(JobInProgress job) {
        FairScheduler.JobInfo info = this.scheduler.getJobInfo(job);
        this.jobScheds.add(this.taskType == TaskType.MAP ? info.mapSchedulable : info.reduceSchedulable);
    }

    public void removeJob(JobInProgress job) {
        Iterator<JobSchedulable> it = this.jobScheds.iterator();
        while (it.hasNext()) {
            JobSchedulable jobSched = it.next();
            if (jobSched.getJob() != job) continue;
            it.remove();
            break;
        }
    }

    @Override
    public void updateDemand() {
        this.demand = 0;
        for (JobSchedulable sched : this.jobScheds) {
            sched.updateDemand();
            this.demand += sched.getDemand();
        }
        int maxTasks = this.poolMgr.getMaxSlots(this.pool.getName(), this.taskType);
        if (this.demand > maxTasks) {
            this.demand = maxTasks;
        }
    }

    @Override
    public void redistributeShare() {
        if (this.pool.getSchedulingMode() == SchedulingMode.FAIR) {
            SchedulingAlgorithms.computeFairShares(this.jobScheds, this.getFairShare());
        } else {
            for (JobSchedulable sched : this.jobScheds) {
                sched.setFairShare(0.0);
            }
        }
    }

    @Override
    public int getDemand() {
        return this.demand;
    }

    @Override
    public int getMinShare() {
        return this.poolMgr.getAllocation(this.pool.getName(), this.taskType);
    }

    @Override
    public double getWeight() {
        return this.poolMgr.getPoolWeight(this.pool.getName());
    }

    @Override
    public JobPriority getPriority() {
        return JobPriority.NORMAL;
    }

    @Override
    public int getRunningTasks() {
        int ans = 0;
        for (JobSchedulable sched : this.jobScheds) {
            ans += sched.getRunningTasks();
        }
        return ans;
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    @Override
    public Task assignTask(TaskTrackerStatus tts, long currentTime, Collection<JobInProgress> visited) throws IOException {
        Comparator<Schedulable> comparator;
        int runningTasks = this.getRunningTasks();
        if (runningTasks >= this.poolMgr.getMaxSlots(this.pool.getName(), this.taskType)) {
            return null;
        }
        SchedulingMode mode = this.pool.getSchedulingMode();
        if (mode == SchedulingMode.FIFO) {
            comparator = new SchedulingAlgorithms.FifoComparator();
        } else if (mode == SchedulingMode.FAIR) {
            comparator = new SchedulingAlgorithms.FairShareComparator();
        } else {
            throw new RuntimeException("Unsupported pool scheduling mode " + (Object)((Object)mode));
        }
        Collections.sort(this.jobScheds, comparator);
        for (JobSchedulable sched : this.jobScheds) {
            Task task = sched.assignTask(tts, currentTime, visited);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.pool.getName();
    }

    Pool getPool() {
        return this.pool;
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }

    public Collection<JobSchedulable> getJobSchedulables() {
        return this.jobScheds;
    }

    public long getLastTimeAtMinShare() {
        return this.lastTimeAtMinShare;
    }

    public void setLastTimeAtMinShare(long lastTimeAtMinShare) {
        this.lastTimeAtMinShare = lastTimeAtMinShare;
    }

    public long getLastTimeAtHalfFairShare() {
        return this.lastTimeAtHalfFairShare;
    }

    public void setLastTimeAtHalfFairShare(long lastTimeAtHalfFairShare) {
        this.lastTimeAtHalfFairShare = lastTimeAtHalfFairShare;
    }

    @Override
    protected String getMetricsContextName() {
        return "pools";
    }

    @Override
    public void updateMetrics() {
        super.setMetricValues(this.metrics);
        if (this.scheduler.isPreemptionEnabled()) {
            long lastCheck = this.scheduler.getLastPreemptionUpdateTime();
            this.metrics.setMetric("millisSinceAtMinShare", lastCheck - this.lastTimeAtMinShare);
            this.metrics.setMetric("millisSinceAtHalfFairShare", lastCheck - this.lastTimeAtHalfFairShare);
        }
        this.metrics.update();
        for (JobSchedulable job : this.jobScheds) {
            job.updateMetrics();
        }
    }
}

