/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.AllocationConfigurationException;
import org.apache.hadoop.mapred.FairScheduler;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.Pool;
import org.apache.hadoop.mapred.SchedulingMode;
import org.apache.hadoop.mapreduce.TaskType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class PoolManager {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.PoolManager");
    public static final long ALLOC_RELOAD_INTERVAL = 10000L;
    public static final long ALLOC_RELOAD_WAIT = 5000L;
    public static final String EXPLICIT_POOL_PROPERTY = "mapred.fairscheduler.pool";
    private final FairScheduler scheduler;
    private Map<String, Integer> mapAllocs = new HashMap<String, Integer>();
    private Map<String, Integer> reduceAllocs = new HashMap<String, Integer>();
    private Map<String, Integer> poolMaxMaps = new HashMap<String, Integer>();
    private Map<String, Integer> poolMaxReduces = new HashMap<String, Integer>();
    private Map<String, Double> poolWeights = new HashMap<String, Double>();
    private Map<String, Integer> poolMaxJobs = new HashMap<String, Integer>();
    private Map<String, Integer> userMaxJobs = new HashMap<String, Integer>();
    private int userMaxJobsDefault = Integer.MAX_VALUE;
    private int poolMaxJobsDefault = Integer.MAX_VALUE;
    private Map<String, Long> minSharePreemptionTimeouts = new HashMap<String, Long>();
    private long defaultMinSharePreemptionTimeout = Long.MAX_VALUE;
    private long fairSharePreemptionTimeout = Long.MAX_VALUE;
    SchedulingMode defaultSchedulingMode = SchedulingMode.FAIR;
    private String allocFile;
    private String poolNameProperty;
    private Map<String, Pool> pools = new HashMap<String, Pool>();
    private long lastReloadAttempt;
    private long lastSuccessfulReload;
    private boolean lastReloadAttemptFailed = false;

    public PoolManager(FairScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void initialize() throws IOException, SAXException, AllocationConfigurationException, ParserConfigurationException {
        Configuration conf = this.scheduler.getConf();
        this.poolNameProperty = conf.get("mapred.fairscheduler.poolnameproperty", "user.name");
        this.allocFile = conf.get("mapred.fairscheduler.allocation.file");
        if (this.allocFile == null) {
            String hadoopHome = System.getenv("HADOOP_HOME");
            if (hadoopHome == null && (hadoopHome = System.getenv("MAPR_HOME")) != null) {
                hadoopHome = hadoopHome + "/hadoop/hadoop-0.20.2/";
            }
            if (hadoopHome != null) {
                this.allocFile = hadoopHome + "/conf/pools.xml";
                LOG.info((Object)("Using default location " + this.allocFile + " for fair scheduler pool configuration."));
            } else {
                this.allocFile = null;
                LOG.warn((Object)"No mapred.fairscheduler.allocation.file given in jobconf - the fair scheduler will not use any queues.");
            }
        }
        this.reloadAllocs();
        this.lastSuccessfulReload = System.currentTimeMillis();
        this.lastReloadAttempt = System.currentTimeMillis();
        this.getPool("default");
    }

    public synchronized Pool getPool(String name) {
        Pool pool = this.pools.get(name);
        if (pool == null) {
            pool = new Pool(this.scheduler, name);
            pool.setSchedulingMode(this.defaultSchedulingMode);
            this.pools.put(name, pool);
        }
        return pool;
    }

    public Pool getPool(JobInProgress job) {
        return this.getPool(this.getPoolName(job));
    }

    public void reloadAllocsIfNecessary() {
        long time = System.currentTimeMillis();
        if (time > this.lastReloadAttempt + 10000L) {
            this.lastReloadAttempt = time;
            try {
                File file = new File(this.allocFile);
                long lastModified = file.lastModified();
                if (lastModified > this.lastSuccessfulReload && time > lastModified + 5000L) {
                    this.reloadAllocs();
                    this.lastSuccessfulReload = time;
                    this.lastReloadAttemptFailed = false;
                }
            }
            catch (Exception e) {
                if (!this.lastReloadAttemptFailed) {
                    LOG.error((Object)"Failed to reload fair scheduler config file - will use existing allocations.", (Throwable)e);
                }
                this.lastReloadAttemptFailed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAllocs() throws IOException, ParserConfigurationException, SAXException, AllocationConfigurationException {
        if (this.allocFile == null) {
            return;
        }
        HashMap<String, Integer> mapAllocs = new HashMap<String, Integer>();
        HashMap<String, Integer> reduceAllocs = new HashMap<String, Integer>();
        HashMap<String, Integer> poolMaxJobs = new HashMap<String, Integer>();
        HashMap<String, Integer> userMaxJobs = new HashMap<String, Integer>();
        HashMap<String, Integer> poolMaxMaps = new HashMap<String, Integer>();
        HashMap<String, Integer> poolMaxReduces = new HashMap<String, Integer>();
        HashMap<String, Double> poolWeights = new HashMap<String, Double>();
        HashMap<String, SchedulingMode> poolModes = new HashMap<String, SchedulingMode>();
        HashMap<String, Long> minSharePreemptionTimeouts = new HashMap<String, Long>();
        int userMaxJobsDefault = Integer.MAX_VALUE;
        int poolMaxJobsDefault = Integer.MAX_VALUE;
        ArrayList<String> poolNamesInAllocFile = new ArrayList<String>();
        long fairSharePreemptionTimeout = Long.MAX_VALUE;
        long defaultMinSharePreemptionTimeout = Long.MAX_VALUE;
        SchedulingMode defaultSchedulingMode = SchedulingMode.FAIR;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(new File(this.allocFile));
        Element root = doc.getDocumentElement();
        if (!"allocations".equals(root.getTagName())) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: top-level element not <allocations>");
        }
        NodeList elements = root.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            String text;
            String text2;
            Element field;
            Node fieldNode;
            int j;
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if ("pool".equals(element.getTagName())) {
                String poolName = element.getAttribute("name");
                poolNamesInAllocFile.add(poolName);
                NodeList fields = element.getChildNodes();
                for (j = 0; j < fields.getLength(); ++j) {
                    fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    field = (Element)fieldNode;
                    if ("minMaps".equals(field.getTagName())) {
                        text2 = ((Text)field.getFirstChild()).getData().trim();
                        int val = Integer.parseInt(text2);
                        mapAllocs.put(poolName, val);
                        continue;
                    }
                    if ("minReduces".equals(field.getTagName())) {
                        text2 = ((Text)field.getFirstChild()).getData().trim();
                        int val = Integer.parseInt(text2);
                        reduceAllocs.put(poolName, val);
                        continue;
                    }
                    if ("maxMaps".equals(field.getTagName())) {
                        text2 = ((Text)field.getFirstChild()).getData().trim();
                        int val = Integer.parseInt(text2);
                        poolMaxMaps.put(poolName, val);
                        continue;
                    }
                    if ("maxReduces".equals(field.getTagName())) {
                        text2 = ((Text)field.getFirstChild()).getData().trim();
                        int val = Integer.parseInt(text2);
                        poolMaxReduces.put(poolName, val);
                        continue;
                    }
                    if ("maxRunningJobs".equals(field.getTagName())) {
                        text2 = ((Text)field.getFirstChild()).getData().trim();
                        int val = Integer.parseInt(text2);
                        poolMaxJobs.put(poolName, val);
                        continue;
                    }
                    if ("weight".equals(field.getTagName())) {
                        text2 = ((Text)field.getFirstChild()).getData().trim();
                        double val = Double.parseDouble(text2);
                        poolWeights.put(poolName, val);
                        continue;
                    }
                    if ("minSharePreemptionTimeout".equals(field.getTagName())) {
                        text2 = ((Text)field.getFirstChild()).getData().trim();
                        long val = Long.parseLong(text2) * 1000L;
                        minSharePreemptionTimeouts.put(poolName, val);
                        continue;
                    }
                    if (!"schedulingMode".equals(field.getTagName())) continue;
                    text2 = ((Text)field.getFirstChild()).getData().trim();
                    poolModes.put(poolName, this.parseSchedulingMode(text2));
                }
                if (poolMaxMaps.containsKey(poolName) && mapAllocs.containsKey(poolName) && (Integer)poolMaxMaps.get(poolName) < (Integer)mapAllocs.get(poolName)) {
                    LOG.warn((Object)String.format("Pool %s has max maps %d less than min maps %d", poolName, poolMaxMaps.get(poolName), mapAllocs.get(poolName)));
                }
                if (!poolMaxReduces.containsKey(poolName) || !reduceAllocs.containsKey(poolName) || (Integer)poolMaxReduces.get(poolName) >= (Integer)reduceAllocs.get(poolName)) continue;
                LOG.warn((Object)String.format("Pool %s has max reduces %d less than min reduces %d", poolName, poolMaxReduces.get(poolName), reduceAllocs.get(poolName)));
                continue;
            }
            if ("user".equals(element.getTagName())) {
                String userName = element.getAttribute("name");
                NodeList fields = element.getChildNodes();
                for (j = 0; j < fields.getLength(); ++j) {
                    fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element) || !"maxRunningJobs".equals((field = (Element)fieldNode).getTagName())) continue;
                    text2 = ((Text)field.getFirstChild()).getData().trim();
                    int val = Integer.parseInt(text2);
                    userMaxJobs.put(userName, val);
                }
                continue;
            }
            if ("userMaxJobsDefault".equals(element.getTagName())) {
                int val;
                text = ((Text)element.getFirstChild()).getData().trim();
                userMaxJobsDefault = val = Integer.parseInt(text);
                continue;
            }
            if ("poolMaxJobsDefault".equals(element.getTagName())) {
                int val;
                text = ((Text)element.getFirstChild()).getData().trim();
                poolMaxJobsDefault = val = Integer.parseInt(text);
                continue;
            }
            if ("fairSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                text = ((Text)element.getFirstChild()).getData().trim();
                fairSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("defaultMinSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultMinSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("defaultPoolSchedulingMode".equals(element.getTagName())) {
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultSchedulingMode = this.parseSchedulingMode(text);
                continue;
            }
            LOG.warn((Object)("Bad element in allocations file: " + element.getTagName()));
        }
        PoolManager poolManager = this;
        synchronized (poolManager) {
            this.mapAllocs = mapAllocs;
            this.reduceAllocs = reduceAllocs;
            this.poolMaxMaps = poolMaxMaps;
            this.poolMaxReduces = poolMaxReduces;
            this.poolMaxJobs = poolMaxJobs;
            this.userMaxJobs = userMaxJobs;
            this.userMaxJobsDefault = userMaxJobsDefault;
            this.poolMaxJobsDefault = poolMaxJobsDefault;
            this.poolWeights = poolWeights;
            this.minSharePreemptionTimeouts = minSharePreemptionTimeouts;
            this.fairSharePreemptionTimeout = fairSharePreemptionTimeout;
            this.defaultMinSharePreemptionTimeout = defaultMinSharePreemptionTimeout;
            this.defaultSchedulingMode = defaultSchedulingMode;
            for (String name : poolNamesInAllocFile) {
                Pool pool = this.getPool(name);
                if (poolModes.containsKey(name)) {
                    pool.setSchedulingMode((SchedulingMode)((Object)poolModes.get(name)));
                    continue;
                }
                pool.setSchedulingMode(defaultSchedulingMode);
            }
        }
    }

    boolean invertedMinMax(TaskType type, String pool) {
        Map<String, Integer> min;
        Map<String, Integer> max = TaskType.MAP == type ? this.poolMaxMaps : this.poolMaxReduces;
        Map<String, Integer> map = min = TaskType.MAP == type ? this.mapAllocs : this.reduceAllocs;
        return max.containsKey(pool) && min.containsKey(pool) && max.get(pool) < min.get(pool);
    }

    private SchedulingMode parseSchedulingMode(String text) throws AllocationConfigurationException {
        if ((text = text.toLowerCase()).equals("fair")) {
            return SchedulingMode.FAIR;
        }
        if (text.equals("fifo")) {
            return SchedulingMode.FIFO;
        }
        throw new AllocationConfigurationException("Unknown scheduling mode : " + text + "; expected 'fifo' or 'fair'");
    }

    public int getAllocation(String pool, TaskType taskType) {
        Map<String, Integer> allocationMap = taskType == TaskType.MAP ? this.mapAllocs : this.reduceAllocs;
        Integer alloc = allocationMap.get(pool);
        return alloc == null ? 0 : alloc;
    }

    int getMaxSlots(String poolName, TaskType taskType) {
        Map<String, Integer> maxMap;
        Map<String, Integer> map = maxMap = taskType == TaskType.MAP ? this.poolMaxMaps : this.poolMaxReduces;
        if (maxMap.containsKey(poolName)) {
            return maxMap.get(poolName);
        }
        return Integer.MAX_VALUE;
    }

    public synchronized void addJob(JobInProgress job) {
        if (this.scheduler.isSmallJob(job)) {
            LOG.info((Object)("Adding small job on express lane " + job.getJobID()));
            this.getPool("ExpressLane").addJob(job);
        } else {
            this.getPool(this.getPoolName(job)).addJob(job);
        }
    }

    public synchronized void removeJob(JobInProgress job) {
        this.getPool("ExpressLane").removeJob(job);
        this.getPool(this.getPoolName(job)).removeJob(job);
    }

    public synchronized void setPool(JobInProgress job, String pool) {
        if (!"ExpressLane".equals(pool)) {
            Pool newPool = this.getPool(pool);
            if (newPool != null) {
                this.removeJob(job);
                job.getJobConf().set(EXPLICIT_POOL_PROPERTY, pool);
                newPool.addJob(job);
            }
        } else {
            LOG.info((Object)("Failed to move job " + job.getJobID() + " to " + "ExpressLane" + ". Operation not allowed"));
        }
    }

    public synchronized Collection<Pool> getPools() {
        return this.pools.values();
    }

    public String getPoolName(JobInProgress job) {
        JobConf conf = job.getJobConf();
        return conf.get(EXPLICIT_POOL_PROPERTY, conf.get(this.poolNameProperty, "default")).trim();
    }

    public synchronized Collection<String> getPoolNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Pool pool : this.getPools()) {
            list.add(pool.getName());
        }
        Collections.sort(list);
        return list;
    }

    public int getUserMaxJobs(String user) {
        if (this.userMaxJobs.containsKey(user)) {
            return this.userMaxJobs.get(user);
        }
        return this.userMaxJobsDefault;
    }

    public int getPoolMaxJobs(String pool) {
        if (this.poolMaxJobs.containsKey(pool)) {
            return this.poolMaxJobs.get(pool);
        }
        return this.poolMaxJobsDefault;
    }

    public double getPoolWeight(String pool) {
        if (this.poolWeights.containsKey(pool)) {
            return this.poolWeights.get(pool);
        }
        return 1.0;
    }

    public long getMinSharePreemptionTimeout(String pool) {
        if (this.minSharePreemptionTimeouts.containsKey(pool)) {
            return this.minSharePreemptionTimeouts.get(pool);
        }
        return this.defaultMinSharePreemptionTimeout;
    }

    public long getFairSharePreemptionTimeout() {
        return this.fairSharePreemptionTimeout;
    }

    synchronized void updateMetrics() {
        for (Pool pool : this.pools.values()) {
            pool.updateMetrics();
        }
    }
}

