/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.mapred.FairScheduler;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.PoolSchedulable;
import org.apache.hadoop.mapred.SchedulingMode;
import org.apache.hadoop.mapreduce.TaskType;

public class Pool {
    public static final String DEFAULT_POOL_NAME = "default";
    public static final String SMALLJOBS_POOL_NAME = "ExpressLane";
    private String name;
    private Collection<JobInProgress> jobs = new ArrayList<JobInProgress>();
    private SchedulingMode schedulingMode;
    private PoolSchedulable mapSchedulable;
    private PoolSchedulable reduceSchedulable;

    public Pool(FairScheduler scheduler, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Passed pool name was null.");
        }
        this.name = name;
        this.mapSchedulable = new PoolSchedulable(scheduler, this, TaskType.MAP);
        this.reduceSchedulable = new PoolSchedulable(scheduler, this, TaskType.REDUCE);
    }

    public Collection<JobInProgress> getJobs() {
        return this.jobs;
    }

    public void addJob(JobInProgress job) {
        if (!this.jobs.contains(job)) {
            this.jobs.add(job);
            this.mapSchedulable.addJob(job);
            this.reduceSchedulable.addJob(job);
        }
    }

    public void removeJob(JobInProgress job) {
        if (this.jobs.contains(job)) {
            this.jobs.remove(job);
            this.mapSchedulable.removeJob(job);
            this.reduceSchedulable.removeJob(job);
        }
    }

    public String getName() {
        return this.name;
    }

    public SchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    public void setSchedulingMode(SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    public boolean isDefaultPool() {
        return DEFAULT_POOL_NAME.equals(this.name);
    }

    public PoolSchedulable getMapSchedulable() {
        return this.mapSchedulable;
    }

    public PoolSchedulable getReduceSchedulable() {
        return this.reduceSchedulable;
    }

    public PoolSchedulable getSchedulable(TaskType type) {
        return type == TaskType.MAP ? this.mapSchedulable : this.reduceSchedulable;
    }

    public void updateMetrics() {
        this.mapSchedulable.updateMetrics();
        this.reduceSchedulable.updateMetrics();
    }
}

