/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskSelector;
import org.apache.hadoop.mapred.TaskTrackerStatus;

public class DefaultTaskSelector
extends TaskSelector {
    @Override
    public int neededSpeculativeMaps(JobInProgress job) {
        int count = 0;
        long time = System.currentTimeMillis();
        double avgProgress = job.getStatus().mapProgress();
        for (TaskInProgress tip : job.maps) {
            if (!tip.isRunning() || !tip.hasSpeculativeTask(time, avgProgress)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int neededSpeculativeReduces(JobInProgress job) {
        int count = 0;
        long time = System.currentTimeMillis();
        double avgProgress = job.getStatus().reduceProgress();
        for (TaskInProgress tip : job.reduces) {
            if (!tip.isRunning() || !tip.hasSpeculativeTask(time, avgProgress)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Task obtainNewMapTask(TaskTrackerStatus taskTracker, JobInProgress job, int localityLevel) throws IOException {
        ClusterStatus clusterStatus = this.taskTrackerManager.getClusterStatus();
        int numTaskTrackers = clusterStatus.getTaskTrackers();
        return job.obtainNewMapTask(taskTracker, numTaskTrackers, this.taskTrackerManager.getNumberOfUniqueHosts(), localityLevel);
    }

    @Override
    public Task obtainNewReduceTask(TaskTrackerStatus taskTracker, JobInProgress job) throws IOException {
        ClusterStatus clusterStatus = this.taskTrackerManager.getClusterStatus();
        int numTaskTrackers = clusterStatus.getTaskTrackers();
        return job.obtainNewReduceTask(taskTracker, numTaskTrackers, this.taskTrackerManager.getNumberOfUniqueHosts());
    }
}

