/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.mapred.CapBasedLoadManager;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.DefaultTaskSelector;
import org.apache.hadoop.mapred.EagerTaskInitializationListener;
import org.apache.hadoop.mapred.FairSchedulerEventLog;
import org.apache.hadoop.mapred.FairSchedulerServlet;
import org.apache.hadoop.mapred.FifoJobComparator;
import org.apache.hadoop.mapred.JobChangeEvent;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobSchedulable;
import org.apache.hadoop.mapred.JobStatusChangeEvent;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.LoadManager;
import org.apache.hadoop.mapred.LocalityLevel;
import org.apache.hadoop.mapred.Pool;
import org.apache.hadoop.mapred.PoolManager;
import org.apache.hadoop.mapred.PoolSchedulable;
import org.apache.hadoop.mapred.Schedulable;
import org.apache.hadoop.mapred.SchedulingAlgorithms;
import org.apache.hadoop.mapred.SubClusterManager;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskSelector;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerEventHandler;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.WeightAdjuster;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.util.ReflectionUtils;

public class FairScheduler
extends TaskScheduler {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.FairScheduler");
    protected long updateInterval = 2500L;
    protected long dumpInterval = 10000L;
    protected long preemptionInterval = 15000L;
    private static final TaskType[] MAP_AND_REDUCE = new TaskType[]{TaskType.MAP, TaskType.REDUCE};
    private static final long MAX_AUTOCOMPUTED_LOCALITY_DELAY = 15000L;
    private static final long SMALLJOB_MAX_INPUT_SIZE = Integer.MIN_VALUE;
    private static final long SMALLJOB_MAX_REDUCE_INPUT_SIZE = 0x40000000L;
    private boolean smallJobScheduling;
    private int smallJobMaxMaps = 0;
    private int smallJobMaxReducers = 0;
    private int smallJobMaxTaskMemory = 200;
    private long smallJobMaxInputSize = Integer.MIN_VALUE;
    private long smallJobMaxReduceInputSize = 0x40000000L;
    protected PoolManager poolMgr;
    protected LoadManager loadMgr;
    protected TaskSelector taskSelector;
    protected WeightAdjuster weightAdjuster;
    protected Map<JobInProgress, JobInfo> infos = new HashMap<JobInProgress, JobInfo>();
    protected long lastUpdateTime;
    protected long lastPreemptionUpdateTime;
    protected boolean initialized;
    protected volatile boolean running;
    protected boolean assignMultiple;
    protected int mapAssignCap = -1;
    protected int reduceAssignCap = -1;
    protected long localityDelay;
    protected boolean autoComputeLocalityDelay = false;
    protected boolean sizeBasedWeight;
    protected boolean waitForMapsBeforeLaunchingReduces = true;
    protected boolean preemptionEnabled;
    protected boolean onlyLogPreemption;
    private Clock clock;
    private EagerTaskInitializationListener eagerInitListener;
    private JobListener jobListener;
    private AtomicBoolean ttEventHandled = new AtomicBoolean(true);
    private SubClusterManager subClusterManager;
    private boolean mockMode;
    private FairSchedulerEventLog eventLog;
    protected long lastDumpTime;
    protected long lastHeartbeatTime;
    private long lastPreemptCheckTime;
    private MetricsUpdater metricsUpdater;

    public FairScheduler() {
        this(new Clock(), false);
    }

    protected FairScheduler(Clock clock, boolean mockMode) {
        this.clock = clock;
        this.mockMode = mockMode;
        this.jobListener = new JobListener();
        this.subClusterManager = new SubClusterManager();
    }

    public void loadSmallJobsConfig(Configuration conf) {
        this.smallJobScheduling = conf.getBoolean("mapred.fairscheduler.smalljob.schedule.enable", true);
        this.smallJobMaxMaps = conf.getInt("mapred.fairscheduler.smalljob.max.maps", 10);
        this.smallJobMaxReducers = conf.getInt("mapred.fairscheduler.smalljob.max.reducers", 10);
        this.smallJobMaxInputSize = conf.getLong("mapred.fairscheduler.smalljob.max.inputsize", Integer.MIN_VALUE);
        this.smallJobMaxReduceInputSize = conf.getLong("mapred.fairscheduler.smalljob.max.reducer.inputsize", 0x40000000L);
        this.smallJobMaxTaskMemory = conf.getInt("mapred.cluster.ephemeral.tasks.memory.limit.mb", 200);
    }

    public synchronized void start() {
        try {
            Configuration conf = this.getConf();
            this.eventLog = new FairSchedulerEventLog();
            boolean logEnabled = conf.getBoolean("mapred.fairscheduler.eventlog.enabled", false);
            if (!this.mockMode && logEnabled) {
                String hostname = "localhost";
                if (this.taskTrackerManager instanceof JobTracker) {
                    hostname = ((JobTracker)this.taskTrackerManager).getJobTrackerMachine();
                }
                this.eventLog.init(conf, hostname);
            }
            this.taskTrackerManager.addJobInProgressListener((JobInProgressListener)this.jobListener);
            this.registerTaskTrackerEventHandler();
            if (!this.mockMode) {
                this.eagerInitListener = new EagerTaskInitializationListener(conf);
                this.eagerInitListener.setTaskTrackerManager(this.taskTrackerManager);
                this.eagerInitListener.start();
                this.taskTrackerManager.addJobInProgressListener((JobInProgressListener)this.eagerInitListener);
            }
            this.loadSmallJobsConfig(conf);
            this.poolMgr = new PoolManager(this);
            this.poolMgr.initialize();
            if (this.smallJobScheduling) {
                this.poolMgr.getPool("ExpressLane");
            }
            this.loadMgr = (LoadManager)ReflectionUtils.newInstance((Class)conf.getClass("mapred.fairscheduler.loadmanager", CapBasedLoadManager.class, LoadManager.class), (Configuration)conf);
            this.loadMgr.setTaskTrackerManager(this.taskTrackerManager);
            this.loadMgr.setEventLog(this.eventLog);
            this.loadMgr.start();
            this.taskSelector = (TaskSelector)ReflectionUtils.newInstance((Class)conf.getClass("mapred.fairscheduler.taskselector", DefaultTaskSelector.class, TaskSelector.class), (Configuration)conf);
            this.taskSelector.setTaskTrackerManager(this.taskTrackerManager);
            this.taskSelector.start();
            Class weightAdjClass = conf.getClass("mapred.fairscheduler.weightadjuster", null);
            if (weightAdjClass != null) {
                this.weightAdjuster = (WeightAdjuster)ReflectionUtils.newInstance((Class)weightAdjClass, (Configuration)conf);
            }
            this.updateInterval = conf.getLong("mapred.fairscheduler.update.interval", 2500L);
            this.dumpInterval = conf.getLong("mapred.fairscheduler.dump.interval", 10000L);
            this.preemptionInterval = conf.getLong("mapred.fairscheduler.preemption.interval", 15000L);
            this.assignMultiple = conf.getBoolean("mapred.fairscheduler.assignmultiple", true);
            this.mapAssignCap = conf.getInt("mapred.fairscheduler.assignmultiple.maps", -1);
            this.reduceAssignCap = conf.getInt("mapred.fairscheduler.assignmultiple.reduces", -1);
            this.sizeBasedWeight = conf.getBoolean("mapred.fairscheduler.sizebasedweight", false);
            this.preemptionEnabled = conf.getBoolean("mapred.fairscheduler.preemption", false);
            this.onlyLogPreemption = conf.getBoolean("mapred.fairscheduler.preemption.only.log", false);
            this.localityDelay = conf.getLong("mapred.fairscheduler.locality.delay", -1L);
            if (this.localityDelay == -1L) {
                this.autoComputeLocalityDelay = true;
            }
            this.initialized = true;
            this.running = true;
            this.lastUpdateTime = this.clock.getTime();
            if (!this.mockMode) {
                new UpdateThread().start();
            }
            if (this.taskTrackerManager instanceof JobTracker) {
                JobTracker jobTracker = (JobTracker)this.taskTrackerManager;
                HttpServer infoServer = jobTracker.infoServer;
                infoServer.setAttribute("scheduler", (Object)this);
                infoServer.addServlet("scheduler", "/scheduler", FairSchedulerServlet.class);
            }
            this.initMetrics();
            this.eventLog.log("INITIALIZED", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start FairScheduler", e);
        }
        LOG.info((Object)"Successfully configured FairScheduler");
    }

    private void initMetrics() {
        MetricsContext context = MetricsUtil.getContext((String)"fairscheduler");
        this.metricsUpdater = new MetricsUpdater();
        context.registerUpdater((Updater)this.metricsUpdater);
    }

    public void terminate() throws IOException {
        if (this.eventLog != null) {
            this.eventLog.log("SHUTDOWN", new Object[0]);
        }
        this.running = false;
        if (this.jobListener != null) {
            this.taskTrackerManager.removeJobInProgressListener((JobInProgressListener)this.jobListener);
        }
        if (this.eagerInitListener != null) {
            this.taskTrackerManager.removeJobInProgressListener((JobInProgressListener)this.eagerInitListener);
        }
        if (this.eventLog != null) {
            this.eventLog.shutdown();
        }
        if (this.metricsUpdater != null) {
            MetricsContext context = MetricsUtil.getContext((String)"fairscheduler");
            context.unregisterUpdater((Updater)this.metricsUpdater);
            this.metricsUpdater = null;
        }
    }

    synchronized void updateMetrics() {
        this.poolMgr.updateMetrics();
    }

    public boolean isSmallJob(JobInProgress job) {
        if (!this.smallJobScheduling) {
            return false;
        }
        return !(job.hasFailedTasks() || job.getMemoryForMapTask() > (long)this.smallJobMaxTaskMemory || job.getMemoryForReduceTask() > (long)this.smallJobMaxTaskMemory || this.smallJobMaxMaps > 0 && job.desiredMaps() > this.smallJobMaxMaps || this.smallJobMaxReducers > 0 && job.desiredReduces() > this.smallJobMaxReducers || this.smallJobMaxInputSize > 0L && job.getInputLength() > this.smallJobMaxInputSize || this.smallJobMaxReduceInputSize > 0L && job.getEstimatedReduceInputSize() > this.smallJobMaxReduceInputSize);
    }

    public synchronized void updateSmallJobPool(boolean moveAllJobs) {
        if (!this.smallJobScheduling) {
            return;
        }
        Pool smallJobPool = this.poolMgr.getPool("ExpressLane");
        if (smallJobPool != null) {
            ArrayList<JobInProgress> removeJobs = new ArrayList<JobInProgress>();
            for (JobInProgress job : smallJobPool.getJobs()) {
                if (job.getStatus().getRunState() != 1 && job.getStatus().getRunState() != 4 || !moveAllJobs && this.isSmallJob(job)) continue;
                removeJobs.add(job);
            }
            for (JobInProgress job : removeJobs) {
                LOG.info((Object)("Moving job from express lane " + job.getJobID()));
                this.eventLog.log("SMALL JOB", "MOVING JOB " + job.getJobID());
                smallJobPool.removeJob(job);
                job.getJobConf().set("mapred.fairscheduler.pool", this.poolMgr.getPoolName(job));
                this.poolMgr.getPool(this.poolMgr.getPoolName(job)).addJob(job);
            }
        }
    }

    public synchronized List<Task> assignEphemeralTasks(TaskTracker tracker) throws IOException {
        boolean clusterBusy;
        if (!this.initialized) {
            return null;
        }
        if (!this.smallJobScheduling) {
            return null;
        }
        String trackerName = tracker.getTrackerName();
        this.eventLog.log("SMALLJOB HEARTBEAT", trackerName);
        int runnableMaps = 0;
        int runningMaps = 0;
        int runnableReduces = 0;
        int runningReduces = 0;
        int smallJobRunnableMaps = 0;
        int smallJobRunningMaps = 0;
        int smallJobRunnableReduces = 0;
        int smallJobRunningReduces = 0;
        Pool smallJobPool = null;
        for (Pool pool : this.poolMgr.getPools()) {
            if ("ExpressLane".equals(pool.getName())) {
                smallJobPool = pool;
                smallJobRunnableMaps += pool.getMapSchedulable().getDemand();
                smallJobRunningMaps += pool.getMapSchedulable().getRunningTasks();
                smallJobRunnableReduces += pool.getReduceSchedulable().getDemand();
                smallJobRunningReduces += pool.getReduceSchedulable().getRunningTasks();
                continue;
            }
            runnableMaps += pool.getMapSchedulable().getDemand();
            runningMaps += pool.getMapSchedulable().getRunningTasks();
            runnableReduces += pool.getReduceSchedulable().getDemand();
            runningReduces += pool.getReduceSchedulable().getRunningTasks();
        }
        if (smallJobPool == null) {
            return null;
        }
        ClusterStatus clusterStatus = this.taskTrackerManager.getClusterStatus();
        int totalMapSlots = this.getTotalSlots(TaskType.MAP, clusterStatus);
        int totalReduceSlots = this.getTotalSlots(TaskType.REDUCE, clusterStatus);
        this.eventLog.log("SMALLJOB RUNNABLE_TASKS", runnableMaps, runningMaps, runnableReduces, runningReduces);
        this.eventLog.log("SMALLJOB RUNNABLE_EPHEMERAL_TASKS", smallJobRunnableMaps, smallJobRunningMaps, smallJobRunnableReduces, smallJobRunningReduces);
        TaskTrackerStatus tts = tracker.getStatus();
        int freeSlots = tts.getEphemeralSlots();
        ArrayList<Task> tasks = new ArrayList<Task>();
        boolean bl = clusterBusy = runningMaps >= totalMapSlots || runningReduces >= totalReduceSlots;
        if (clusterBusy) {
            this.eventLog.log("SMALLJOB Cluster BUSY", new Object[0]);
        } else {
            this.eventLog.log("SMALLJOB Cluster IDLE", new Object[0]);
        }
        this.updateSmallJobPool(!clusterBusy);
        if (clusterBusy) {
            TaskType taskType = TaskType.MAP;
            int numTaskTrackers = clusterStatus.getTaskTrackers();
            Task task = null;
            while (freeSlots > 0) {
                this.eventLog.log("SMALLJOB INFO", "Checking for " + taskType + " task");
                task = null;
                for (JobInProgress job : smallJobPool.getJobs()) {
                    if (job.getStatus().getRunState() != 1 || (task = taskType == TaskType.MAP ? job.obtainNewMapTask(tts, numTaskTrackers, this.taskTrackerManager.getNumberOfUniqueHosts()) : job.obtainNewReduceTask(tts, numTaskTrackers, this.taskTrackerManager.getNumberOfUniqueHosts())) == null) continue;
                    this.eventLog.log("SMALLJOB ASSIGN", trackerName, taskType, job.getJobID(), task.getTaskID());
                    tasks.add(task);
                    --freeSlots;
                    break;
                }
                if (task != null) continue;
                if (taskType != TaskType.MAP) break;
                taskType = TaskType.REDUCE;
            }
        }
        return tasks.isEmpty() ? null : tasks;
    }

    public boolean supportsEphemeralTasks() {
        return true;
    }

    public synchronized List<Task> assignTasks(TaskTracker tracker) throws IOException {
        if (!this.initialized) {
            return null;
        }
        String trackerName = tracker.getTrackerName();
        this.eventLog.log("HEARTBEAT", trackerName);
        long currentTime = this.clock.getTime();
        int runnableMaps = 0;
        int runningMaps = 0;
        int runnableReduces = 0;
        int runningReduces = 0;
        for (Pool pool : this.poolMgr.getPools()) {
            runnableMaps += pool.getMapSchedulable().getDemand();
            runningMaps += pool.getMapSchedulable().getRunningTasks();
            runnableReduces += pool.getReduceSchedulable().getDemand();
            runningReduces += pool.getReduceSchedulable().getRunningTasks();
        }
        ClusterStatus clusterStatus = this.taskTrackerManager.getClusterStatus();
        int totalMapSlots = this.getTotalSlots(TaskType.MAP, clusterStatus);
        int totalReduceSlots = this.getTotalSlots(TaskType.REDUCE, clusterStatus);
        this.eventLog.log("RUNNABLE_TASKS", runnableMaps, runningMaps, runnableReduces, runningReduces);
        boolean logThisAssignment = false;
        if (this.taskTrackerManager instanceof JobTracker) {
            logThisAssignment = ((JobTracker)this.taskTrackerManager).logThisHeartbeat;
        }
        if (LOG.isInfoEnabled() && logThisAssignment && (runnableMaps > 0 || runnableReduces > 0)) {
            LOG.info((Object)("HB(" + trackerName + "): FairScheduler.assignTasks: Maps(" + runningMaps + " running, " + runnableMaps + " runnable); Reduces(" + runningReduces + " running, " + runnableReduces + " runnable)."));
        }
        this.updateLocalityWaitTimes(currentTime);
        TaskTrackerStatus tts = tracker.getStatus();
        int mapsAssigned = 0;
        int reducesAssigned = 0;
        int mapCapacity = this.maxTasksToAssign(TaskType.MAP, tts);
        int reduceCapacity = this.maxTasksToAssign(TaskType.REDUCE, tts);
        boolean mapRejected = false;
        boolean reduceRejected = false;
        HashSet<JobInProgress> visitedForMap = new HashSet<JobInProgress>();
        HashSet<JobInProgress> visitedForReduce = new HashSet<JobInProgress>();
        HashSet<JobInProgress> launchedMap = new HashSet<JobInProgress>();
        ArrayList<Task> tasks = new ArrayList<Task>();
        if (this.ttEventHandled.compareAndSet(false, true) && this.taskTrackerManager instanceof JobTracker) {
            this.subClusterManager.refreshSlots((JobTracker)this.taskTrackerManager);
        }
        while (true) {
            if (!(mapRejected || mapsAssigned != mapCapacity && runningMaps != runnableMaps && (this.subClusterManager.hasLabeledJobs() || this.loadMgr.canAssignMap(tts, runnableMaps, totalMapSlots, mapsAssigned)))) {
                this.eventLog.log("INFO", "Can't assign another MAP to " + trackerName);
                mapRejected = true;
            }
            if (!(reduceRejected || reducesAssigned != reduceCapacity && runningReduces != runnableReduces && (this.subClusterManager.hasLabeledJobs() || this.loadMgr.canAssignReduce(tts, runnableReduces, totalReduceSlots, reducesAssigned)))) {
                this.eventLog.log("INFO", "Can't assign another REDUCE to " + trackerName);
                reduceRejected = true;
            }
            if (mapRejected && reduceRejected || !this.assignMultiple && tasks.size() > 0) break;
            TaskType taskType = mapRejected ? TaskType.REDUCE : (reduceRejected ? TaskType.MAP : (tts.countMapTasks() <= tts.countReduceTasks() ? TaskType.MAP : TaskType.REDUCE));
            List<PoolSchedulable> scheds = this.getPoolSchedulables(taskType);
            Collections.sort(scheds, new SchedulingAlgorithms.FairShareComparator());
            boolean foundTask = false;
            for (PoolSchedulable sched : scheds) {
                Task task;
                int numJobs;
                this.eventLog.log("INFO", "Checking for " + taskType + " task in " + sched.getName());
                if (LOG.isInfoEnabled() && logThisAssignment && (numJobs = sched.getPool().getJobs().size()) > 0) {
                    String poolName = sched.getName();
                    if (taskType == TaskType.MAP) {
                        int poolRunningMaps = sched.getPool().getMapSchedulable().getRunningTasks();
                        int poolRunnableMaps = this.poolMgr.getAllocation(poolName, TaskType.MAP);
                        LOG.info((Object)("HB(" + trackerName + "): Checking for MAP task in Pool " + poolName + " of " + numJobs + " jobs, " + poolRunningMaps + " maps running of " + poolRunnableMaps + "runnable."));
                    } else {
                        int poolRunningReduces = sched.getPool().getReduceSchedulable().getRunningTasks();
                        int poolRunnableReduces = this.poolMgr.getAllocation(poolName, TaskType.REDUCE);
                        LOG.info((Object)("HB(" + trackerName + "): Checking for REDUCE task in Pool " + poolName + " of " + numJobs + " jobs, " + poolRunningReduces + " reduces running of " + poolRunnableReduces + "runnable."));
                    }
                }
                if ((task = taskType == TaskType.MAP ? sched.assignTask(tts, currentTime, visitedForMap, mapsAssigned) : sched.assignTask(tts, currentTime, visitedForReduce, reducesAssigned)) == null) continue;
                foundTask = true;
                JobInProgress job = this.taskTrackerManager.getJob(task.getJobID());
                this.eventLog.log("ASSIGN", trackerName, taskType, job.getJobID(), task.getTaskID());
                if (LOG.isInfoEnabled() && logThisAssignment) {
                    LOG.info((Object)("HB(" + trackerName + "): Assigning " + taskType + " task " + task.getTaskID() + " from Pool " + sched.getName()));
                }
                if (taskType == TaskType.MAP) {
                    launchedMap.add(job);
                    ++mapsAssigned;
                    ++runningMaps;
                    this.updateLastMapLocalityLevel(job, task, tts);
                } else {
                    ++reducesAssigned;
                    ++runningReduces;
                }
                tasks.add(task);
                break;
            }
            if (foundTask) continue;
            if (taskType == TaskType.MAP) {
                mapRejected = true;
                continue;
            }
            reduceRejected = true;
        }
        for (JobInProgress job : visitedForMap) {
            if (launchedMap.contains(job)) continue;
            this.infos.get((Object)job).skippedAtLastHeartbeat = true;
        }
        return tasks.isEmpty() ? null : tasks;
    }

    protected int maxTasksToAssign(TaskType type, TaskTrackerStatus tts) {
        int availableSlots;
        if (!this.assignMultiple) {
            return 1;
        }
        int cap = type == TaskType.MAP ? this.mapAssignCap : this.reduceAssignCap;
        int n = availableSlots = type == TaskType.MAP ? tts.getAvailableMapSlots() : tts.getAvailableReduceSlots();
        if (cap == -1) {
            return availableSlots;
        }
        return Math.min(cap, availableSlots);
    }

    private void updateLocalityWaitTimes(long currentTime) {
        long timeSinceLastHeartbeat = this.lastHeartbeatTime == 0L ? 0L : currentTime - this.lastHeartbeatTime;
        this.lastHeartbeatTime = currentTime;
        for (JobInfo info : this.infos.values()) {
            if (!info.skippedAtLastHeartbeat) continue;
            info.timeWaitedForLocalMap += timeSinceLastHeartbeat;
            info.skippedAtLastHeartbeat = false;
        }
    }

    private void updateLastMapLocalityLevel(JobInProgress job, Task mapTaskLaunched, TaskTrackerStatus tracker) {
        LocalityLevel localityLevel;
        JobInfo info = this.infos.get(job);
        info.lastMapLocalityLevel = localityLevel = LocalityLevel.fromTask(job, mapTaskLaunched, tracker);
        info.timeWaitedForLocalMap = 0L;
        this.eventLog.log("ASSIGNED_LOC_LEVEL", new Object[]{job.getJobID(), localityLevel});
    }

    protected LocalityLevel getAllowedLocalityLevel(JobInProgress job, long currentTime) {
        JobInfo info = this.infos.get(job);
        if (info == null) {
            LOG.error((Object)("getAllowedLocalityLevel called on job " + job + ", which does not have a JobInfo in infos"));
            return LocalityLevel.ANY;
        }
        if (job.nonLocalMaps.size() > 0) {
            return LocalityLevel.ANY;
        }
        Pool pool = this.poolMgr.getPool(job);
        PoolSchedulable sched = pool.getMapSchedulable();
        long minShareTimeout = this.poolMgr.getMinSharePreemptionTimeout(pool.getName());
        long fairShareTimeout = this.poolMgr.getFairSharePreemptionTimeout();
        if (currentTime - sched.getLastTimeAtMinShare() > minShareTimeout || currentTime - sched.getLastTimeAtHalfFairShare() > fairShareTimeout) {
            this.eventLog.log("INFO", "No delay scheduling for " + job.getJobID() + " because it is being starved");
            return LocalityLevel.ANY;
        }
        switch (info.lastMapLocalityLevel) {
            case NODE: {
                if (info.timeWaitedForLocalMap >= 2L * this.localityDelay) {
                    return LocalityLevel.ANY;
                }
                if (info.timeWaitedForLocalMap >= this.localityDelay) {
                    return LocalityLevel.RACK;
                }
                return LocalityLevel.NODE;
            }
            case RACK: {
                if (info.timeWaitedForLocalMap >= this.localityDelay) {
                    return LocalityLevel.ANY;
                }
                return LocalityLevel.RACK;
            }
        }
        return LocalityLevel.ANY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        ClusterStatus clusterStatus = this.taskTrackerManager.getClusterStatus();
        if (this.autoComputeLocalityDelay) {
            JobTracker jobTracker = (JobTracker)this.taskTrackerManager;
            this.localityDelay = Math.min(15000L, (long)(1.5 * (double)Math.max(3000L, (long)jobTracker.getNextHeartbeatInterval())));
        }
        FairScheduler fairScheduler = this;
        synchronized (fairScheduler) {
            this.poolMgr.reloadAllocsIfNecessary();
            ArrayList<JobInProgress> toRemove = new ArrayList<JobInProgress>();
            for (JobInProgress job : this.infos.keySet()) {
                int runState = job.getStatus().getRunState();
                if (runState != 2 && runState != 3 && runState != 5) continue;
                toRemove.add(job);
            }
            for (JobInProgress job : toRemove) {
                this.jobNoLongerRunning(job);
            }
            this.updateRunnability();
            for (Pool pool : this.poolMgr.getPools()) {
                pool.getMapSchedulable().updateDemand();
                pool.getReduceSchedulable().updateDemand();
            }
            List<PoolSchedulable> mapScheds = this.getPoolSchedulables(TaskType.MAP);
            List<PoolSchedulable> reduceScheds = this.getPoolSchedulables(TaskType.REDUCE);
            SchedulingAlgorithms.computeFairShares(mapScheds, clusterStatus.getMaxMapTasks());
            SchedulingAlgorithms.computeFairShares(reduceScheds, clusterStatus.getMaxReduceTasks());
            for (Pool pool : this.poolMgr.getPools()) {
                pool.getMapSchedulable().redistributeShare();
                pool.getReduceSchedulable().redistributeShare();
            }
            if (this.preemptionEnabled) {
                this.updatePreemptionVariables();
            }
        }
    }

    private void jobNoLongerRunning(JobInProgress job) {
        assert (Thread.holdsLock((Object)this));
        JobInfo info = this.infos.remove(job);
        if (info != null) {
            info.mapSchedulable.cleanupMetrics();
            info.reduceSchedulable.cleanupMetrics();
        }
        this.poolMgr.removeJob(job);
    }

    public List<PoolSchedulable> getPoolSchedulables(TaskType type) {
        ArrayList<PoolSchedulable> scheds = new ArrayList<PoolSchedulable>();
        for (Pool pool : this.poolMgr.getPools()) {
            scheds.add(pool.getSchedulable(type));
        }
        return scheds;
    }

    private void updateRunnability() {
        for (JobInfo info : this.infos.values()) {
            info.runnable = false;
        }
        ArrayList<JobInProgress> jobs = new ArrayList<JobInProgress>(this.infos.keySet());
        Collections.sort(jobs, new FifoJobComparator());
        HashMap<String, Integer> userJobs = new HashMap<String, Integer>();
        HashMap<String, Integer> poolJobs = new HashMap<String, Integer>();
        for (JobInProgress job : jobs) {
            int poolCount;
            if (job.getStatus().getRunState() != 1) continue;
            String user = job.getJobConf().getUser();
            String pool = this.poolMgr.getPoolName(job);
            int userCount = userJobs.containsKey(user) ? (Integer)userJobs.get(user) : 0;
            int n = poolCount = poolJobs.containsKey(pool) ? (Integer)poolJobs.get(pool) : 0;
            if (userCount >= this.poolMgr.getUserMaxJobs(user) || poolCount >= this.poolMgr.getPoolMaxJobs(pool)) continue;
            this.infos.get((Object)job).runnable = true;
            userJobs.put(user, userCount + 1);
            poolJobs.put(pool, poolCount + 1);
        }
    }

    public double getJobWeight(JobInProgress job, TaskType taskType) {
        if (!this.isRunnable(job)) {
            return 1.0;
        }
        double weight = 1.0;
        if (this.sizeBasedWeight) {
            JobInfo info = this.infos.get(job);
            int runnableTasks = taskType == TaskType.MAP ? info.mapSchedulable.getDemand() : info.reduceSchedulable.getDemand();
            weight = Math.log1p(runnableTasks) / Math.log(2.0);
        }
        weight *= this.getPriorityFactor(job.getPriority());
        if (this.weightAdjuster != null) {
            weight = this.weightAdjuster.adjustWeight(job, taskType, weight);
        }
        return weight;
    }

    private double getPriorityFactor(JobPriority priority) {
        switch (priority) {
            case VERY_HIGH: {
                return 4.0;
            }
            case HIGH: {
                return 2.0;
            }
            case NORMAL: {
                return 1.0;
            }
            case LOW: {
                return 0.5;
            }
        }
        return 0.25;
    }

    public PoolManager getPoolManager() {
        return this.poolMgr;
    }

    private int getTotalSlots(TaskType type, ClusterStatus clusterStatus) {
        return type == TaskType.MAP ? clusterStatus.getMaxMapTasks() : clusterStatus.getMaxReduceTasks();
    }

    private void updatePreemptionVariables() {
        long now;
        this.lastPreemptionUpdateTime = now = this.clock.getTime();
        for (TaskType type : MAP_AND_REDUCE) {
            for (PoolSchedulable sched : this.getPoolSchedulables(type)) {
                if (!this.isStarvedForMinShare(sched)) {
                    sched.setLastTimeAtMinShare(now);
                }
                if (!this.isStarvedForFairShare(sched)) {
                    sched.setLastTimeAtHalfFairShare(now);
                }
                this.eventLog.log("PREEMPT_VARS", sched.getName(), type, now - sched.getLastTimeAtMinShare(), now - sched.getLastTimeAtHalfFairShare());
            }
        }
    }

    boolean isStarvedForMinShare(PoolSchedulable sched) {
        int desiredShare = Math.min(sched.getMinShare(), sched.getDemand());
        return sched.getRunningTasks() < desiredShare;
    }

    boolean isStarvedForFairShare(PoolSchedulable sched) {
        int desiredFairShare = (int)Math.floor(Math.min(sched.getFairShare() / 2.0, (double)sched.getDemand()));
        return sched.getRunningTasks() < desiredFairShare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preemptTasksIfNecessary() {
        if (!this.preemptionEnabled) {
            return;
        }
        long curTime = this.clock.getTime();
        if (curTime - this.lastPreemptCheckTime < this.preemptionInterval) {
            return;
        }
        this.lastPreemptCheckTime = curTime;
        TaskTrackerManager taskTrackerManager = this.taskTrackerManager;
        synchronized (taskTrackerManager) {
            FairScheduler fairScheduler = this;
            synchronized (fairScheduler) {
                for (TaskType type : MAP_AND_REDUCE) {
                    List<PoolSchedulable> scheds = this.getPoolSchedulables(type);
                    HashMap<JobSchedulable, Integer> tasksToPreempt = new HashMap<JobSchedulable, Integer>();
                    for (PoolSchedulable sched : scheds) {
                        tasksToPreempt.putAll(this.tasksToPreempt(sched, curTime));
                    }
                    if (tasksToPreempt.isEmpty()) continue;
                    this.eventLog.log("SHOULD_PREEMPT", type, tasksToPreempt);
                    if (this.onlyLogPreemption) continue;
                    this.preemptTasks(scheds, tasksToPreempt);
                }
            }
        }
    }

    private void preemptTasks(List<PoolSchedulable> scheds, HashMap<JobSchedulable, Integer> tasksToPreempt) {
        if (scheds.isEmpty() || tasksToPreempt.isEmpty()) {
            return;
        }
        TaskType taskType = scheds.get(0).getTaskType();
        ArrayList<TaskStatus> runningTasks = new ArrayList<TaskStatus>();
        for (PoolSchedulable sched : scheds) {
            if (!((double)sched.getRunningTasks() > sched.getFairShare())) continue;
            for (JobSchedulable js : sched.getJobSchedulables()) {
                runningTasks.addAll(this.getRunningTasks(js.getJob(), taskType));
            }
        }
        Collections.sort(runningTasks, new Comparator<TaskStatus>(){

            @Override
            public int compare(TaskStatus t1, TaskStatus t2) {
                if (t1.getStartTime() < t2.getStartTime()) {
                    return 1;
                }
                if (t1.getStartTime() == t2.getStartTime()) {
                    return 0;
                }
                return -1;
            }
        });
        HashMap<Pool, Integer> tasksLeft = new HashMap<Pool, Integer>();
        for (Pool p : this.poolMgr.getPools()) {
            tasksLeft.put(p, p.getSchedulable(taskType).getRunningTasks());
        }
        JobTracker jobTracker = (JobTracker)this.taskTrackerManager;
        for (TaskStatus status : runningTasks) {
            JobID jobID = status.getTaskID().getJobID();
            JobInProgress job = this.taskTrackerManager.getJob(jobID);
            Pool pool = this.poolMgr.getPool(job);
            PoolSchedulable sched = pool.getSchedulable(taskType);
            int tasksLeftForPool = (Integer)tasksLeft.get(pool);
            if (!((double)tasksLeftForPool > sched.getFairShare())) continue;
            TaskTrackerStatus ttStatus = jobTracker.getTaskTrackerStatus(status.getTaskTracker());
            JobSchedulable preemptJob = null;
            for (JobSchedulable jobSchedulable : tasksToPreempt.keySet()) {
                JobInProgress jobInProgress = jobSchedulable.getJob();
                HashMap scheTable = jobInProgress.getScheTable();
                boolean shouldScheduleOnTaskTracker = false;
                if (scheTable.containsKey(ttStatus)) {
                    shouldScheduleOnTaskTracker = (Boolean)scheTable.get(ttStatus);
                } else {
                    shouldScheduleOnTaskTracker = jobInProgress.shouldScheduleOnTaskTracker(ttStatus);
                    scheTable.put(ttStatus, shouldScheduleOnTaskTracker);
                }
                if (!shouldScheduleOnTaskTracker) continue;
                preemptJob = jobSchedulable;
                break;
            }
            if (preemptJob == null) continue;
            this.eventLog.log("PREEMPT", status.getTaskID(), status.getTaskTracker());
            try {
                this.taskTrackerManager.preemptTask(status.getTaskID());
                tasksToPreempt.put(preemptJob, tasksToPreempt.get(preemptJob) - 1);
                if (tasksToPreempt.get(preemptJob) <= 0) {
                    tasksToPreempt.remove(preemptJob);
                }
                if (tasksToPreempt.isEmpty()) break;
                tasksLeft.put(pool, --tasksLeftForPool);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to kill task " + status.getTaskID()), (Throwable)e);
            }
        }
        for (JobSchedulable jobSchedulable : tasksToPreempt.keySet()) {
            JobInProgress jobInProgress = jobSchedulable.getJob();
            jobInProgress.getScheTable().clear();
        }
    }

    protected HashMap<JobSchedulable, Integer> tasksToPreempt(PoolSchedulable sched, long curTime) {
        int target;
        String pool = sched.getName();
        long minShareTimeout = this.poolMgr.getMinSharePreemptionTimeout(pool);
        long fairShareTimeout = this.poolMgr.getFairSharePreemptionTimeout();
        int tasksDueToMinShare = 0;
        int tasksDueToFairShare = 0;
        if (curTime - sched.getLastTimeAtMinShare() > minShareTimeout) {
            target = Math.min(sched.getMinShare(), sched.getDemand());
            tasksDueToMinShare = Math.max(0, target - sched.getRunningTasks());
        }
        if (curTime - sched.getLastTimeAtHalfFairShare() > fairShareTimeout) {
            target = (int)Math.min(sched.getFairShare(), (double)sched.getDemand());
            tasksDueToFairShare = Math.max(0, target - sched.getRunningTasks());
        }
        int numTasksToPreempt = Math.max(tasksDueToMinShare, tasksDueToFairShare);
        HashMap<JobSchedulable, Integer> tasksToPremmpt = new HashMap<JobSchedulable, Integer>();
        if (numTasksToPreempt > 0) {
            String message = "Should preempt " + numTasksToPreempt + " " + sched.getTaskType() + " tasks for pool " + sched.getName() + ": tasksDueToMinShare = " + tasksDueToMinShare + ", tasksDueToFairShare = " + tasksDueToFairShare;
            this.eventLog.log("INFO", message);
            LOG.info((Object)message);
            for (JobSchedulable job : sched.getJobSchedulables()) {
                int demand = job.getDemand();
                if (demand >= numTasksToPreempt) {
                    tasksToPremmpt.put(job, numTasksToPreempt);
                    break;
                }
                tasksToPremmpt.put(job, demand);
                numTasksToPreempt -= demand;
            }
        }
        return tasksToPremmpt;
    }

    private List<TaskStatus> getRunningTasks(JobInProgress job, TaskType type) {
        ArrayList tips = new ArrayList();
        if (type == TaskType.MAP) {
            tips.addAll(job.nonLocalRunningMaps);
            for (Set set : job.runningMapCache.values()) {
                tips.addAll(set);
            }
        } else {
            tips.addAll(job.runningReduces);
        }
        ArrayList<TaskStatus> statuses = new ArrayList<TaskStatus>();
        for (TaskInProgress tip : tips) {
            for (TaskAttemptID id : tip.getActiveTasks().keySet()) {
                TaskStatus stat = tip.getTaskStatus(id);
                if (stat == null) continue;
                statuses.add(stat);
            }
        }
        return statuses;
    }

    protected boolean isRunnable(JobInProgress job) {
        JobInfo info = this.infos.get(job);
        if (info == null) {
            return false;
        }
        return info.runnable;
    }

    public synchronized Collection<JobInProgress> getJobs(String queueName) {
        if (!this.initialized || queueName == null || !this.poolMgr.hasPool(queueName)) {
            return null;
        }
        Pool myJobPool = this.poolMgr.getPool(queueName);
        return myJobPool.getJobs();
    }

    protected void dumpIfNecessary() {
        long now = this.clock.getTime();
        long timeDelta = now - this.lastDumpTime;
        if (timeDelta > this.dumpInterval && this.eventLog.isEnabled()) {
            this.dump();
            this.lastDumpTime = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dump() {
        FairSchedulerEventLog fairSchedulerEventLog = this.eventLog;
        synchronized (fairSchedulerEventLog) {
            this.eventLog.log("BEGIN_DUMP", new Object[0]);
            ArrayList<JobInProgress> jobs = new ArrayList<JobInProgress>(this.infos.keySet());
            Collections.sort(jobs, new Comparator<JobInProgress>(){

                @Override
                public int compare(JobInProgress j1, JobInProgress j2) {
                    return (int)Math.signum(j1.getStartTime() - j2.getStartTime());
                }
            });
            for (JobInProgress job : jobs) {
                JobProfile profile = job.getProfile();
                JobInfo info = this.infos.get(job);
                JobSchedulable ms = info.mapSchedulable;
                JobSchedulable rs = info.reduceSchedulable;
                this.eventLog.log("JOB", profile.getJobID(), profile.name, profile.user, job.getPriority(), this.poolMgr.getPoolName(job), job.numMapTasks, ((Schedulable)ms).getRunningTasks(), ((Schedulable)ms).getDemand(), ((Schedulable)ms).getFairShare(), ((Schedulable)ms).getWeight(), job.numReduceTasks, ((Schedulable)rs).getRunningTasks(), ((Schedulable)rs).getDemand(), ((Schedulable)rs).getFairShare(), ((Schedulable)rs).getWeight());
            }
            ArrayList<Pool> pools = new ArrayList<Pool>(this.poolMgr.getPools());
            Collections.sort(pools, new Comparator<Pool>(){

                @Override
                public int compare(Pool p1, Pool p2) {
                    if (p1.isDefaultPool()) {
                        return 1;
                    }
                    if (p2.isDefaultPool()) {
                        return -1;
                    }
                    return p1.getName().compareTo(p2.getName());
                }
            });
            for (Pool pool : pools) {
                int runningMaps = pool.getMapSchedulable().getRunningTasks();
                int runningReduces = pool.getReduceSchedulable().getRunningTasks();
                String name = pool.getName();
                this.eventLog.log("POOL", name, this.poolMgr.getPoolWeight(name), pool.getJobs().size(), this.poolMgr.getAllocation(name, TaskType.MAP), runningMaps, this.poolMgr.getAllocation(name, TaskType.REDUCE), runningReduces);
            }
            this.eventLog.log("END_DUMP", new Object[0]);
        }
    }

    public Clock getClock() {
        return this.clock;
    }

    public FairSchedulerEventLog getEventLog() {
        return this.eventLog;
    }

    public JobInfo getJobInfo(JobInProgress job) {
        return this.infos.get(job);
    }

    boolean isPreemptionEnabled() {
        return this.preemptionEnabled;
    }

    long getLastPreemptionUpdateTime() {
        return this.lastPreemptionUpdateTime;
    }

    public synchronized boolean hasServlet() {
        return this.initialized;
    }

    public boolean isLoadBalanced(TaskTrackerStatus ttStatus, JobSchedulable jobSched, int tasksAssignedInCurHB) {
        if (!this.subClusterManager.hasLabeledJobs()) {
            return true;
        }
        TaskType taskType = jobSched.getTaskType();
        SubClusterManager.SubCluster subCluster = this.subClusterManager.get(jobSched.getJob(), taskType);
        if (subCluster == null) {
            LOG.error((Object)("SubCluster not found for job: " + jobSched.getJob().getJobID().toString() + " label expression: " + jobSched.getJob().getLabel()));
            return true;
        }
        if (taskType.equals((Object)TaskType.MAP)) {
            return this.loadMgr.canAssignMap(ttStatus, subCluster.getTotalTasks(), subCluster.getTotalSlots(), tasksAssignedInCurHB);
        }
        return this.loadMgr.canAssignReduce(ttStatus, subCluster.getTotalTasks(), subCluster.getTotalSlots(), tasksAssignedInCurHB);
    }

    private void registerTaskTrackerEventHandler() {
        if (!(this.taskTrackerManager instanceof JobTracker)) {
            return;
        }
        ((JobTracker)this.taskTrackerManager).addTaskTrackerEventHandler(new TaskTrackerEventHandler(){

            public void added(TaskTracker taskTracker) {
                FairScheduler.this.ttEventHandled.set(false);
                LOG.info((Object)("TaskTracker added: " + taskTracker.getTrackerName()));
            }

            public void blacklisted(String hostname) {
                FairScheduler.this.ttEventHandled.set(false);
                LOG.info((Object)("Host blacklisted: " + hostname));
            }

            public void unblacklisted(String hostname) {
                FairScheduler.this.ttEventHandled.set(false);
                LOG.info((Object)("Host unblacklisted: " + hostname));
            }

            public void labelUpdated() {
                FairScheduler.this.ttEventHandled.set(false);
                LOG.info((Object)"Node labels updated");
            }
        });
        LOG.info((Object)"Regisetered TaskTracker event handler");
    }

    private class UpdateThread
    extends Thread {
        private UpdateThread() {
            super("FairScheduler update thread");
        }

        @Override
        public void run() {
            while (FairScheduler.this.running) {
                try {
                    Thread.sleep(FairScheduler.this.updateInterval);
                    FairScheduler.this.update();
                    FairScheduler.this.dumpIfNecessary();
                    FairScheduler.this.preemptTasksIfNecessary();
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception in fair scheduler UpdateThread", (Throwable)e);
                }
            }
        }
    }

    private class JobListener
    extends JobInProgressListener {
        private JobListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobAdded(JobInProgress job) {
            FairScheduler fairScheduler = FairScheduler.this;
            synchronized (fairScheduler) {
                FairScheduler.this.eventLog.log("JOB_ADDED", job.getJobID());
                JobInfo info = new JobInfo(new JobSchedulable(FairScheduler.this, job, TaskType.MAP), new JobSchedulable(FairScheduler.this, job, TaskType.REDUCE));
                FairScheduler.this.infos.put(job, info);
                FairScheduler.this.poolMgr.addJob(job);
                FairScheduler.this.update();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobRemoved(JobInProgress job) {
            FairScheduler fairScheduler = FairScheduler.this;
            synchronized (fairScheduler) {
                FairScheduler.this.eventLog.log("JOB_REMOVED", job.getJobID());
                FairScheduler.this.jobNoLongerRunning(job);
                FairScheduler.this.subClusterManager.removeJob(job);
            }
        }

        public void jobUpdated(JobChangeEvent event) {
            JobStatusChangeEvent statusEvent;
            if (event instanceof JobStatusChangeEvent && (statusEvent = (JobStatusChangeEvent)event).getEventType().equals((Object)JobStatusChangeEvent.EventType.RUN_STATE_CHANGED) && statusEvent.getNewStatus().getRunState() == 1) {
                FairScheduler.this.subClusterManager.addJob(event.getJobInProgress());
            }
            FairScheduler.this.eventLog.log("JOB_UPDATED", event.getJobInProgress().getJobID());
        }
    }

    private class MetricsUpdater
    implements Updater {
        private MetricsUpdater() {
        }

        public void doUpdates(MetricsContext context) {
            FairScheduler.this.updateMetrics();
        }
    }

    static class JobInfo {
        boolean runnable = false;
        public JobSchedulable mapSchedulable;
        public JobSchedulable reduceSchedulable;
        LocalityLevel lastMapLocalityLevel;
        long timeWaitedForLocalMap;
        boolean skippedAtLastHeartbeat;

        public JobInfo(JobSchedulable mapSched, JobSchedulable reduceSched) {
            this.mapSchedulable = mapSched;
            this.reduceSchedulable = reduceSched;
            this.lastMapLocalityLevel = LocalityLevel.NODE;
        }
    }
}

