/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.CapacityTaskScheduler;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.TaskType;

class MemoryMatcher {
    private static final Log LOG = LogFactory.getLog(MemoryMatcher.class);
    private CapacityTaskScheduler scheduler;

    public MemoryMatcher(CapacityTaskScheduler capacityTaskScheduler) {
        this.scheduler = capacityTaskScheduler;
    }

    boolean isSchedulingBasedOnMemEnabled() {
        return this.scheduler.getLimitMaxMemForMapSlot() != -1L && this.scheduler.getLimitMaxMemForReduceSlot() != -1L && this.scheduler.getMemSizeForMapSlot() != -1L && this.scheduler.getMemSizeForReduceSlot() != -1L;
    }

    synchronized long getMemReservedForTasks(TaskTrackerStatus taskTracker, TaskType taskType, int availableSlots) {
        int currentlyScheduled = this.currentlyScheduled(taskTracker, taskType, availableSlots);
        long vmem = 0L;
        for (TaskStatus task : taskTracker.getTaskReports()) {
            if (task.getRunState() != TaskStatus.State.RUNNING && task.getRunState() != TaskStatus.State.UNASSIGNED && !task.inTaskCleanupPhase()) continue;
            long myVmem = 0L;
            if (task.getIsMap() && taskType == TaskType.MAP) {
                long memSizePerMapSlot = this.scheduler.getMemSizeForMapSlot();
                myVmem = memSizePerMapSlot * (long)task.getNumSlots();
            } else if (!task.getIsMap() && taskType == TaskType.REDUCE) {
                long memSizePerReduceSlot = this.scheduler.getMemSizeForReduceSlot();
                myVmem = memSizePerReduceSlot * (long)task.getNumSlots();
            }
            vmem += myVmem;
        }
        long currentlyScheduledVMem = (long)currentlyScheduled * (taskType == TaskType.MAP ? this.scheduler.getMemSizeForMapSlot() : this.scheduler.getMemSizeForReduceSlot());
        return vmem + currentlyScheduledVMem;
    }

    private int currentlyScheduled(TaskTrackerStatus taskTracker, TaskType taskType, int availableSlots) {
        int scheduled = 0;
        scheduled = taskType == TaskType.MAP ? taskTracker.getMaxMapSlots() - taskTracker.countOccupiedMapSlots() - availableSlots : taskTracker.getMaxReduceSlots() - taskTracker.countOccupiedReduceSlots() - availableSlots;
        return scheduled;
    }

    boolean matchesMemoryRequirements(JobInProgress job, TaskType taskType, TaskTrackerStatus taskTracker, int availableSlots) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Matching memory requirements of " + job.getJobID().toString() + " for scheduling on " + taskTracker.trackerName));
        }
        if (!this.isSchedulingBasedOnMemEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Scheduling based on job's memory requirements is disabled. Ignoring any value set by job.");
            }
            return true;
        }
        long memUsedOnTT = this.getMemReservedForTasks(taskTracker, taskType, availableSlots);
        long totalMemUsableOnTT = 0L;
        long memForThisTask = 0L;
        if (taskType == TaskType.MAP) {
            memForThisTask = job.getMemoryForMapTask();
            totalMemUsableOnTT = this.scheduler.getMemSizeForMapSlot() * (long)taskTracker.getMaxMapSlots();
        } else if (taskType == TaskType.REDUCE) {
            memForThisTask = job.getMemoryForReduceTask();
            totalMemUsableOnTT = this.scheduler.getMemSizeForReduceSlot() * (long)taskTracker.getMaxReduceSlots();
        }
        long freeMemOnTT = totalMemUsableOnTT - memUsedOnTT;
        if (memForThisTask > freeMemOnTT) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("memForThisTask (" + memForThisTask + ") > freeMemOnTT (" + freeMemOnTT + "). A " + taskType + " task from " + job.getJobID().toString() + " cannot be scheduled on TT " + taskTracker.trackerName));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("memForThisTask = " + memForThisTask + ". freeMemOnTT = " + freeMemOnTT + ". A " + taskType.toString() + " task from " + job.getJobID().toString() + " matches memory requirements " + "on TT " + taskTracker.trackerName));
        }
        return true;
    }
}

