/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Arrays;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.vectorizer.collocations.llr.Gram;
import org.apache.mahout.vectorizer.collocations.llr.GramKey;
import org.junit.Test;

public final class GramKeyTest
extends MahoutTestCase {
    @Test
    public void testGramKeySort() {
        byte[] foo = new byte[]{1};
        byte[] empty = new byte[]{};
        GramKey[] input = new GramKey[]{new GramKey(new Gram("bar", 1, Gram.Type.UNIGRAM), empty), new GramKey(new Gram("bar", 1, Gram.Type.UNIGRAM), empty), new GramKey(new Gram("bar", 1, Gram.Type.UNIGRAM), foo), new GramKey(new Gram("bar", 8, Gram.Type.NGRAM), foo), new GramKey(new Gram("bar", 8, Gram.Type.NGRAM), empty), new GramKey(new Gram("foo", 2, Gram.Type.HEAD), foo), new GramKey(new Gram("foo", 3, Gram.Type.HEAD), empty), new GramKey(new Gram("foo", 4, Gram.Type.TAIL), foo), new GramKey(new Gram("foo", 5, Gram.Type.TAIL), foo), new GramKey(new Gram("bar", 6, Gram.Type.HEAD), foo), new GramKey(new Gram("bar", 7, Gram.Type.TAIL), empty)};
        int[] expect = new int[]{9, 6, 5, 10, 7, 8, 0, 1, 2, 4, 3};
        Object[] sorted = new GramKey[input.length];
        System.arraycopy(input, 0, sorted, 0, input.length);
        Arrays.sort(sorted);
        for (int i = 0; i < input.length; ++i) {
            GramKeyTest.assertSame((Object)input[expect[i]], (Object)sorted[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritable() throws Exception {
        byte[] foo = new byte[]{};
        byte[] bar = new byte[]{2};
        GramKey one = new GramKey(new Gram("foo", 2, Gram.Type.HEAD), foo);
        GramKey two = new GramKey(new Gram("foobar", 3, Gram.Type.UNIGRAM), bar);
        GramKeyTest.assertEquals((Object)"foo", (Object)one.getPrimaryString());
        GramKeyTest.assertEquals((Object)"foobar", (Object)two.getPrimaryString());
        GramKeyTest.assertEquals((Object)Gram.Type.UNIGRAM, (Object)two.getType());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            two.write((DataOutput)out);
        }
        finally {
            Closeables.close((Closeable)out, (boolean)false);
        }
        byte[] b = bout.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        DataInputStream din = new DataInputStream(bin);
        try {
            one.readFields((DataInput)din);
        }
        finally {
            Closeables.close((Closeable)din, (boolean)true);
        }
        GramKeyTest.assertTrue((boolean)Arrays.equals(two.getBytes(), one.getBytes()));
        GramKeyTest.assertEquals((Object)Gram.Type.UNIGRAM, (Object)one.getType());
    }
}

