/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.vectorizer.collocations.llr.CollocReducer;
import org.apache.mahout.vectorizer.collocations.llr.Gram;
import org.apache.mahout.vectorizer.collocations.llr.GramKey;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public final class CollocReducerTest
extends MahoutTestCase {
    private Reducer.Context context;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
    }

    @Test
    public void testReduce() throws Exception {
        Gram[][] values;
        Gram[][] input = new Gram[][]{{new Gram("the", Gram.Type.UNIGRAM), new Gram("the", Gram.Type.UNIGRAM), new Gram("the", Gram.Type.UNIGRAM)}, {new Gram("the", Gram.Type.HEAD), new Gram("the best", Gram.Type.NGRAM), new Gram("the worst", Gram.Type.NGRAM)}, {new Gram("of", Gram.Type.HEAD), new Gram("of times", Gram.Type.NGRAM), new Gram("of times", Gram.Type.NGRAM)}, {new Gram("times", Gram.Type.TAIL), new Gram("of times", Gram.Type.NGRAM), new Gram("of times", Gram.Type.NGRAM)}};
        for (Gram[] v : values = new Gram[][]{{new Gram("the", 2, Gram.Type.UNIGRAM), new Gram("the", 2, Gram.Type.UNIGRAM)}, {new Gram("the best", 1, Gram.Type.NGRAM), new Gram("the", 2, Gram.Type.HEAD)}, {new Gram("the worst", 1, Gram.Type.NGRAM), new Gram("the", 2, Gram.Type.HEAD)}, {new Gram("of times", 2, Gram.Type.NGRAM), new Gram("of", 2, Gram.Type.HEAD)}, {new Gram("of times", 2, Gram.Type.NGRAM), new Gram("times", 2, Gram.Type.TAIL)}}) {
            this.context.write((Object)v[0], (Object)v[1]);
        }
        EasyMock.replay((Object[])new Object[]{this.context});
        CollocReducer c = new CollocReducer();
        GramKey key = new GramKey();
        byte[] empty = new byte[]{};
        for (Gram[] ii : input) {
            key.set(ii[0], empty);
            LinkedList vv = Lists.newLinkedList();
            vv.addAll(Arrays.asList(ii));
            c.reduce(key, (Iterable)vv, this.context);
        }
        EasyMock.verify((Object[])new Object[]{this.context});
    }
}

