/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.net.URI;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterator;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.vectorizer.EncodedVectorsFromSequenceFiles;
import org.apache.mahout.vectorizer.RandomDocumentGenerator;
import org.junit.Before;
import org.junit.Test;

public class EncodedVectorsFromSequenceFilesTest
extends MahoutTestCase {
    private static final int NUM_DOCS = 100;
    private Configuration conf;
    private Path inputPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf = this.getConfiguration();
        this.inputPath = this.getTestTempFilePath("documents/docs.file");
        FileSystem fs = FileSystem.get((URI)this.inputPath.toUri(), (Configuration)this.conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, this.conf, this.inputPath, Text.class, Text.class);
        RandomDocumentGenerator gen = new RandomDocumentGenerator();
        try {
            for (int i = 0; i < 100; ++i) {
                writer.append((Writable)new Text("Document::ID::" + i), (Writable)new Text(gen.getRandomDocument()));
            }
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
    }

    @Test
    public void testCreate() throws Exception {
        this.runTest(false, false);
    }

    @Test
    public void testCreateNamed() throws Exception {
        this.runTest(false, true);
    }

    @Test
    public void testCreateSeq() throws Exception {
        this.runTest(true, false);
    }

    @Test
    public void testCreateSeqNamed() throws Exception {
        this.runTest(true, true);
    }

    private void runTest(boolean sequential, boolean named) throws Exception {
        Path tmpPath = this.getTestTempDirPath();
        Path outputPath = new Path(tmpPath, "output");
        LinkedList argList = Lists.newLinkedList();
        argList.add("-i");
        argList.add(this.inputPath.toString());
        argList.add("-o");
        argList.add(outputPath.toString());
        if (sequential) {
            argList.add("-seq");
        }
        if (named) {
            argList.add("-nv");
        }
        String[] args = argList.toArray(new String[argList.size()]);
        ToolRunner.run((Configuration)this.getConfiguration(), (Tool)new EncodedVectorsFromSequenceFiles(), (String[])args);
        SequenceFileDirIterator iter = new SequenceFileDirIterator(outputPath, PathType.LIST, PathFilters.partFilter(), null, true, this.conf);
        int seen = 0;
        while (iter.hasNext()) {
            Pair next = (Pair)iter.next();
            if (sequential && !named) {
                EncodedVectorsFromSequenceFilesTest.assertTrue((boolean)(((VectorWritable)next.getSecond()).get() instanceof SequentialAccessSparseVector));
            } else if (named) {
                EncodedVectorsFromSequenceFilesTest.assertTrue((boolean)(((VectorWritable)next.getSecond()).get() instanceof NamedVector));
            }
            ++seen;
        }
        EncodedVectorsFromSequenceFilesTest.assertEquals((String)"Missed some vectors", (long)100L, (long)seen);
    }
}

