/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.solver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.hadoop.TestDistributedRowMatrix;
import org.apache.mahout.math.hadoop.solver.DistributedConjugateGradientSolver;
import org.junit.Test;

public final class TestDistributedConjugateGradientSolverCLI
extends MahoutTestCase {
    private static Vector randomVector(int size, double entryMean) {
        DenseVector v = new DenseVector(size);
        RandomWrapper r = RandomUtils.getRandom();
        for (int i = 0; i < size; ++i) {
            v.setQuick(i, r.nextGaussian() * entryMean);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path saveVector(Configuration conf, Path path, Vector v) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        try (SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, path, IntWritable.class, VectorWritable.class);){
            writer.append((Writable)new IntWritable(0), (Writable)new VectorWritable(v));
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector loadVector(Configuration conf, Path path) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, conf);
        IntWritable key = new IntWritable();
        VectorWritable value = new VectorWritable();
        try {
            if (!reader.next((Writable)key, (Writable)value)) {
                throw new IOException("Input vector file is empty.");
            }
            Vector vector = value.get();
            return vector;
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testSolver() throws Exception {
        Configuration conf = this.getConfiguration();
        Path testData = this.getTestTempDirPath("testdata");
        DistributedRowMatrix matrix = new TestDistributedRowMatrix().randomDistributedMatrix(10, 10, 10, 10, 10.0, true, testData.toString());
        matrix.setConf(conf);
        Path output = this.getTestTempFilePath("output");
        Path vectorPath = this.getTestTempFilePath("vector");
        Path tempPath = this.getTestTempDirPath("tmp");
        Vector vector = TestDistributedConjugateGradientSolverCLI.randomVector(matrix.numCols(), 10.0);
        TestDistributedConjugateGradientSolverCLI.saveVector(conf, vectorPath, vector);
        String[] args = new String[]{"-i", matrix.getRowPath().toString(), "-o", output.toString(), "--tempDir", tempPath.toString(), "--vector", vectorPath.toString(), "--numRows", "10", "--numCols", "10", "--symmetric", "true"};
        DistributedConjugateGradientSolver solver = new DistributedConjugateGradientSolver();
        ToolRunner.run((Configuration)this.getConfiguration(), (Tool)solver.job(), (String[])args);
        Vector x = TestDistributedConjugateGradientSolverCLI.loadVector(conf, output);
        Vector solvedVector = matrix.times(x);
        double distance = Math.sqrt(vector.getDistanceSquared(solvedVector));
        TestDistributedConjugateGradientSolverCLI.assertEquals((double)0.0, (double)distance, (double)1.0E-6);
    }
}

