/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.mahout.clustering.ClusteringTestUtils;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.decomposer.SolverTest;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.hadoop.MatrixMultiplicationJob;
import org.apache.mahout.math.hadoop.TimesSquaredJob;
import org.apache.mahout.math.hadoop.TransposeJob;
import org.junit.Test;

public final class TestDistributedRowMatrix
extends MahoutTestCase {
    public static final String TEST_PROPERTY_KEY = "test.property.key";
    public static final String TEST_PROPERTY_VALUE = "test.property.value";

    private static void assertEquals(VectorIterable m, VectorIterable mtt, double errorTolerance) {
        Iterator mIt = m.iterateAll();
        Iterator mttIt = mtt.iterateAll();
        HashMap mMap = Maps.newHashMap();
        HashMap mttMap = Maps.newHashMap();
        while (mIt.hasNext() && mttIt.hasNext()) {
            MatrixSlice ms = (MatrixSlice)mIt.next();
            mMap.put(ms.index(), ms.vector());
            MatrixSlice mtts = (MatrixSlice)mttIt.next();
            mttMap.put(mtts.index(), mtts.vector());
        }
        for (Map.Entry entry : mMap.entrySet()) {
            Integer key = (Integer)entry.getKey();
            Vector value = (Vector)entry.getValue();
            if (value == null || mttMap.get(key) == null) {
                TestDistributedRowMatrix.assertTrue((value == null || value.norm(2.0) == 0.0 ? 1 : 0) != 0);
                TestDistributedRowMatrix.assertTrue((mttMap.get(key) == null || ((Vector)mttMap.get(key)).norm(2.0) == 0.0 ? 1 : 0) != 0);
                continue;
            }
            TestDistributedRowMatrix.assertTrue((value.getDistanceSquared((Vector)mttMap.get(key)) < errorTolerance ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTranspose() throws Exception {
        DistributedRowMatrix m = this.randomDistributedMatrix(10, 9, 5, 4, 1.0, false);
        m.setConf(this.getConfiguration());
        DistributedRowMatrix mt = m.transpose();
        mt.setConf(this.getConfiguration());
        Path tmpPath = this.getTestTempDirPath();
        m.setOutputTempPathString(tmpPath.toString());
        Path tmpOutPath = new Path(tmpPath, "/tmpOutTranspose");
        mt.setOutputTempPathString(tmpOutPath.toString());
        HadoopUtil.delete((Configuration)this.getConfiguration(), (Path[])new Path[]{tmpOutPath});
        DistributedRowMatrix mtt = mt.transpose();
        TestDistributedRowMatrix.assertEquals((VectorIterable)m, (VectorIterable)mtt, 1.0E-6);
    }

    @Test
    public void testMatrixColumnMeansJob() throws Exception {
        Matrix m = SolverTest.randomSequentialAccessSparseMatrix((int)100, (int)90, (int)50, (int)20, (double)1.0);
        DistributedRowMatrix dm = this.randomDistributedMatrix(100, 90, 50, 20, 1.0, false);
        dm.setConf(this.getConfiguration());
        DenseVector expected = new DenseVector(50);
        for (int i = 0; i < m.numRows(); ++i) {
            expected.assign(m.viewRow(i), Functions.PLUS);
        }
        expected.assign(Functions.DIV, (double)m.numRows());
        Vector actual = dm.columnMeans("DenseVector");
        TestDistributedRowMatrix.assertEquals((double)0.0, (double)expected.getDistanceSquared(actual), (double)1.0E-6);
    }

    @Test
    public void testNullMatrixColumnMeansJob() throws Exception {
        Matrix m = SolverTest.randomSequentialAccessSparseMatrix((int)100, (int)90, (int)0, (int)0, (double)1.0);
        DistributedRowMatrix dm = this.randomDistributedMatrix(100, 90, 0, 0, 1.0, false);
        dm.setConf(this.getConfiguration());
        DenseVector expected = new DenseVector(0);
        for (int i = 0; i < m.numRows(); ++i) {
            expected.assign(m.viewRow(i), Functions.PLUS);
        }
        expected.assign(Functions.DIV, (double)m.numRows());
        Vector actual = dm.columnMeans();
        TestDistributedRowMatrix.assertEquals((double)0.0, (double)expected.getDistanceSquared(actual), (double)1.0E-6);
    }

    @Test
    public void testMatrixTimesVector() throws Exception {
        RandomAccessSparseVector v = new RandomAccessSparseVector(50);
        v.assign(1.0);
        Matrix m = SolverTest.randomSequentialAccessSparseMatrix((int)100, (int)90, (int)50, (int)20, (double)1.0);
        DistributedRowMatrix dm = this.randomDistributedMatrix(100, 90, 50, 20, 1.0, false);
        dm.setConf(this.getConfiguration());
        Vector expected = m.times((Vector)v);
        Vector actual = dm.times((Vector)v);
        TestDistributedRowMatrix.assertEquals((double)0.0, (double)expected.getDistanceSquared(actual), (double)1.0E-6);
    }

    @Test
    public void testMatrixTimesSquaredVector() throws Exception {
        RandomAccessSparseVector v = new RandomAccessSparseVector(50);
        v.assign(1.0);
        Matrix m = SolverTest.randomSequentialAccessSparseMatrix((int)100, (int)90, (int)50, (int)20, (double)1.0);
        DistributedRowMatrix dm = this.randomDistributedMatrix(100, 90, 50, 20, 1.0, false);
        dm.setConf(this.getConfiguration());
        Vector expected = m.timesSquared((Vector)v);
        Vector actual = dm.timesSquared((Vector)v);
        TestDistributedRowMatrix.assertEquals((double)0.0, (double)expected.getDistanceSquared(actual), (double)1.0E-9);
    }

    @Test
    public void testMatrixTimesMatrix() throws Exception {
        Matrix inputA = SolverTest.randomSequentialAccessSparseMatrix((int)20, (int)19, (int)15, (int)5, (double)10.0);
        Matrix inputB = SolverTest.randomSequentialAccessSparseMatrix((int)20, (int)13, (int)25, (int)10, (double)5.0);
        Matrix expected = inputA.transpose().times(inputB);
        DistributedRowMatrix distA = this.randomDistributedMatrix(20, 19, 15, 5, 10.0, false, "distA");
        distA.setConf(this.getConfiguration());
        DistributedRowMatrix distB = this.randomDistributedMatrix(20, 13, 25, 10, 5.0, false, "distB");
        distB.setConf(this.getConfiguration());
        DistributedRowMatrix product = distA.times(distB);
        TestDistributedRowMatrix.assertEquals((VectorIterable)expected, (VectorIterable)product, 1.0E-6);
    }

    @Test
    public void testMatrixMultiplactionJobConfBuilder() throws Exception {
        Configuration initialConf = this.createInitialConf();
        Path baseTmpDirPath = this.getTestTempDirPath("testpaths");
        Path aPath = new Path(baseTmpDirPath, "a");
        Path bPath = new Path(baseTmpDirPath, "b");
        Path outPath = new Path(baseTmpDirPath, "out");
        Configuration mmJobConf = MatrixMultiplicationJob.createMatrixMultiplyJobConf((Path)aPath, (Path)bPath, (Path)outPath, (int)10);
        Configuration mmCustomJobConf = MatrixMultiplicationJob.createMatrixMultiplyJobConf((Configuration)initialConf, (Path)aPath, (Path)bPath, (Path)outPath, (int)10);
        TestDistributedRowMatrix.assertNull((Object)mmJobConf.get(TEST_PROPERTY_KEY));
        TestDistributedRowMatrix.assertEquals((Object)TEST_PROPERTY_VALUE, (Object)mmCustomJobConf.get(TEST_PROPERTY_KEY));
    }

    @Test
    public void testTransposeJobConfBuilder() throws Exception {
        Configuration initialConf = this.createInitialConf();
        Path baseTmpDirPath = this.getTestTempDirPath("testpaths");
        Path inputPath = new Path(baseTmpDirPath, "input");
        Path outputPath = new Path(baseTmpDirPath, "output");
        Configuration transposeJobConf = TransposeJob.buildTransposeJob((Path)inputPath, (Path)outputPath, (int)10).getConfiguration();
        Configuration transposeCustomJobConf = TransposeJob.buildTransposeJob((Configuration)initialConf, (Path)inputPath, (Path)outputPath, (int)10).getConfiguration();
        TestDistributedRowMatrix.assertNull((Object)transposeJobConf.get(TEST_PROPERTY_KEY));
        TestDistributedRowMatrix.assertEquals((Object)TEST_PROPERTY_VALUE, (Object)transposeCustomJobConf.get(TEST_PROPERTY_KEY));
    }

    @Test
    public void testTimesSquaredJobConfBuilders() throws Exception {
        Configuration initialConf = this.createInitialConf();
        Path baseTmpDirPath = this.getTestTempDirPath("testpaths");
        Path inputPath = new Path(baseTmpDirPath, "input");
        Path outputPath = new Path(baseTmpDirPath, "output");
        RandomAccessSparseVector v = new RandomAccessSparseVector(50);
        v.assign(1.0);
        Job timesSquaredJob1 = TimesSquaredJob.createTimesSquaredJob((Vector)v, (Path)inputPath, (Path)outputPath);
        Job customTimesSquaredJob1 = TimesSquaredJob.createTimesSquaredJob((Configuration)initialConf, (Vector)v, (Path)inputPath, (Path)outputPath);
        TestDistributedRowMatrix.assertNull((Object)timesSquaredJob1.getConfiguration().get(TEST_PROPERTY_KEY));
        TestDistributedRowMatrix.assertEquals((Object)TEST_PROPERTY_VALUE, (Object)customTimesSquaredJob1.getConfiguration().get(TEST_PROPERTY_KEY));
        Job timesJob = TimesSquaredJob.createTimesJob((Vector)v, (int)50, (Path)inputPath, (Path)outputPath);
        Job customTimesJob = TimesSquaredJob.createTimesJob((Configuration)initialConf, (Vector)v, (int)50, (Path)inputPath, (Path)outputPath);
        TestDistributedRowMatrix.assertNull((Object)timesJob.getConfiguration().get(TEST_PROPERTY_KEY));
        TestDistributedRowMatrix.assertEquals((Object)TEST_PROPERTY_VALUE, (Object)customTimesJob.getConfiguration().get(TEST_PROPERTY_KEY));
        Job timesSquaredJob2 = TimesSquaredJob.createTimesSquaredJob((Vector)v, (Path)inputPath, (Path)outputPath, TimesSquaredJob.TimesSquaredMapper.class, TimesSquaredJob.VectorSummingReducer.class);
        Job customTimesSquaredJob2 = TimesSquaredJob.createTimesSquaredJob((Configuration)initialConf, (Vector)v, (Path)inputPath, (Path)outputPath, TimesSquaredJob.TimesSquaredMapper.class, TimesSquaredJob.VectorSummingReducer.class);
        TestDistributedRowMatrix.assertNull((Object)timesSquaredJob2.getConfiguration().get(TEST_PROPERTY_KEY));
        TestDistributedRowMatrix.assertEquals((Object)TEST_PROPERTY_VALUE, (Object)customTimesSquaredJob2.getConfiguration().get(TEST_PROPERTY_KEY));
        Job timesSquaredJob3 = TimesSquaredJob.createTimesSquaredJob((Vector)v, (int)50, (Path)inputPath, (Path)outputPath, TimesSquaredJob.TimesSquaredMapper.class, TimesSquaredJob.VectorSummingReducer.class);
        Job customTimesSquaredJob3 = TimesSquaredJob.createTimesSquaredJob((Configuration)initialConf, (Vector)v, (int)50, (Path)inputPath, (Path)outputPath, TimesSquaredJob.TimesSquaredMapper.class, TimesSquaredJob.VectorSummingReducer.class);
        TestDistributedRowMatrix.assertNull((Object)timesSquaredJob3.getConfiguration().get(TEST_PROPERTY_KEY));
        TestDistributedRowMatrix.assertEquals((Object)TEST_PROPERTY_VALUE, (Object)customTimesSquaredJob3.getConfiguration().get(TEST_PROPERTY_KEY));
    }

    @Test
    public void testTimesVectorTempDirDeletion() throws Exception {
        Configuration conf = this.getConfiguration();
        RandomAccessSparseVector v = new RandomAccessSparseVector(50);
        v.assign(1.0);
        DistributedRowMatrix dm = this.randomDistributedMatrix(100, 90, 50, 20, 1.0, false);
        dm.setConf(conf);
        Path outputPath = dm.getOutputTempPath();
        FileSystem fs = outputPath.getFileSystem(conf);
        TestDistributedRowMatrix.deleteContentsOfPath(conf, outputPath);
        TestDistributedRowMatrix.assertEquals((long)0L, (long)HadoopUtil.listStatus((FileSystem)fs, (Path)outputPath).length);
        Vector result1 = dm.times((Vector)v);
        TestDistributedRowMatrix.assertEquals((long)0L, (long)HadoopUtil.listStatus((FileSystem)fs, (Path)outputPath).length);
        TestDistributedRowMatrix.deleteContentsOfPath(conf, outputPath);
        TestDistributedRowMatrix.assertEquals((long)0L, (long)HadoopUtil.listStatus((FileSystem)fs, (Path)outputPath).length);
        conf.setBoolean("DistributedMatrix.keep.temp.files", true);
        dm.setConf(conf);
        Vector result2 = dm.times((Vector)v);
        FileStatus[] outputStatuses = fs.listStatus(outputPath);
        TestDistributedRowMatrix.assertEquals((long)1L, (long)outputStatuses.length);
        Path outputTempPath = outputStatuses[0].getPath();
        Path inputVectorPath = new Path(outputTempPath, "DistributedMatrix.times.inputVector");
        Path outputVectorPath = new Path(outputTempPath, "DistributedMatrix.times.outputVector");
        TestDistributedRowMatrix.assertEquals((long)1L, (long)fs.listStatus(inputVectorPath, PathFilters.logsCRCFilter()).length);
        TestDistributedRowMatrix.assertEquals((long)1L, (long)fs.listStatus(outputVectorPath, PathFilters.logsCRCFilter()).length);
        TestDistributedRowMatrix.assertEquals((double)0.0, (double)result1.getDistanceSquared(result2), (double)1.0E-6);
    }

    @Test
    public void testTimesSquaredVectorTempDirDeletion() throws Exception {
        Configuration conf = this.getConfiguration();
        RandomAccessSparseVector v = new RandomAccessSparseVector(50);
        v.assign(1.0);
        DistributedRowMatrix dm = this.randomDistributedMatrix(100, 90, 50, 20, 1.0, false);
        dm.setConf(this.getConfiguration());
        Path outputPath = dm.getOutputTempPath();
        FileSystem fs = outputPath.getFileSystem(conf);
        TestDistributedRowMatrix.deleteContentsOfPath(conf, outputPath);
        TestDistributedRowMatrix.assertEquals((long)0L, (long)HadoopUtil.listStatus((FileSystem)fs, (Path)outputPath).length);
        Vector result1 = dm.timesSquared((Vector)v);
        TestDistributedRowMatrix.assertEquals((long)0L, (long)HadoopUtil.listStatus((FileSystem)fs, (Path)outputPath).length);
        TestDistributedRowMatrix.deleteContentsOfPath(conf, outputPath);
        TestDistributedRowMatrix.assertEquals((long)0L, (long)HadoopUtil.listStatus((FileSystem)fs, (Path)outputPath).length);
        conf.setBoolean("DistributedMatrix.keep.temp.files", true);
        dm.setConf(conf);
        Vector result2 = dm.timesSquared((Vector)v);
        FileStatus[] outputStatuses = fs.listStatus(outputPath);
        TestDistributedRowMatrix.assertEquals((long)1L, (long)outputStatuses.length);
        Path outputTempPath = outputStatuses[0].getPath();
        Path inputVectorPath = new Path(outputTempPath, "DistributedMatrix.times.inputVector");
        Path outputVectorPath = new Path(outputTempPath, "DistributedMatrix.times.outputVector");
        TestDistributedRowMatrix.assertEquals((long)1L, (long)fs.listStatus(inputVectorPath, PathFilters.logsCRCFilter()).length);
        TestDistributedRowMatrix.assertEquals((long)1L, (long)fs.listStatus(outputVectorPath, PathFilters.logsCRCFilter()).length);
        TestDistributedRowMatrix.assertEquals((double)0.0, (double)result1.getDistanceSquared(result2), (double)1.0E-6);
    }

    public Configuration createInitialConf() throws IOException {
        Configuration initialConf = this.getConfiguration();
        initialConf.set(TEST_PROPERTY_KEY, TEST_PROPERTY_VALUE);
        return initialConf;
    }

    private static void deleteContentsOfPath(Configuration conf, Path path) throws Exception {
        FileStatus[] statuses;
        FileSystem fs = path.getFileSystem(conf);
        for (FileStatus status : statuses = HadoopUtil.listStatus((FileSystem)fs, (Path)path)) {
            fs.delete(status.getPath(), true);
        }
    }

    public DistributedRowMatrix randomDistributedMatrix(int numRows, int nonNullRows, int numCols, int entriesPerRow, double entryMean, boolean isSymmetric) throws IOException {
        return this.randomDistributedMatrix(numRows, nonNullRows, numCols, entriesPerRow, entryMean, isSymmetric, "testdata");
    }

    public DistributedRowMatrix randomDenseHierarchicalDistributedMatrix(int numRows, int numCols, boolean isSymmetric, String baseTmpDirSuffix) throws IOException {
        Path baseTmpDirPath = this.getTestTempDirPath(baseTmpDirSuffix);
        Matrix c = SolverTest.randomHierarchicalMatrix((int)numRows, (int)numCols, (boolean)isSymmetric);
        return this.saveToFs(c, baseTmpDirPath);
    }

    public DistributedRowMatrix randomDistributedMatrix(int numRows, int nonNullRows, int numCols, int entriesPerRow, double entryMean, boolean isSymmetric, String baseTmpDirSuffix) throws IOException {
        Path baseTmpDirPath = this.getTestTempDirPath(baseTmpDirSuffix);
        Matrix c = SolverTest.randomSequentialAccessSparseMatrix((int)numRows, (int)nonNullRows, (int)numCols, (int)entriesPerRow, (double)entryMean);
        if (isSymmetric) {
            c = c.times(c.transpose());
        }
        return this.saveToFs(c, baseTmpDirPath);
    }

    private DistributedRowMatrix saveToFs(final Matrix m, Path baseTmpDirPath) throws IOException {
        Configuration conf = this.getConfiguration();
        FileSystem fs = FileSystem.get((URI)baseTmpDirPath.toUri(), (Configuration)conf);
        ClusteringTestUtils.writePointsToFile(new Iterable<VectorWritable>(){

            @Override
            public Iterator<VectorWritable> iterator() {
                return Iterators.transform((Iterator)m.iterator(), (Function)new Function<MatrixSlice, VectorWritable>(){

                    public VectorWritable apply(MatrixSlice input) {
                        return new VectorWritable(input.vector());
                    }
                });
            }
        }, true, new Path(baseTmpDirPath, "distMatrix/part-00000"), fs, conf);
        DistributedRowMatrix distMatrix = new DistributedRowMatrix(new Path(baseTmpDirPath, "distMatrix"), new Path(baseTmpDirPath, "tmpOut"), m.numRows(), m.numCols());
        distMatrix.setConf(new Configuration(conf));
        return distMatrix;
    }
}

