/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.distance.MahalanobisDistanceMeasure;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public final class TestMahalanobisDistanceMeasure
extends MahoutTestCase {
    @Test
    public void testMeasure() {
        double[][] invCovValues = new double[][]{{2.2, 0.4}, {0.4, 2.8}};
        double[] meanValues = new double[]{-2.3, -0.9};
        DenseMatrix invCov = new DenseMatrix((double[][])invCovValues);
        DenseVector meanVector = new DenseVector(meanValues);
        MahalanobisDistanceMeasure distanceMeasure = new MahalanobisDistanceMeasure();
        distanceMeasure.setInverseCovarianceMatrix((Matrix)invCov);
        distanceMeasure.setMeanVector((Vector)meanVector);
        double[] v1 = new double[]{-1.9, -2.3};
        double[] v2 = new double[]{-2.9, -1.3};
        double dist = distanceMeasure.distance((Vector)new DenseVector(v1), (Vector)new DenseVector(v2));
        TestMahalanobisDistanceMeasure.assertEquals((double)2.0493901531919194, (double)dist, (double)1.0E-6);
        distanceMeasure.setCovarianceMatrix((Matrix)invCov);
        Matrix identity = distanceMeasure.getInverseCovarianceMatrix().times((Matrix)invCov);
        TestMahalanobisDistanceMeasure.assertEquals((double)1.0, (double)identity.get(0, 0), (double)1.0E-6);
        TestMahalanobisDistanceMeasure.assertEquals((double)1.0, (double)identity.get(1, 1), (double)1.0E-6);
        TestMahalanobisDistanceMeasure.assertEquals((double)0.0, (double)identity.get(1, 0), (double)1.0E-6);
        TestMahalanobisDistanceMeasure.assertEquals((double)0.0, (double)identity.get(0, 1), (double)1.0E-6);
    }
}

