/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.distance.ChebyshevDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public final class TestChebyshevMeasure
extends MahoutTestCase {
    @Test
    public void testMeasure() {
        int b;
        int a;
        ChebyshevDistanceMeasure chebyshevDistanceMeasure = new ChebyshevDistanceMeasure();
        Vector[] vectors = new Vector[]{new DenseVector(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}), new DenseVector(new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0}), new DenseVector(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0})};
        double[][] distances = new double[][]{{0.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 0.0}};
        double[][] chebyshevDistanceMatrix = new double[3][3];
        for (a = 0; a < 3; ++a) {
            for (b = 0; b < 3; ++b) {
                chebyshevDistanceMatrix[a][b] = chebyshevDistanceMeasure.distance(vectors[a], vectors[b]);
            }
        }
        for (a = 0; a < 3; ++a) {
            for (b = 0; b < 3; ++b) {
                TestChebyshevMeasure.assertEquals((double)distances[a][b], (double)chebyshevDistanceMatrix[a][b], (double)1.0E-6);
            }
        }
        TestChebyshevMeasure.assertEquals((double)0.0, (double)chebyshevDistanceMatrix[0][0], (double)1.0E-6);
    }
}

