/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.mahout.common.DummyStatusReporter;
import org.apache.mahout.common.MockIterator;

public final class DummyRecordWriter<K extends Writable, V extends Writable>
extends RecordWriter<K, V> {
    private final List<K> keysInInsertionOrder = Lists.newArrayList();
    private final Map<K, List<V>> data = Maps.newHashMap();

    public void write(K key, V value) {
        try {
            K keyToUse = key instanceof NullWritable ? key : this.cloneWritable((Writable)key);
            Writable valueToUse = this.cloneWritable((Writable)value);
            this.keysInInsertionOrder.add(keyToUse);
            ArrayList points = this.data.get(key);
            if (points == null) {
                points = Lists.newArrayList();
                this.data.put(keyToUse, points);
            }
            points.add(valueToUse);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Writable cloneWritable(Writable original) throws IOException {
        Writable clone;
        try {
            clone = original.getClass().asSubclass(Writable.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate writable!", e);
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        original.write((DataOutput)new DataOutputStream(bytes));
        clone.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytes.toByteArray())));
        return clone;
    }

    public void close(TaskAttemptContext context) {
    }

    public Map<K, List<V>> getData() {
        return this.data;
    }

    public List<V> getValue(K key) {
        return this.data.get(key);
    }

    public Set<K> getKeys() {
        return this.data.keySet();
    }

    public Iterable<K> getKeysInInsertionOrder() {
        return this.keysInInsertionOrder;
    }

    public static <K1, V1, K2, V2> Mapper.Context build(Mapper<K1, V1, K2, V2> mapper, Configuration configuration, RecordWriter<K2, V2> output) {
        try {
            return DummyRecordWriter.buildNewMapperContext(configuration, output);
        }
        catch (Exception | IncompatibleClassChangeError e) {
            try {
                return DummyRecordWriter.buildOldMapperContext(mapper, configuration, output);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public static <K1, V1, K2, V2> Reducer.Context build(Reducer<K1, V1, K2, V2> reducer, Configuration configuration, RecordWriter<K2, V2> output, Class<K1> keyClass, Class<V1> valueClass) {
        try {
            return DummyRecordWriter.buildNewReducerContext(configuration, output, keyClass, valueClass);
        }
        catch (Exception | IncompatibleClassChangeError e) {
            try {
                return DummyRecordWriter.buildOldReducerContext(reducer, configuration, output, keyClass, valueClass);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static <K1, V1, K2, V2> Mapper.Context buildNewMapperContext(Configuration configuration, RecordWriter<K2, V2> output) throws Exception {
        Class<?> mapContextImplClass = Class.forName("org.apache.hadoop.mapreduce.task.MapContextImpl");
        Constructor<?> cons = mapContextImplClass.getConstructors()[0];
        Object mapContextImpl = cons.newInstance(new Object[]{configuration, new TaskAttemptID(), null, output, null, new DummyStatusReporter(), null});
        Class<?> wrappedMapperClass = Class.forName("org.apache.hadoop.mapreduce.lib.map.WrappedMapper");
        Object wrappedMapper = wrappedMapperClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        Method getMapContext = wrappedMapperClass.getMethod("getMapContext", MapContext.class);
        return (Mapper.Context)getMapContext.invoke(wrappedMapper, mapContextImpl);
    }

    private static <K1, V1, K2, V2> Mapper.Context buildOldMapperContext(Mapper<K1, V1, K2, V2> mapper, Configuration configuration, RecordWriter<K2, V2> output) throws Exception {
        Constructor<?> cons = DummyRecordWriter.getNestedContextConstructor(mapper.getClass());
        return (Mapper.Context)cons.newInstance(new Object[]{mapper, configuration, new TaskAttemptID(), null, output, null, new DummyStatusReporter(), null});
    }

    private static <K1, V1, K2, V2> Reducer.Context buildNewReducerContext(Configuration configuration, RecordWriter<K2, V2> output, Class<K1> keyClass, Class<V1> valueClass) throws Exception {
        Class<?> reduceContextImplClass = Class.forName("org.apache.hadoop.mapreduce.task.ReduceContextImpl");
        Constructor<?> cons = reduceContextImplClass.getConstructors()[0];
        Object reduceContextImpl = cons.newInstance(new Object[]{configuration, new TaskAttemptID(), new MockIterator(), null, null, output, null, new DummyStatusReporter(), null, keyClass, valueClass});
        Class<?> wrappedReducerClass = Class.forName("org.apache.hadoop.mapreduce.lib.reduce.WrappedReducer");
        Object wrappedReducer = wrappedReducerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        Method getReducerContext = wrappedReducerClass.getMethod("getReducerContext", ReduceContext.class);
        return (Reducer.Context)getReducerContext.invoke(wrappedReducer, reduceContextImpl);
    }

    private static <K1, V1, K2, V2> Reducer.Context buildOldReducerContext(Reducer<K1, V1, K2, V2> reducer, Configuration configuration, RecordWriter<K2, V2> output, Class<K1> keyClass, Class<V1> valueClass) throws Exception {
        Constructor<?> cons = DummyRecordWriter.getNestedContextConstructor(reducer.getClass());
        return (Reducer.Context)cons.newInstance(new Object[]{reducer, configuration, new TaskAttemptID(), new MockIterator(), null, null, output, null, new DummyStatusReporter(), null, keyClass, valueClass});
    }

    private static Constructor<?> getNestedContextConstructor(Class<?> outerClass) {
        for (Class<?> nestedClass : outerClass.getClasses()) {
            if (!"Context".equals(nestedClass.getSimpleName())) continue;
            return nestedClass.getConstructors()[0];
        }
        throw new IllegalStateException("Cannot find context class for " + outerClass);
    }
}

