/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.topdown.postprocessor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.mahout.clustering.ClusteringTestUtils;
import org.apache.mahout.clustering.canopy.CanopyDriver;
import org.apache.mahout.clustering.topdown.PathDirectory;
import org.apache.mahout.clustering.topdown.postprocessor.ClusterOutputPostProcessor;
import org.apache.mahout.common.DummyOutputCollector;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ClusterOutputPostProcessorTest
extends MahoutTestCase {
    private static final double[][] REFERENCE = new double[][]{{1.0, 1.0}, {2.0, 1.0}, {1.0, 2.0}, {4.0, 4.0}, {5.0, 4.0}, {4.0, 5.0}, {5.0, 5.0}};
    private FileSystem fs;
    private Path outputPath;
    private Configuration conf;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration conf = this.getConfiguration();
        this.fs = FileSystem.get((Configuration)conf);
    }

    private static List<VectorWritable> getPointsWritable(double[][] raw) {
        ArrayList points = Lists.newArrayList();
        for (double[] fr : raw) {
            RandomAccessSparseVector vec = new RandomAccessSparseVector(fr.length);
            vec.assign(fr);
            points.add(new VectorWritable((Vector)vec));
        }
        return points;
    }

    @Test
    public void testTopDownClustering() throws Exception {
        List<VectorWritable> points = ClusterOutputPostProcessorTest.getPointsWritable(REFERENCE);
        Path pointsPath = this.getTestTempDirPath("points");
        this.conf = this.getConfiguration();
        ClusteringTestUtils.writePointsToFile(points, new Path(pointsPath, "file1"), this.fs, this.conf);
        ClusteringTestUtils.writePointsToFile(points, new Path(pointsPath, "file2"), this.fs, this.conf);
        this.outputPath = this.getTestTempDirPath("output");
        this.topLevelClustering(pointsPath, this.conf);
        Map<String, Path> postProcessedClusterDirectories = this.ouputPostProcessing(this.conf);
        this.assertPostProcessedOutput(postProcessedClusterDirectories);
        this.bottomLevelClustering(postProcessedClusterDirectories);
    }

    private void assertTopLevelCluster(Map.Entry<String, Path> cluster) {
        String clusterId = cluster.getKey();
        Path clusterPath = cluster.getValue();
        try {
            if ("0".equals(clusterId)) {
                this.assertPointsInFirstTopLevelCluster(clusterPath);
            } else if ("1".equals(clusterId)) {
                this.assertPointsInSecondTopLevelCluster(clusterPath);
            }
        }
        catch (IOException e) {
            Assert.fail((String)"Exception occurred while asserting top level cluster.");
        }
    }

    private void assertPointsInFirstTopLevelCluster(Path clusterPath) throws IOException {
        List<Vector> vectorsInCluster = this.getVectorsInCluster(clusterPath);
        for (Vector vector : vectorsInCluster) {
            Assert.assertTrue((boolean)ArrayUtils.contains((Object[])new String[]{"{0:1.0,1:1.0}", "{0:2.0,1:1.0}", "{0:1.0,1:2.0}"}, (Object)vector.asFormatString()));
        }
    }

    private void assertPointsInSecondTopLevelCluster(Path clusterPath) throws IOException {
        List<Vector> vectorsInCluster = this.getVectorsInCluster(clusterPath);
        for (Vector vector : vectorsInCluster) {
            Assert.assertTrue((boolean)ArrayUtils.contains((Object[])new String[]{"{0:4.0,1:4.0}", "{0:5.0,1:4.0}", "{0:4.0,1:5.0}", "{0:5.0,1:5.0}"}, (Object)vector.asFormatString()));
        }
    }

    private List<Vector> getVectorsInCluster(Path clusterPath) throws IOException {
        Path[] partFilePaths = FileUtil.stat2Paths((FileStatus[])this.fs.globStatus(clusterPath));
        FileStatus[] listStatus = this.fs.listStatus(partFilePaths);
        ArrayList vectors = Lists.newArrayList();
        for (FileStatus partFile : listStatus) {
            SequenceFile.Reader topLevelClusterReader = new SequenceFile.Reader(this.fs, partFile.getPath(), this.conf);
            LongWritable clusterIdAsKey = new LongWritable();
            VectorWritable point = new VectorWritable();
            while (topLevelClusterReader.next((Writable)clusterIdAsKey, (Writable)point)) {
                vectors.add(point.get());
            }
        }
        return vectors;
    }

    private void bottomLevelClustering(Map<String, Path> postProcessedClusterDirectories) throws IOException, InterruptedException, ClassNotFoundException {
        for (Map.Entry<String, Path> topLevelCluster : postProcessedClusterDirectories.entrySet()) {
            String clusterId = topLevelCluster.getKey();
            Path topLevelclusterPath = topLevelCluster.getValue();
            Path bottomLevelCluster = PathDirectory.getBottomLevelClusterPath((Path)this.outputPath, (String)clusterId);
            CanopyDriver.run((Configuration)this.conf, (Path)topLevelclusterPath, (Path)bottomLevelCluster, (DistanceMeasure)new ManhattanDistanceMeasure(), (double)2.1, (double)2.0, (boolean)true, (double)0.0, (boolean)true);
            this.assertBottomLevelCluster(bottomLevelCluster);
        }
    }

    private void assertBottomLevelCluster(Path bottomLevelCluster) {
        Path clusteredPointsPath = new Path(bottomLevelCluster, "clusteredPoints");
        DummyOutputCollector<WritableComparable, Writable> collector = new DummyOutputCollector<WritableComparable, Writable>();
        for (Pair record : new SequenceFileIterable(new Path(clusteredPointsPath, "part-m-0"), this.conf)) {
            collector.collect((WritableComparable)record.getFirst(), (Writable)record.getSecond());
        }
        int clusterSize = collector.getKeys().size();
        ClusterOutputPostProcessorTest.assertTrue((clusterSize == 1 || clusterSize == 2 ? 1 : 0) != 0);
    }

    private void assertPostProcessedOutput(Map<String, Path> postProcessedClusterDirectories) {
        for (Map.Entry<String, Path> cluster : postProcessedClusterDirectories.entrySet()) {
            this.assertTopLevelCluster(cluster);
        }
    }

    private Map<String, Path> ouputPostProcessing(Configuration conf) throws IOException {
        ClusterOutputPostProcessor clusterOutputPostProcessor = new ClusterOutputPostProcessor(this.outputPath, this.outputPath, conf);
        clusterOutputPostProcessor.process();
        return clusterOutputPostProcessor.getPostProcessedClusterDirectories();
    }

    private void topLevelClustering(Path pointsPath, Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        CanopyDriver.run((Configuration)conf, (Path)pointsPath, (Path)this.outputPath, (DistanceMeasure)new ManhattanDistanceMeasure(), (double)3.1, (double)2.1, (boolean)true, (double)0.0, (boolean)true);
    }
}

