/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.spectral.UnitVectorizerJob;
import org.apache.mahout.common.DummyRecordWriter;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.junit.Test;

public class TestUnitVectorizerJob
extends MahoutTestCase {
    private static final double[][] RAW = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};

    @Test
    public void testUnitVectorizerMapper() throws Exception {
        int i;
        UnitVectorizerJob.UnitVectorizerMapper mapper = new UnitVectorizerJob.UnitVectorizerMapper();
        Configuration conf = this.getConfiguration();
        DummyRecordWriter writer = new DummyRecordWriter();
        Mapper.Context context = DummyRecordWriter.build(mapper, conf, writer);
        for (i = 0; i < RAW.length; ++i) {
            RandomAccessSparseVector vector = new RandomAccessSparseVector(RAW[i].length);
            vector.assign(RAW[i]);
            mapper.map(new IntWritable(i), new VectorWritable((Vector)vector), context);
        }
        TestUnitVectorizerJob.assertEquals((String)"Number of map results", (long)RAW.length, (long)writer.getData().size());
        for (i = 0; i < RAW.length; ++i) {
            IntWritable key = new IntWritable(i);
            List list = writer.getValue(key);
            TestUnitVectorizerJob.assertEquals((String)"Only one element per row", (long)1L, (long)list.size());
            Vector v = ((VectorWritable)list.get(0)).get();
            TestUnitVectorizerJob.assertTrue((String)"Unit vector sum is 1 or differs by 0.0001", (Math.abs(v.norm(2.0) - 1.0) < 1.0E-6 ? 1 : 0) != 0);
        }
    }
}

