/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.spectral.IntDoublePairWritable;
import org.apache.mahout.clustering.spectral.MatrixDiagonalizeJob;
import org.apache.mahout.common.DummyRecordWriter;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.junit.Test;

public class TestMatrixDiagonalizeJob
extends MahoutTestCase {
    private static final double[][] RAW = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
    private static final int RAW_DIMENSIONS = 3;

    private static double rowSum(double[] row) {
        double sum = 0.0;
        for (double r : row) {
            sum += r;
        }
        return sum;
    }

    @Test
    public void testMatrixDiagonalizeMapper() throws Exception {
        MatrixDiagonalizeJob.MatrixDiagonalizeMapper mapper = new MatrixDiagonalizeJob.MatrixDiagonalizeMapper();
        Configuration conf = this.getConfiguration();
        conf.setInt("org.apache.mahout.clustering.spectral.common.affinitydimensions", 3);
        DummyRecordWriter writer = new DummyRecordWriter();
        Mapper.Context context = DummyRecordWriter.build(mapper, conf, writer);
        for (int i = 0; i < 3; ++i) {
            RandomAccessSparseVector toAdd = new RandomAccessSparseVector(3);
            toAdd.assign(RAW[i]);
            mapper.map(new IntWritable(i), new VectorWritable((Vector)toAdd), context);
        }
        TestMatrixDiagonalizeJob.assertEquals((String)"Number of map results", (long)3L, (long)writer.getValue(NullWritable.get()).size());
    }

    @Test
    public void testMatrixDiagonalizeReducer() throws Exception {
        MatrixDiagonalizeJob.MatrixDiagonalizeMapper mapper = new MatrixDiagonalizeJob.MatrixDiagonalizeMapper();
        Configuration conf = this.getConfiguration();
        conf.setInt("org.apache.mahout.clustering.spectral.common.affinitydimensions", 3);
        DummyRecordWriter mapWriter = new DummyRecordWriter();
        Mapper.Context mapContext = DummyRecordWriter.build(mapper, conf, mapWriter);
        for (int i = 0; i < 3; ++i) {
            RandomAccessSparseVector toAdd = new RandomAccessSparseVector(3);
            toAdd.assign(RAW[i]);
            mapper.map(new IntWritable(i), new VectorWritable((Vector)toAdd), mapContext);
        }
        MatrixDiagonalizeJob.MatrixDiagonalizeReducer reducer = new MatrixDiagonalizeJob.MatrixDiagonalizeReducer();
        DummyRecordWriter redWriter = new DummyRecordWriter();
        Reducer.Context redContext = DummyRecordWriter.build(reducer, conf, redWriter, NullWritable.class, IntDoublePairWritable.class);
        reducer.reduce(NullWritable.get(), mapWriter.getValue(NullWritable.get()), redContext);
        List list = redWriter.getValue(NullWritable.get());
        TestMatrixDiagonalizeJob.assertEquals((String)"Only a single resulting vector", (long)1L, (long)list.size());
        Vector v = ((VectorWritable)list.get(0)).get();
        for (int i = 0; i < v.size(); ++i) {
            TestMatrixDiagonalizeJob.assertEquals((String)"Element sum is correct", (double)TestMatrixDiagonalizeJob.rowSum(RAW[i]), (double)v.get(i), (double)0.01);
        }
    }
}

