/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.stats.Sampler;

public final class ClusteringTestUtils {
    private ClusteringTestUtils() {
    }

    public static void writePointsToFile(Iterable<VectorWritable> points, Path path, FileSystem fs, Configuration conf) throws IOException {
        ClusteringTestUtils.writePointsToFile(points, false, path, fs, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePointsToFile(Iterable<VectorWritable> points, boolean intWritable, Path path, FileSystem fs, Configuration conf) throws IOException {
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, path, intWritable ? IntWritable.class : LongWritable.class, VectorWritable.class);
        try {
            int recNum = 0;
            for (VectorWritable point : points) {
                IntWritable intWritable2;
                if (intWritable) {
                    ++recNum;
                    intWritable2 = new IntWritable(recNum);
                } else {
                    ++recNum;
                    intWritable2 = new LongWritable((long)recNum);
                }
                writer.append((Writable)intWritable2, (Writable)point);
            }
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
    }

    public static Matrix sampledCorpus(Matrix matrix, Random random, int numDocs, int numSamples, int numTopicsPerDoc) {
        SparseRowMatrix corpus = new SparseRowMatrix(numDocs, matrix.numCols());
        LDASampler modelSampler = new LDASampler(matrix, random);
        DenseVector topicVector = new DenseVector(matrix.numRows());
        for (int i = 0; i < numTopicsPerDoc; ++i) {
            int topic = random.nextInt(topicVector.size());
            topicVector.set(topic, topicVector.get(topic) + 1.0);
        }
        for (int docId = 0; docId < numDocs; ++docId) {
            for (int sample : modelSampler.sample((Vector)topicVector, numSamples)) {
                corpus.set(docId, sample, corpus.get(docId, sample) + 1.0);
            }
        }
        return corpus;
    }

    public static Matrix randomStructuredModel(int numTopics, int numTerms) {
        return ClusteringTestUtils.randomStructuredModel(numTopics, numTerms, new DoubleFunction(){

            public double apply(double d) {
                return 1.0 / (1.0 + Math.abs(d));
            }
        });
    }

    public static Matrix randomStructuredModel(int numTopics, int numTerms, DoubleFunction decay) {
        DenseMatrix model = new DenseMatrix(numTopics, numTerms);
        int width = numTerms / numTopics;
        for (int topic = 0; topic < numTopics; ++topic) {
            int topicCentroid = width * (1 + topic);
            for (int i = 0; i < numTerms; ++i) {
                int distance = Math.abs(topicCentroid - i);
                if (distance > numTerms / 2) {
                    distance = numTerms - distance;
                }
                double v = decay.apply((double)distance);
                model.set(topic, i, v);
            }
        }
        return model;
    }

    static class LDASampler {
        private final Random random;
        private final Sampler[] samplers;

        LDASampler(Matrix model, Random random) {
            this.random = random;
            this.samplers = new Sampler[model.numRows()];
            for (int i = 0; i < this.samplers.length; ++i) {
                this.samplers[i] = new Sampler(random, model.viewRow(i));
            }
        }

        public int[] sample(Vector topicDistribution, int numSamples) {
            Preconditions.checkNotNull((Object)topicDistribution);
            Preconditions.checkArgument((numSamples > 0 ? 1 : 0) != 0, (Object)"numSamples must be positive");
            Preconditions.checkArgument((topicDistribution.size() == this.samplers.length ? 1 : 0) != 0, (Object)"topicDistribution must have same cardinality as the sampling model");
            int[] samples = new int[numSamples];
            Sampler topicSampler = new Sampler(this.random, topicDistribution);
            for (int i = 0; i < numSamples; ++i) {
                samples[i] = this.samplers[topicSampler.sample()].sample();
            }
            return samples;
        }
    }
}

