/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmUtils;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;

public class HMMTestBase
extends MahoutTestCase {
    private HmmModel model;
    private final int[] sequence = new int[]{1, 0, 2, 2, 0, 0, 1};

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String[] hiddenNames = new String[]{"H0", "H1", "H2", "H3"};
        String[] outputNames = new String[]{"O0", "O1", "O2"};
        double[][] transitionP = new double[][]{{0.5, 0.1, 0.1, 0.3}, {0.4, 0.4, 0.1, 0.1}, {0.1, 0.0, 0.8, 0.1}, {0.1, 0.1, 0.1, 0.7}};
        double[][] emissionP = new double[][]{{0.8, 0.1, 0.1}, {0.6, 0.1, 0.3}, {0.1, 0.8, 0.1}, {0.0, 0.1, 0.9}};
        double[] initialP = new double[]{0.2, 0.1, 0.4, 0.3};
        this.model = new HmmModel((Matrix)new DenseMatrix((double[][])transitionP), (Matrix)new DenseMatrix((double[][])emissionP), (Vector)new DenseVector(initialP));
        this.model.registerHiddenStateNames(hiddenNames);
        this.model.registerOutputStateNames(outputNames);
        HmmUtils.validate((HmmModel)this.model);
    }

    protected HmmModel getModel() {
        return this.model;
    }

    protected int[] getSequence() {
        return this.sequence;
    }
}

