/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.training;

import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.classifier.naivebayes.training.IndexInstancesMapper;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenObjectIntHashMap;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class IndexInstancesMapperTest
extends MahoutTestCase {
    private Mapper.Context ctx;
    private OpenObjectIntHashMap<String> labelIndex;
    private VectorWritable instance;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ctx = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        this.instance = new VectorWritable((Vector)new DenseVector(new double[]{1.0, 0.0, 1.0, 1.0, 0.0}));
        this.labelIndex = new OpenObjectIntHashMap();
        this.labelIndex.put((Object)"bird", 0);
        this.labelIndex.put((Object)"cat", 1);
    }

    @Test
    public void index() throws Exception {
        this.ctx.write((Object)new IntWritable(0), (Object)this.instance);
        EasyMock.replay((Object[])new Object[]{this.ctx});
        IndexInstancesMapper indexInstances = new IndexInstancesMapper();
        IndexInstancesMapperTest.setField(indexInstances, "labelIndex", this.labelIndex);
        indexInstances.map(new Text("/bird/"), this.instance, this.ctx);
        EasyMock.verify((Object[])new Object[]{this.ctx});
    }

    @Test
    public void skip() throws Exception {
        Counter skippedInstances = (Counter)EasyMock.createMock(Counter.class);
        EasyMock.expect((Object)this.ctx.getCounter((Enum)IndexInstancesMapper.Counter.SKIPPED_INSTANCES)).andReturn((Object)skippedInstances);
        skippedInstances.increment(1L);
        EasyMock.replay((Object[])new Object[]{this.ctx, skippedInstances});
        IndexInstancesMapper indexInstances = new IndexInstancesMapper();
        IndexInstancesMapperTest.setField(indexInstances, "labelIndex", this.labelIndex);
        indexInstances.map(new Text("/fish/"), this.instance, this.ctx);
        EasyMock.verify((Object[])new Object[]{this.ctx, skippedInstances});
    }
}

