/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.data;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataLoader;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.DescriptorException;
import org.apache.mahout.classifier.df.data.DescriptorUtils;
import org.apache.mahout.common.MahoutTestCase;

@Deprecated
public final class Utils {
    private static final int CATEGORICAL_RANGE = 100;

    private Utils() {
    }

    public static char[] randomTokens(Random rng, int nbTokens) {
        char[] result = new char[nbTokens];
        for (int token = 0; token < nbTokens; ++token) {
            double rand = rng.nextDouble();
            result[token] = rand < 0.1 ? 73 : (rand >= 0.5 ? 67 : 78);
        }
        result[rng.nextInt((int)nbTokens)] = 76;
        return result;
    }

    public static String generateDescriptor(char[] tokens) {
        StringBuilder builder = new StringBuilder();
        for (char token : tokens) {
            builder.append(token).append(' ');
        }
        return builder.toString();
    }

    public static String randomDescriptor(Random rng, int nbAttributes) {
        return Utils.generateDescriptor(Utils.randomTokens(rng, nbAttributes));
    }

    public static double[][] randomDoubles(Random rng, CharSequence descriptor, boolean regression, int number) throws DescriptorException {
        Dataset.Attribute[] attrs = DescriptorUtils.parseDescriptor((CharSequence)descriptor);
        double[][] data = new double[number][];
        for (int index = 0; index < number; ++index) {
            data[index] = Utils.randomVector(rng, attrs, regression);
        }
        return data;
    }

    public static Data randomData(Random rng, int nbAttributes, boolean regression, int size) throws DescriptorException {
        String descriptor = Utils.randomDescriptor(rng, nbAttributes);
        double[][] source = Utils.randomDoubles(rng, descriptor, regression, size);
        String[] sData = Utils.double2String(source);
        Dataset dataset = DataLoader.generateDataset((CharSequence)descriptor, (boolean)regression, (String[])sData);
        return DataLoader.loadData((Dataset)dataset, (String[])sData);
    }

    private static double[] randomVector(Random rng, Dataset.Attribute[] attrs, boolean regression) {
        double[] vector = new double[attrs.length];
        for (int attr = 0; attr < attrs.length; ++attr) {
            vector[attr] = attrs[attr].isIgnored() ? Double.NaN : (attrs[attr].isNumerical() ? rng.nextDouble() : (attrs[attr].isCategorical() ? (double)rng.nextInt(100) : (regression ? rng.nextDouble() : (double)rng.nextInt(100))));
        }
        return vector;
    }

    private static String double2String(double[] v) {
        StringBuilder builder = new StringBuilder();
        for (double aV : v) {
            builder.append(aV).append(',');
        }
        return builder.toString();
    }

    public static String[] double2String(double[][] source) {
        String[] output = new String[source.length];
        for (int index = 0; index < source.length; ++index) {
            output[index] = Utils.double2String(source[index]);
        }
        return output;
    }

    public static double[][] randomDoublesWithSameLabel(Random rng, CharSequence descriptor, boolean regression, int number, int value) throws DescriptorException {
        int label = Utils.findLabel(descriptor);
        double[][] source = Utils.randomDoubles(rng, descriptor, regression, number);
        for (int index = 0; index < number; ++index) {
            source[index][label] = value;
        }
        return source;
    }

    public static int findLabel(CharSequence descriptor) throws DescriptorException {
        Object[] attrs = DescriptorUtils.parseDescriptor((CharSequence)descriptor);
        return ArrayUtils.indexOf((Object[])attrs, (Object)Dataset.Attribute.LABEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDataToFile(String[] sData, Path path) throws IOException {
        BufferedWriter output = null;
        try {
            output = Files.newWriter((File)new File(path.toString()), (Charset)Charsets.UTF_8);
            for (String line : sData) {
                output.write(line);
                output.write(10);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(output, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)output, (boolean)false);
    }

    public static Path writeDataToTestFile(String[] sData) throws IOException {
        Path testData = new Path("testdata/Data");
        MahoutTestCase ca = new MahoutTestCase();
        FileSystem fs = testData.getFileSystem(ca.getConfiguration());
        if (!fs.exists(testData)) {
            fs.mkdirs(testData);
        }
        Path path = new Path(testData, "DataLoaderTest.data");
        Utils.writeDataToFile(sData, path);
        return path;
    }

    public static String[][] splitData(String[] sData, int numMaps) {
        int nbInstances = sData.length;
        int partitionSize = nbInstances / numMaps;
        String[][] splits = new String[numMaps][];
        for (int partition = 0; partition < numMaps; ++partition) {
            int from = partition * partitionSize;
            int to = partition == numMaps - 1 ? nbInstances : (partition + 1) * partitionSize;
            splits[partition] = Arrays.copyOfRange(sData, from, to);
        }
        return splits;
    }
}

