/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.data;

import java.util.Random;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.DescriptorException;
import org.apache.mahout.classifier.df.data.DescriptorUtils;
import org.apache.mahout.classifier.df.data.Utils;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.junit.Test;

@Deprecated
public final class DescriptorUtilsTest
extends MahoutTestCase {
    @Test
    public void testParseDescriptor() throws Exception {
        int n = 10;
        int maxnbAttributes = 100;
        RandomWrapper rng = RandomUtils.getRandom();
        for (int nloop = 0; nloop < n; ++nloop) {
            int nbAttributes = rng.nextInt(maxnbAttributes) + 1;
            char[] tokens = Utils.randomTokens((Random)rng, nbAttributes);
            Dataset.Attribute[] attrs = DescriptorUtils.parseDescriptor((CharSequence)Utils.generateDescriptor(tokens));
            DescriptorUtilsTest.assertEquals((String)"attributes size", (long)nbAttributes, (long)attrs.length);
            block7: for (int attr = 0; attr < nbAttributes; ++attr) {
                switch (tokens[attr]) {
                    case 'I': {
                        DescriptorUtilsTest.assertTrue((boolean)attrs[attr].isIgnored());
                        continue block7;
                    }
                    case 'N': {
                        DescriptorUtilsTest.assertTrue((boolean)attrs[attr].isNumerical());
                        continue block7;
                    }
                    case 'C': {
                        DescriptorUtilsTest.assertTrue((boolean)attrs[attr].isCategorical());
                        continue block7;
                    }
                    case 'L': {
                        DescriptorUtilsTest.assertTrue((boolean)attrs[attr].isLabel());
                    }
                }
            }
        }
    }

    @Test
    public void testGenerateDescription() throws Exception {
        DescriptorUtilsTest.validate("", "");
        DescriptorUtilsTest.validate("I L C C N N N C", "I L C C N N N C");
        DescriptorUtilsTest.validate("I L C C N N N C", "I L 2 C 3 N C");
        DescriptorUtilsTest.validate("I L C C N N N C", " I L  2 C 3 N C ");
        try {
            DescriptorUtilsTest.validate("", "I L 2 2 C 2 N C");
            DescriptorUtilsTest.fail((String)"2 consecutive multiplicators");
        }
        catch (DescriptorException e) {
            // empty catch block
        }
        try {
            DescriptorUtilsTest.validate("", "I L 2 C -2 N C");
            DescriptorUtilsTest.fail((String)"negative multiplicator");
        }
        catch (DescriptorException descriptorException) {
            // empty catch block
        }
    }

    private static void validate(String descriptor, CharSequence description) throws DescriptorException {
        DescriptorUtilsTest.assertEquals((Object)descriptor, (Object)DescriptorUtils.generateDescriptor((CharSequence)description));
    }
}

