/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.data;

import java.util.Arrays;
import java.util.Random;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataLoader;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.classifier.df.data.Utils;
import org.apache.mahout.classifier.df.data.conditions.Condition;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.junit.Test;

@Deprecated
public class DataTest
extends MahoutTestCase {
    private static final int ATTRIBUTE_COUNT = 10;
    private static final int DATA_SIZE = 100;
    private Random rng;
    private Data classifierData;
    private Data regressionData;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.rng = RandomUtils.getRandom();
        this.classifierData = Utils.randomData(this.rng, 10, false, 100);
        this.regressionData = Utils.randomData(this.rng, 10, true, 100);
    }

    @Test
    public void testSubset() {
        int n = 10;
        for (int nloop = 0; nloop < n; ++nloop) {
            Instance instance;
            int index;
            int attr = this.rng.nextInt(this.classifierData.getDataset().nbAttributes());
            double[] values = this.classifierData.values(attr);
            double value = values[this.rng.nextInt(values.length)];
            Data eSubset = this.classifierData.subset(Condition.equals((int)attr, (double)value));
            Data lSubset = this.classifierData.subset(Condition.lesser((int)attr, (double)value));
            Data gSubset = this.classifierData.subset(Condition.greaterOrEquals((int)attr, (double)value));
            for (index = 0; index < 100; ++index) {
                instance = this.classifierData.get(index);
                if (instance.get(attr) < value) {
                    DataTest.assertTrue((boolean)lSubset.contains(instance));
                    DataTest.assertFalse((boolean)eSubset.contains(instance));
                    DataTest.assertFalse((boolean)gSubset.contains(instance));
                    continue;
                }
                if (instance.get(attr) == value) {
                    DataTest.assertFalse((boolean)lSubset.contains(instance));
                    DataTest.assertTrue((boolean)eSubset.contains(instance));
                    DataTest.assertTrue((boolean)gSubset.contains(instance));
                    continue;
                }
                DataTest.assertFalse((boolean)lSubset.contains(instance));
                DataTest.assertFalse((boolean)eSubset.contains(instance));
                DataTest.assertTrue((boolean)gSubset.contains(instance));
            }
            attr = this.rng.nextInt(this.regressionData.getDataset().nbAttributes());
            values = this.regressionData.values(attr);
            value = values[this.rng.nextInt(values.length)];
            eSubset = this.regressionData.subset(Condition.equals((int)attr, (double)value));
            lSubset = this.regressionData.subset(Condition.lesser((int)attr, (double)value));
            gSubset = this.regressionData.subset(Condition.greaterOrEquals((int)attr, (double)value));
            for (index = 0; index < 100; ++index) {
                instance = this.regressionData.get(index);
                if (instance.get(attr) < value) {
                    DataTest.assertTrue((boolean)lSubset.contains(instance));
                    DataTest.assertFalse((boolean)eSubset.contains(instance));
                    DataTest.assertFalse((boolean)gSubset.contains(instance));
                    continue;
                }
                if (instance.get(attr) == value) {
                    DataTest.assertFalse((boolean)lSubset.contains(instance));
                    DataTest.assertTrue((boolean)eSubset.contains(instance));
                    DataTest.assertTrue((boolean)gSubset.contains(instance));
                    continue;
                }
                DataTest.assertFalse((boolean)lSubset.contains(instance));
                DataTest.assertFalse((boolean)eSubset.contains(instance));
                DataTest.assertTrue((boolean)gSubset.contains(instance));
            }
        }
    }

    @Test
    public void testValues() throws Exception {
        int index;
        double[] values;
        int attr;
        for (attr = 0; attr < this.classifierData.getDataset().nbAttributes(); ++attr) {
            values = this.classifierData.values(attr);
            for (index = 0; index < 100; ++index) {
                DataTest.assertEquals((long)1L, (long)DataTest.count(values, this.classifierData.get(index).get(attr)));
            }
        }
        for (attr = 0; attr < this.regressionData.getDataset().nbAttributes(); ++attr) {
            values = this.regressionData.values(attr);
            for (index = 0; index < 100; ++index) {
                DataTest.assertEquals((long)1L, (long)DataTest.count(values, this.regressionData.get(index).get(attr)));
            }
        }
    }

    private static int count(double[] values, double value) {
        int count = 0;
        for (double v : values) {
            if (v != value) continue;
            ++count;
        }
        return count;
    }

    @Test
    public void testIdenticalTrue() throws Exception {
        Dataset dataset = Utils.randomData(this.rng, 10, false, 1).getDataset();
        Data empty = new Data(dataset);
        DataTest.assertTrue((boolean)empty.isIdentical());
        Data identical = Utils.randomData(this.rng, 10, false, 100);
        Instance model = identical.get(0);
        for (int index = 1; index < 100; ++index) {
            for (int attr = 0; attr < identical.getDataset().nbAttributes(); ++attr) {
                identical.get(index).set(attr, model.get(attr));
            }
        }
        DataTest.assertTrue((boolean)identical.isIdentical());
    }

    @Test
    public void testIdenticalFalse() throws Exception {
        int n = 10;
        for (int nloop = 0; nloop < n; ++nloop) {
            Data data = Utils.randomData(this.rng, 10, false, 100);
            int index = this.rng.nextInt(100);
            Instance instance = data.get(index);
            int attr = this.rng.nextInt(data.getDataset().nbAttributes());
            instance.set(attr, instance.get(attr) + 1.0);
            DataTest.assertFalse((boolean)data.isIdentical());
        }
    }

    @Test
    public void testIdenticalLabelTrue() throws Exception {
        Dataset dataset = Utils.randomData(this.rng, 10, false, 1).getDataset();
        Data empty = new Data(dataset);
        DataTest.assertTrue((boolean)empty.identicalLabel());
        String descriptor = Utils.randomDescriptor(this.rng, 10);
        double[][] source = Utils.randomDoublesWithSameLabel(this.rng, descriptor, false, 100, this.rng.nextInt());
        String[] sData = Utils.double2String(source);
        dataset = DataLoader.generateDataset((CharSequence)descriptor, (boolean)false, (String[])sData);
        Data data = DataLoader.loadData((Dataset)dataset, (String[])sData);
        DataTest.assertTrue((boolean)data.identicalLabel());
    }

    @Test
    public void testIdenticalLabelFalse() throws Exception {
        int n = 10;
        for (int nloop = 0; nloop < n; ++nloop) {
            String descriptor = Utils.randomDescriptor(this.rng, 10);
            int label = Utils.findLabel(descriptor);
            double[][] source = Utils.randomDoublesWithSameLabel(this.rng, descriptor, false, 100, this.rng.nextInt());
            int index = this.rng.nextInt(100);
            double[] dArray = source[index];
            int n2 = label;
            dArray[n2] = dArray[n2] + 1.0;
            String[] sData = Utils.double2String(source);
            Dataset dataset = DataLoader.generateDataset((CharSequence)descriptor, (boolean)false, (String[])sData);
            Data data = DataLoader.loadData((Dataset)dataset, (String[])sData);
            DataTest.assertFalse((boolean)data.identicalLabel());
        }
    }

    @Test
    public void testBagging() {
        int index;
        Data bag = this.classifierData.bagging(this.rng);
        DataTest.assertEquals((long)this.classifierData.size(), (long)bag.size());
        boolean found = false;
        for (index = 0; index < this.classifierData.size() && !found; ++index) {
            found = !bag.contains(this.classifierData.get(index));
        }
        DataTest.assertTrue((String)"some instances from data should not be in the bag", (boolean)found);
        bag = this.regressionData.bagging(this.rng);
        DataTest.assertEquals((long)this.regressionData.size(), (long)bag.size());
        found = false;
        for (index = 0; index < this.regressionData.size() && !found; ++index) {
            found = !bag.contains(this.regressionData.get(index));
        }
        DataTest.assertTrue((String)"some instances from data should not be in the bag", (boolean)found);
    }

    @Test
    public void testRsplit() {
        Data source = this.classifierData.clone();
        Data subset = source.rsplit(this.rng, 0);
        DataTest.assertTrue((String)"subset should be empty", (boolean)subset.isEmpty());
        DataTest.assertEquals((String)"source.size is incorrect", (long)100L, (long)source.size());
        source = this.classifierData.clone();
        subset = source.rsplit(this.rng, 100);
        DataTest.assertEquals((String)"subset.size is incorrect", (long)100L, (long)subset.size());
        DataTest.assertTrue((String)"source should be empty", (boolean)source.isEmpty());
        int subsize = this.rng.nextInt(100);
        source = this.classifierData.clone();
        subset = source.rsplit(this.rng, subsize);
        DataTest.assertEquals((String)"subset.size is incorrect", (long)subsize, (long)subset.size());
        DataTest.assertEquals((String)"source.size is incorrect", (long)(100 - subsize), (long)source.size());
        source = this.regressionData.clone();
        subset = source.rsplit(this.rng, 0);
        DataTest.assertTrue((String)"subset should be empty", (boolean)subset.isEmpty());
        DataTest.assertEquals((String)"source.size is incorrect", (long)100L, (long)source.size());
        source = this.regressionData.clone();
        subset = source.rsplit(this.rng, 100);
        DataTest.assertEquals((String)"subset.size is incorrect", (long)100L, (long)subset.size());
        DataTest.assertTrue((String)"source should be empty", (boolean)source.isEmpty());
        subsize = this.rng.nextInt(100);
        source = this.regressionData.clone();
        subset = source.rsplit(this.rng, subsize);
        DataTest.assertEquals((String)"subset.size is incorrect", (long)subsize, (long)subset.size());
        DataTest.assertEquals((String)"source.size is incorrect", (long)(100 - subsize), (long)source.size());
    }

    @Test
    public void testCountLabel() throws Exception {
        Dataset dataset = this.classifierData.getDataset();
        int[] counts = new int[dataset.nblabels()];
        int n = 10;
        for (int nloop = 0; nloop < n; ++nloop) {
            Arrays.fill(counts, 0);
            this.classifierData.countLabels(counts);
            for (int index = 0; index < this.classifierData.size(); ++index) {
                int n2 = (int)dataset.getLabel(this.classifierData.get(index));
                counts[n2] = counts[n2] - 1;
            }
            for (int label = 0; label < this.classifierData.getDataset().nblabels(); ++label) {
                DataTest.assertEquals((String)"Wrong label 'equals' count", (long)0L, (long)counts[0]);
            }
        }
    }

    @Test
    public void testMajorityLabel() throws Exception {
        double[] vector;
        String descriptor = Utils.randomDescriptor(this.rng, 10);
        int label = Utils.findLabel(descriptor);
        int label1 = this.rng.nextInt();
        double[][] source = Utils.randomDoublesWithSameLabel(this.rng, descriptor, false, 100, label1);
        String[] sData = Utils.double2String(source);
        Dataset dataset = DataLoader.generateDataset((CharSequence)descriptor, (boolean)false, (String[])sData);
        Data data = DataLoader.loadData((Dataset)dataset, (String[])sData);
        int code1 = dataset.labelCode(Double.toString(label1));
        DataTest.assertEquals((long)code1, (long)data.majorityLabel(this.rng));
        int label2 = label1 + 1;
        int nblabel2 = 51;
        while (nblabel2 > 0) {
            double[] vector2 = source[this.rng.nextInt(100)];
            if (vector2[label] == (double)label2) continue;
            vector2[label] = label2;
            --nblabel2;
        }
        sData = Utils.double2String(source);
        dataset = DataLoader.generateDataset((CharSequence)descriptor, (boolean)false, (String[])sData);
        data = DataLoader.loadData((Dataset)dataset, (String[])sData);
        int code2 = dataset.labelCode(Double.toString(label2));
        DataTest.assertEquals((long)code2, (long)data.majorityLabel(this.rng));
        while ((vector = source[this.rng.nextInt(100)])[label] != (double)label2) {
        }
        vector[label] = label1;
        sData = Utils.double2String(source);
        data = DataLoader.loadData((Dataset)dataset, (String[])sData);
        code1 = dataset.labelCode(Double.toString(label1));
        code2 = dataset.labelCode(Double.toString(label2));
        boolean found1 = false;
        boolean found2 = false;
        for (int index = 0; !(index >= 10 || found1 && found2); ++index) {
            int major = data.majorityLabel(this.rng);
            if (major == code1) {
                found1 = true;
            }
            if (major != code2) continue;
            found2 = true;
        }
        DataTest.assertTrue((found1 && found2 ? 1 : 0) != 0);
    }
}

