/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.file;

import java.io.File;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.file.FileDataModel;
import org.apache.mahout.cf.taste.impl.neighborhood.NearestNUserNeighborhood;
import org.apache.mahout.cf.taste.impl.recommender.GenericUserBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.PearsonCorrelationSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;
import org.junit.Before;
import org.junit.Test;

public final class FileDataModelTest
extends TasteTestCase {
    private static final String[] DATA = new String[]{"123,456,0.1", "123,789,0.6", "123,654,0.7", "234,123,0.5", "234,234,1.0", "234,999,0.9", "345,789,0.6", "345,654,0.7", "345,123,1.0", "345,234,0.5", "345,999,0.5", "456,456,0.1", "456,789,0.5", "456,654,0.0", "456,999,0.2"};
    private static final String[] DATA_SPLITTED_WITH_TWO_SPACES = new String[]{"123  456  0.1", "123  789  0.6", "123  654  0.7", "234  123  0.5", "234  234  1.0", "234  999  0.9", "345  789  0.6", "345  654  0.7", "345  123  1.0", "345  234  0.5", "345  999  0.5", "456  456  0.1", "456  789  0.5", "456  654  0.0", "456  999  0.2"};
    private DataModel model;
    private File testFile;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.testFile = this.getTestTempFile("test.txt");
        FileDataModelTest.writeLines(this.testFile, DATA);
        this.model = new FileDataModel(this.testFile);
    }

    @Test
    public void testReadRegexSplittedFile() throws Exception {
        File testFile = this.getTestTempFile("testRegex.txt");
        FileDataModelTest.writeLines(testFile, DATA_SPLITTED_WITH_TWO_SPACES);
        FileDataModel model = new FileDataModel(testFile, "\\s+");
        FileDataModelTest.assertEquals((long)model.getItemIDsFromUser(123L).size(), (long)3L);
        FileDataModelTest.assertEquals((long)model.getItemIDsFromUser(456L).size(), (long)4L);
    }

    @Test
    public void testFile() throws Exception {
        PearsonCorrelationSimilarity userSimilarity = new PearsonCorrelationSimilarity(this.model);
        NearestNUserNeighborhood neighborhood = new NearestNUserNeighborhood(3, (UserSimilarity)userSimilarity, this.model);
        GenericUserBasedRecommender recommender = new GenericUserBasedRecommender(this.model, (UserNeighborhood)neighborhood, (UserSimilarity)userSimilarity);
        FileDataModelTest.assertEquals((long)1L, (long)recommender.recommend(123L, 3).size());
        FileDataModelTest.assertEquals((long)0L, (long)recommender.recommend(234L, 3).size());
        FileDataModelTest.assertEquals((long)1L, (long)recommender.recommend(345L, 3).size());
        this.model.refresh(null);
    }

    @Test
    public void testTranspose() throws Exception {
        FileDataModel tModel = new FileDataModel(this.testFile, true, 60000L);
        PreferenceArray userPrefs = tModel.getPreferencesFromUser(456L);
        FileDataModelTest.assertNotNull((String)"user prefs are null and it shouldn't be", (Object)userPrefs);
        PreferenceArray pref = tModel.getPreferencesForItem(123L);
        FileDataModelTest.assertNotNull((String)"pref is null and it shouldn't be", (Object)pref);
        FileDataModelTest.assertEquals((String)("pref Size: " + pref.length() + " is not: " + 3), (long)3L, (long)pref.length());
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetItems() throws Exception {
        LongPrimitiveIterator it = this.model.getItemIDs();
        FileDataModelTest.assertNotNull((Object)it);
        FileDataModelTest.assertTrue((boolean)it.hasNext());
        FileDataModelTest.assertEquals((long)123L, (long)it.nextLong());
        FileDataModelTest.assertTrue((boolean)it.hasNext());
        FileDataModelTest.assertEquals((long)234L, (long)it.nextLong());
        FileDataModelTest.assertTrue((boolean)it.hasNext());
        FileDataModelTest.assertEquals((long)456L, (long)it.nextLong());
        FileDataModelTest.assertTrue((boolean)it.hasNext());
        FileDataModelTest.assertEquals((long)654L, (long)it.nextLong());
        FileDataModelTest.assertTrue((boolean)it.hasNext());
        FileDataModelTest.assertEquals((long)789L, (long)it.nextLong());
        FileDataModelTest.assertTrue((boolean)it.hasNext());
        FileDataModelTest.assertEquals((long)999L, (long)it.nextLong());
        FileDataModelTest.assertFalse((boolean)it.hasNext());
        it.next();
    }

    @Test
    public void testPreferencesForItem() throws Exception {
        PreferenceArray prefs = this.model.getPreferencesForItem(456L);
        FileDataModelTest.assertNotNull((Object)prefs);
        Preference pref1 = prefs.get(0);
        FileDataModelTest.assertEquals((long)123L, (long)pref1.getUserID());
        FileDataModelTest.assertEquals((long)456L, (long)pref1.getItemID());
        Preference pref2 = prefs.get(1);
        FileDataModelTest.assertEquals((long)456L, (long)pref2.getUserID());
        FileDataModelTest.assertEquals((long)456L, (long)pref2.getItemID());
        FileDataModelTest.assertEquals((long)2L, (long)prefs.length());
    }

    @Test
    public void testGetNumUsers() throws Exception {
        FileDataModelTest.assertEquals((long)4L, (long)this.model.getNumUsers());
    }

    @Test
    public void testNumUsersPreferring() throws Exception {
        FileDataModelTest.assertEquals((long)2L, (long)this.model.getNumUsersWithPreferenceFor(456L));
        FileDataModelTest.assertEquals((long)0L, (long)this.model.getNumUsersWithPreferenceFor(111L));
        FileDataModelTest.assertEquals((long)0L, (long)this.model.getNumUsersWithPreferenceFor(111L, 456L));
        FileDataModelTest.assertEquals((long)2L, (long)this.model.getNumUsersWithPreferenceFor(123L, 234L));
    }

    @Test
    public void testRefresh() throws Exception {
        final MutableBoolean initialized = new MutableBoolean(false);
        Runnable initializer = new Runnable(){

            @Override
            public void run() {
                try {
                    FileDataModelTest.this.model.getNumUsers();
                    initialized.setValue(true);
                }
                catch (TasteException tasteException) {
                    // empty catch block
                }
            }
        };
        new Thread(initializer).start();
        Thread.sleep(1000L);
        this.model.getNumUsers();
        FileDataModelTest.assertTrue((boolean)initialized.booleanValue());
        FileDataModelTest.assertEquals((long)4L, (long)this.model.getNumUsers());
    }

    @Test
    public void testExplicitRefreshAfterCompleteFileUpdate() throws Exception {
        File file = this.getTestTempFile("refresh");
        FileDataModelTest.writeLines(file, "123,456,3.0");
        FileDataModel dataModel = new FileDataModel(file, false, 0L);
        FileDataModelTest.assertEquals((double)3.0, (double)dataModel.getPreferenceValue(123L, 456L).floatValue(), (double)1.0E-6);
        Thread.sleep(2000L);
        FileDataModelTest.writeLines(file, "123,456,5.0");
        dataModel.refresh(null);
        FileDataModelTest.assertEquals((double)5.0, (double)dataModel.getPreferenceValue(123L, 456L).floatValue(), (double)1.0E-6);
    }

    @Test
    public void testToString() {
        FileDataModelTest.assertFalse((boolean)this.model.toString().isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyFile() throws Exception {
        File file = this.getTestTempFile("empty");
        FileDataModelTest.writeLines(file, new String[0]);
        new FileDataModel(file);
    }
}

