/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.MockRefreshable;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.junit.Test;

public final class RefreshHelperTest
extends TasteTestCase {
    @Test
    public void testCallable() {
        MockRefreshable mock = new MockRefreshable();
        RefreshHelper helper = new RefreshHelper((Callable)mock);
        helper.refresh(null);
        RefreshHelperTest.assertEquals((long)1L, (long)mock.getCallCount());
    }

    @Test
    public void testNoCallable() {
        RefreshHelper helper = new RefreshHelper(null);
        helper.refresh(null);
    }

    @Test
    public void testDependencies() {
        RefreshHelper helper = new RefreshHelper(null);
        MockRefreshable mock1 = new MockRefreshable();
        MockRefreshable mock2 = new MockRefreshable();
        helper.addDependency((Refreshable)mock1);
        helper.addDependency((Refreshable)mock2);
        helper.refresh(null);
        RefreshHelperTest.assertEquals((long)1L, (long)mock1.getCallCount());
        RefreshHelperTest.assertEquals((long)1L, (long)mock2.getCallCount());
    }

    @Test
    public void testAlreadyRefreshed() {
        RefreshHelper helper = new RefreshHelper(null);
        MockRefreshable mock1 = new MockRefreshable();
        MockRefreshable mock2 = new MockRefreshable();
        helper.addDependency((Refreshable)mock1);
        helper.addDependency((Refreshable)mock2);
        HashSet alreadyRefreshed = Sets.newHashSetWithExpectedSize((int)1);
        alreadyRefreshed.add(mock1);
        helper.refresh((Collection)alreadyRefreshed);
        RefreshHelperTest.assertEquals((long)0L, (long)mock1.getCallCount());
        RefreshHelperTest.assertEquals((long)1L, (long)mock2.getCallCount());
    }
}

