/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.cf.taste.hadoop.item.IDReader;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.junit.Test;

public class IDReaderTest
extends TasteTestCase {
    static final String USER_ITEM_FILTER_FIELD = "userItemFilter";

    @Test
    public void testUserItemFilter() throws Exception {
        Configuration conf = this.getConfiguration();
        IDReader idReader = new IDReader(conf);
        HashMap userItemFilter = Maps.newHashMap();
        long user1 = 1L;
        long user2 = 2L;
        idReader.addUserAndItemIdToUserItemFilter((Map)userItemFilter, Long.valueOf(user1), Long.valueOf(100L));
        idReader.addUserAndItemIdToUserItemFilter((Map)userItemFilter, Long.valueOf(user1), Long.valueOf(200L));
        idReader.addUserAndItemIdToUserItemFilter((Map)userItemFilter, Long.valueOf(user2), Long.valueOf(300L));
        FastIDSet userIds = IDReader.extractAllUserIdsFromUserItemFilter((Map)userItemFilter);
        IDReaderTest.assertEquals((long)2L, (long)userIds.size());
        IDReaderTest.assertTrue((boolean)userIds.contains(user1));
        IDReaderTest.assertTrue((boolean)userIds.contains(user1));
        IDReaderTest.setField(idReader, USER_ITEM_FILTER_FIELD, userItemFilter);
        FastIDSet itemsForUser1 = idReader.getItemsToRecommendForUser(Long.valueOf(user1));
        IDReaderTest.assertEquals((long)2L, (long)itemsForUser1.size());
        IDReaderTest.assertTrue((boolean)itemsForUser1.contains(100L));
        IDReaderTest.assertTrue((boolean)itemsForUser1.contains(200L));
        FastIDSet itemsForUser2 = idReader.getItemsToRecommendForUser(Long.valueOf(user2));
        IDReaderTest.assertEquals((long)1L, (long)itemsForUser2.size());
        IDReaderTest.assertTrue((boolean)itemsForUser2.contains(300L));
        FastIDSet itemsForNonExistingUser = idReader.getItemsToRecommendForUser(Long.valueOf(3L));
        IDReaderTest.assertTrue((boolean)itemsForNonExistingUser.isEmpty());
    }
}

